/* ***************************************************************** */
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2007, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/* ***************************************************************** */


/* 5724-S31                                                          */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/*********************************************************************/




var QuickrLocaleUtil = {
	resource: null,
	aResourceIndex: new Array(),
	aResourceById: new Array(),
	
	
	_stringLocale: new Array(),
	_styleLocale: new Array(),
		
	_STRINGLOCALECOOKIE: "QuickrStringLocale",
	_STYLELOCALECOOKIE: "QuickrStyleLocale",
	_ACCEPTLANGCOOKIE: "QuickrAcceptLanguages",
	
	loadLocale: function() {

		var acceptLangs = (navigator.language ? navigator.language : navigator.userLanguage);
		var bReload = false;

		if (typeof(QuickrCGIVariables)!="undefined" && (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE)) {
			acceptLangs = (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE);
		}

		if ( QuickrCookieUtil.hasCookie(this._ACCEPTLANGCOOKIE) ) {
			if (acceptLangs != QuickrCookieUtil.getCookie(this._ACCEPTLANGCOOKIE)) {
				bReload=true;
				QuickrCookieUtil.setCookie(this._ACCEPTLANGCOOKIE, acceptLangs);
			}
        }
        else {
			QuickrCookieUtil.setCookie(this._ACCEPTLANGCOOKIE, acceptLangs);
		}

		if (!bReload && QuickrCookieUtil.hasCookie(this._STRINGLOCALECOOKIE) ) {
			this._stringLocale = QuickrCookieUtil.getCookie(this._STRINGLOCALECOOKIE).split(",");
        }
        else {
			this.loadLocaleForTarget("/qphtml/skins/common", "QuickrCommonStrings.js", this._stringLocale, this._STRINGLOCALECOOKIE);
		}
		
		if (!bReload &&  QuickrCookieUtil.hasCookie(this._STYLELOCALECOOKIE) ) {
			this._styleLocale = QuickrCookieUtil.getCookie(this._STYLELOCALECOOKIE).split(",");
        }
        else {
			this.loadLocaleForTarget("/qphtml/skins/common/themes", "core.css", this._styleLocale, this._STYLELOCALECOOKIE);
		}
	
	},
	
    getSupportLocale: function(sSupportLocale, sDefaultLocale) {

        var supportLocaleList = sSupportLocale.toLowerCase().split(",");
        var supportLocaleMap = new Object();
        for (var i = 0; i < supportLocaleList.length; i++) {
            supportLocaleMap[supportLocaleList[i]] = supportLocaleList[i];
        }
        var acceptLangs = "";
        if (typeof (QuickrCGIVariables) != "undefined" && (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE)) {
            acceptLangs = (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE);
        }
        var langsSection = acceptLangs.toLowerCase().split(",");
        if (typeof (langsSection) != "undefined" && langsSection.length > 0) {
            for (var i = 0; i < langsSection.length; i++) {
                var temp = langsSection[i].split(";");
                var locale = temp[0].replace("_", "-");
                if (typeof (supportLocaleMap[locale]) != "undefined")
                    return locale;
                var lang = locale.split("-");
                if (typeof (supportLocaleMap[lang[0]]) != "undefined") {
                    return lang[0];
                }
            }
        }
        return sDefaultLocale;

    },

	loadLocaleForTarget: function(sbase, sname, atarget, scookie) {

        if (typeof(sbase) == "undefined") 
            sbase = "/qphtml/skins/common/themes";
        if (typeof(sname) == "undefined") 
            sname = "core.css";
        if (typeof(atarget) == "undefined") 
            atarget = this._styleLocale;
        if (typeof(scookie) == "undefined") 
            scookie = this._STYLELOCALECOOKIE;
		
		
		var curLanguages = QuickrLocaleUtil.buildLanguageList();
		
		var rootUrl = QuickrGeneralUtil.getRootUrl();
		

		for (var i = 0; i < curLanguages.length; i++) {
			var locale = curLanguages[i].toLowerCase();
			
			// special case for Bokmaal & Nynorsk
            if (locale == "nb-no" || locale == "nn-no") 
                locale = "no";
			
			var testurl = rootUrl + sbase + "/nls/" + locale + "/" + sname;

            QuickrXMLUtil.fireAjaxRequest(testurl, function(data, url){ //load
					var lang = url.substring(0,url.lastIndexOf("/"))
					lang = lang.substring(lang.lastIndexOf("/")+1);
					
					atarget.push(lang.toLowerCase());
					
					
            }, 5, null, null, true)
		
		}
		
		QuickrCookieUtil.setCookie(scookie, atarget.join(","));
	
	},
	
	
	

	
	loadStringFiles: function( sid, sbase, sname ) {
		var langs = this.getStringLocaleList();
		
		
		//set the languages we found
		djConfig.locale = langs[0]; //this.getSupportLocale("en,ar,da,de,el,es,fi,fr,it,iw,ja,ko,nl,no,pt,pt-br,sv,tr,zh,zh-tw", "en");
		djConfig.extraLocale = langs;
		
		dojo.locale = djConfig.locale;
		dojo.extraLocale = langs;
		
		
		
		
		//to be used for localization	
		dojo.require("dojo.i18n");
		
		dojo.registerModulePath(sid, sbase);
		
		dojo.requireLocalization(sid, sname);
		
		
		//first, let's set the current resource file
		this.resource = dojo.i18n.getLocalization(sid, sname);
		
		/*********************************
		* load any string objects into an array so we can
		* handle multiple ones on the same page.
		* 
		* We maintain two arrays:
		* 1 - so that we can loop thru all of them
		* 2 - so the client can specify the id of the string object
		*********************************/
		this.aResourceIndex[this.aResourceIndex.length] = this.resource;
		this.aResourceById[sid] = this.resource;
		
	},
	
	useOneUIV2: function() {
		//TODO - use the field flag instead of looking at the name...
		return (typeof theme_name != "undefined" && (theme_name=="quickr85" || theme_name=="quickr"));
	},
	
	useBidi: function() {
		var useLang = ( QuickrLocaleUtil.getStyleLocaleList() )[0];
		return ( useLang == "he" || useLang == "ar" );
	},
	
	loadCssFiles: function (sThemePath, sThemeCss) {
		
		var head = document.getElementsByTagName("head");
		if (head && head[0]) {
		
			//remove any legacy CSS files.  We're starting new!!!
			var linktags = head[0].getElementsByTagName("link");
			var cssRemove = new Array();
			if (linktags) {
				for (var i = 0; i < linktags.length; i++) {
					var linktag = linktags[i];
					if (linktag.type == "text/css" && linktag.href.indexOf("&Form=h_StyleSheet")> -1) {
						cssRemove[cssRemove.length] = linktag;
					}
				}
			}
			
			
			//load the css file names into this list
			var cssList = new Array();
			
			if ( QuickrLocaleUtil.useOneUIV2() ) {
			
				//code to correct IE6 not rendering styles when we dyanmically reassign stylesheets
				if (h_ClientBrowser.isIE6() && typeof(sThemeCss) != "undefined" && sThemeCss != null) {
					cssList.push( sThemePath + "/themes/" + sThemeCss );
				}				
				
				//load oneui theme css
				var CSSCOMMON_BASE = "/qphtml/skins/common/themes/oneuiv2/";
				
				var sSuffix = ( QuickrLocaleUtil.useBidi() ) ? "RTL" : "";
				
				cssList.push( CSSCOMMON_BASE + "base/core" + sSuffix + ".css" );
				cssList.push( CSSCOMMON_BASE + "base/dojo" + sSuffix + ".css" );
				
				//How does RTL effect these three css files?
				cssList.push( "/qphtml/dojo/dijit/themes/dijit.css" );
				if (QuickrLocaleUtil.useBidi()) {
					cssList.push( "/qphtml/dojo/dijit/themes/dijit_rtl.css" );
				}
                cssList.push("/qphtml/ecmintg/css/picker.css");
				
				cssList.push( CSSCOMMON_BASE + "defaultTheme/defaultTheme" + sSuffix + ".css" );
				cssList.push( CSSCOMMON_BASE + "defaultTheme/dojoTheme" + sSuffix + ".css" );
				
				//loading theme css file
				if (typeof(sThemeCss) != "undefined" && sThemeCss != null) {
					cssList.push( sThemePath + "/themes/" + sThemeCss );
				}
				
					
            }
            else {
				var useLang = ( QuickrLocaleUtil.getStyleLocaleList() )[0];
				
				//code to correct IE6 not rendering styles when we dyanmically reassign stylesheets
				if (h_ClientBrowser.isIE6() && typeof(sThemeCss) != "undefined" && sThemeCss != null) {
					cssList.push( sThemePath + "/nls/" + useLang + "/" + sThemeCss );
				}				
				
				//load oneui theme css
				var CSSCOMMON_BASE = "/qphtml/skins/common/themes/nls/" + useLang + "/";			

				cssList.push( CSSCOMMON_BASE + "core.css" );
				cssList.push( CSSCOMMON_BASE + "defaultTheme.css" );
				if ( h_ClientBrowser && h_ClientBrowser.isIE() ) {
					cssList.push( CSSCOMMON_BASE + "iehacks.css" );
				}
				//Adding person card css
				//load oneui theme css
				var CSSCOMMON_BASE_ONEUI = "/qphtml/skins/common/themes/oneuiv2/";
				var sSuffix = ( QuickrLocaleUtil.useBidi() ) ? "RTL" : "";
				cssList.push( CSSCOMMON_BASE_ONEUI + "base/standaloneVcard" + sSuffix + ".css" );
				
				//loading theme css file
				if (typeof(sThemeCss) != "undefined" && sThemeCss != null) {
					cssList.push( sThemePath + "/nls/" + useLang + "/" + sThemeCss );
				}

			}
			

			
			
			if (G_UseServletForPerformance) {
				var tmpList = cssList.join(";");
				cssList.length = 1;
				cssList[0] = QuickrGeneralUtil.getServletRoot() + "/QuickrSupportUtil?type=combinestyles&key=" + tmpList;
			}

			for (var ii = 0; ii < cssList.length; ii++) {
				var skinCss = document.createElement("link");
				skinCss.rel = ("stylesheet");
				skinCss.type = ("text/css");
				skinCss.href = (cssList[ii]);
				head[0].appendChild(skinCss);
			}
		
			for (var ii = 0; ii < cssRemove.length; ii++) {
				cssRemove[ii].parentNode.removeChild(cssRemove[ii]);
			}
			
			
		}
	
        // Load IE style tweaks if running in IE
        if (h_ClientBrowser.isIE()) {
            if (h_ClientBrowser.isIE6()) {
                document.getElementsByTagName("html")[0].className += " lotusui_ie lotusui_ie6";
            }
            else 
                if (h_ClientBrowser.isIE7()) {
                    document.getElementsByTagName("html")[0].className += " lotusui_ie lotusui_ie7";
                }               
        }
	},
	
	getStringLocaleList: function() {
		if (this._stringLocale.length == 0) {
			this.loadLocale();
		}
		return this._stringLocale.concat();		
	},
	
	getStyleLocaleList: function() {
		if (this._styleLocale.length == 0) {
			this.loadLocale();
		}
		return this._styleLocale.concat();		
	},	
	
	getAcceptLangList: function() {
		var acceptLangs = (navigator.language ? navigator.language : navigator.userLanguage);
		var bReload = false;

		if (typeof(QuickrCGIVariables)!="undefined" && (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE)) {
			acceptLangs = (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE);
		}

		if ( QuickrCookieUtil.hasCookie(this._ACCEPTLANGCOOKIE) ) {
			if (acceptLangs != QuickrCookieUtil.getCookie(this._ACCEPTLANGCOOKIE)) {
				bReload=true;
				QuickrCookieUtil.setCookie(this._ACCEPTLANGCOOKIE, acceptLangs);
			}
        }
        else {
			QuickrCookieUtil.setCookie(this._ACCEPTLANGCOOKIE, acceptLangs);
		}
		var langsSection = acceptLangs.split(";");
		if (typeof(langsSection) != "undefined" && langsSection.length > 0) {
			var lang = langsSection[0];
			return lang.split(",");
		}
		var defaultLangs = ["en"];
		return defaultLangs;
	},
	
	buildLanguageList: function() {
	
		var curLanguages = new Array();
		
		var sAllList = ";";
		
		var sDefault = "en";
		

		if (typeof(QuickrCGIVariables)!="undefined" && (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE)) {

			var tempLanguages = (QuickrCGIVariables.HTTP_Accept_language || QuickrCGIVariables.HTTP_ACCEPT_LANGUAGE).split(",");
			for (var i = 0; i < tempLanguages.length; i++) {
				if (tempLanguages[i].indexOf(";") > -1) {
					tempLanguages[i] = tempLanguages[i].split(";")[0];
				}
				
				if (sAllList.indexOf(";" + tempLanguages[i] + ";") == -1) {
					curLanguages.push(tempLanguages[i]);
					sAllList += tempLanguages[i] + ";";
				}

				if (tempLanguages[i].indexOf("-") > -1) {
					var subLang = tempLanguages[i].split("-")[0];
					if (sAllList.indexOf(";" + subLang + ";") == -1) {
						curLanguages.push(subLang);
						sAllList += subLang + ";";
					}
				}
				
								

			}
			
			if (sAllList.indexOf(";" + sDefault + ";") == -1) {
				curLanguages.push(sDefault);
				sAllList += sDefault + ";";
			}

        }
        else {
			curLanguages.push(sDefault);
		}
		
		
		return curLanguages;

	},
	
	loadScriptObject: function(idx) {

		var urlCgiScript = QuickrGeneralUtil.getServletRoot() + "/QuickrSupportUtil?type=quickrvariables";
		
		if ( navigator.userAgent.indexOf("Safari") > -1 ) {  //if it's safari, make sure the servlet is loaded on the server
			try {
			
			dojo.xhrGet({
				url: urlCgiScript,
				sync: true,
				handleAs: "text",
				load: function(response, ioArgs) {
					document.getElementById(idx).src = urlCgiScript;
				},
				error: function(response, ioArgs ) {
				}			

			});
			
			}
			catch(e) {
			}
        }
        else {
			document.getElementById(idx).src = urlCgiScript;
		}
	
	},
	
	getStringResource: function(sResName, sResGroupId) {
		var ret = null;
		
		//if someone passed in the id of the string object, try to use it.
		if ( !QuickrGeneralUtil.isBlank(sResGroupId) ) {
			try {
				ret = eval("QuickrLocaleUtil.aResourceById[\"" + sResGroupId + "\"]." + sResName);
            } 
            catch (exResource) {
            }
		}
		
		if (this.aResourceIndex.length <= 0) {
			QuickrLocaleUtil.loadStringFiles("common", "/qphtml/skins/common", "QuickrCommonStrings");
		}
		
		//if not found already, loop through all the string objects to find them...
		if ( this.aResourceIndex.length > 0 && (QuickrGeneralUtil.isBlank(ret)) ) {
			for (var i = this.aResourceIndex.length - 1; i >= 0 ; i--) {
				try {
					ret = eval("QuickrLocaleUtil.aResourceIndex[" + i + "]." + sResName);
                } 
                catch (exResource) {
                }
				
				if ( !QuickrGeneralUtil.isBlank(ret) ) {
					break;				
				}
			}
		}
		
		//not found at all, return the key with some asterisks to flag it for fixing...
		if ( QuickrGeneralUtil.isBlank(ret) ) {
			ret = "** " + sResName + " **";
		}
		return ret;
	
	},
	
	processLocalizedStringsInStr: function(str) {
		QuickrLocaleUtil.loadStringFiles("common", "/qphtml/skins/common", "QuickrCommonStrings");
		var STRING_START = "@@[";
		var STRING_END = "]@@";
		
		var proc = str;
		var ret = "";
		var arr = proc.split(STRING_START);

		for (var i = 0; i < arr.length; i++) {
			if (arr[i].indexOf(STRING_END) > -1) {
				var arr2 = arr[i].split(STRING_END);

				if (arr2[0].indexOf("QuickrLocaleUtil.resource.") != 0) {
					arr2[0] = "QuickrLocaleUtil.resource." + arr2[0];
				}

				var tmpEval = null;
				try {
					tmpEval = eval(arr2[0]);
                } 
                catch (e1) {
                }

				if (typeof(tmpEval) == "undefined" || tmpEval == null) {
					tmpEval = "**" + arr2[0] + "**";
				}

				ret += tmpEval + arr2[1];																		
			} 
            else {
				ret += arr[i];
			}
		}
		return ret;
	},
	
	processLocalizedStringsOnPage: function() {

		/*********************************************
		* This function goes through the innerHTML of
		* the body to replace the string references
		* to the localized strings.
		* String format in htm file:
		* @@[QuickrEntryStrings.StringName]@@
		*********************************************/
		var STRING_START = "@@[";
		var STRING_END = "]@@";

		//SPR#TORI79ENTF
		var elements = document.body.getElementsByTagName("*");
		var length = elements.length;
		var current;
        for (var j = 0; j < length; j++) {
			current = elements[j];

            if (current.innerHTML.indexOf(STRING_END) > -1) {

				var proc = current.innerHTML;
				var ret = "";
				var arr = proc.split(STRING_START);

				for (var i = 0; i < arr.length; i++) {
					if (arr[i].indexOf(STRING_END) > -1) {
						var arr2 = arr[i].split(STRING_END);

						if (arr2[0].indexOf("QuickrLocaleUtil.resource.") != 0) {
							arr2[0] = "QuickrLocaleUtil.resource." + arr2[0];
						}

						var tmpEval = null;

						try {
							if (arr[i-1].substring(arr[i-1].length-1) == "\"" && arr2[1].substring(0,1) == "\"") {
								tmpEval = eval(arr2[0]);
                            }
                            else {
								tmpEval = "\"" + eval(arr2[0]) + "\"";
							}
                        } 
                        catch (e1) {
                        }

						if (typeof(tmpEval) == "undefined" || tmpEval == null) {
							tmpEval = "**" + arr2[0] + "**";
						}

						ret += tmpEval + arr2[1];																		
					} 
                    else {
						ret += arr[i];
					}
				}
				current.innerHTML = ret;
			}
		}


		//any font tag with the class of "locallizedtext" needs to be pulled and the strings need to be replaced.
		var loc = QuickrGeneralUtil.getElementsByClassName("localizedtext","font");

		if (loc) {
			for (var i = loc.length - 1; i >=0; i--) {
				var att  = loc[i].getAttribute("key");

				if (att) {
                }
                else {
					att = loc[i].innerHTML;
				}

				if (att && att.length > 0) {
					if (att.indexOf("QuickrLocaleUtil.resource.") != 0) {
						att = "QuickrLocaleUtil.resource." + att;
					}

					var newstring = null;

					try {
						newstring = eval(att);
                    } 
                    catch (e2) {
                    }

					if (typeof(newstring) == "undefined" || newstring == null) {
						newstring = "**" + att + "**";
					}

					var el = null;

					//if the string contains tags, we need to set the innerhtml so the browser knows it's not just text
					if (newstring.indexOf("<") > -1 && newstring.indexOf(">") > -1) {
						var el = document.createElement("span");
						el.innerHTML = newstring;
                    }
                    else {
						var el = document.createTextNode(newstring);
					}

					loc[i].parentNode.insertBefore(el, loc[i]);
					loc[i].parentNode.removeChild(loc[i]);					
				}
			}

		}

	}
	
	

}



var QuickrGeneralUtil = {

	_defaultServletRoot: "/servlet",
	
	getJunctionString: function() {  //used to get the TAM Junction string for mapping...
		var ret = "";
		if (typeof window.G_JunctionLoc == "undefined") {
			var loc = window.location.href;
			if (typeof G_haikuBaseUrl == "string" && loc.indexOf(G_haikuBaseUrl) > -1) {
				loc = loc.substring(loc.indexOf("//") + 2);
				loc = loc.substring(loc.indexOf("/") + 1);		
				loc = loc.substring(0, loc.indexOf(G_haikuBaseUrl) - 1);
                if (loc.length > 0) 
                    ret = "/" + loc;
            }
        }
        else {
			ret = window.G_JunctionLoc;
		}
		return ret;		
	},	
	
	getServletRoot: function() {
		if (typeof window.G_ServletLoc == "undefined") {
			return QuickrGeneralUtil.getJunctionString() + QuickrGeneralUtil._defaultServletRoot;
        }
        else {
			return window.G_ServletLoc;
		}
	},
	
	getDownloadLink: function(docid, fileName, viewName) {
        if (typeof viewName == "undefined" || viewName == null) 
            viewName = "0";
		
		var encFileName = fileName;
		try {
			encFileName = decodeURIComponent(encFileName);
        } 
        catch (e) {
        }

		encFileName = encodeURIComponent(encFileName);
		encFileName = encFileName.replace(new RegExp("\#","g"),"%23");
		encFileName = encFileName.replace(/\%26amp\%3B/gi,"%26");

		var sBase = QuickrGeneralUtil.getBaseUrl();
		sBase = sBase.substring(sBase.indexOf("//")+2);
		sBase = sBase.substring(sBase.indexOf("/"));


		var url = "";
		if ( G_UseServletForDownload && !h_ClientBrowser.isSafari() ) {
			url += QuickrGeneralUtil.getServletRoot() + "/QuickrSupportUtil?type=quickrdownload&key=";
			
			encFileName = encodeURIComponent(encFileName);
			
			//remove the TAM junction because this connection will go directly to the server from the server
			var sJun = QuickrGeneralUtil.getJunctionString();
            if (sJun.length > 0) 
                sBase = sBase.replace(new RegExp(sJun, ""), "");
		}


		url += sBase + "/" + viewName + "/" + docid + "/$file/" + encFileName;


		return url;
	
	},
	
	//Used to tell if it is an office form
	isOfficeOrImportForm: function(sForm) {
		var ret = false;
		if (typeof G_FormIDs != "undefined") {
			ret = (		sForm == G_FormIDs.HTMLPageFormUNID || 
					sForm == G_FormIDs.MultipleImportFormUNID || 
					sForm == G_FormIDs.CreateMSWordFormUNID || 
					sForm == G_FormIDs.CreateMSExcelFormUNID || 
					sForm == G_FormIDs.CreateMSPowerPointFormUNID || 
					sForm == G_FormIDs.CreateOOWriterFormUNID || 
					sForm == G_FormIDs.CreateOOCalcFormUNID || 
            sForm == G_FormIDs.CreateOOImpressFormUNID);
		}

		return ret;
	},
	
	//Is the file name an internally generated one of one attached by the user
	isInternalFileName: function(sName, sForm) {
		if (typeof sForm == "undefined" || sForm == null) {
			if (typeof window.h_Form != "undefined") {
				sForm = window.h_Form;
            }
            else {
				sForm = "";
			}
		}

		var ret = (sName.search(/^TMP[0-9]{2}.*\.[gjch]/i) >= 0);

		// SPR#DAMY83KKLN
		if ( !ret ) { //&& QuickrGeneralUtil.isOfficeOrImportForm(sForm) ) {
			ret = (sName.search(/^image[0-9][0-9][0-9].[gif|jpg|jpeg|bmp|png]/i) >= 0);
		}

		return ret;
	},	
	
	
	loadSupplementalScript: function(sLocation, bCacheCompliant) {
        if (typeof bCacheCompliant == "undefined") 
            bCacheCompliant = false;
	
		if (bCacheCompliant && typeof G_CacheCompliantUrlTemplate != "undefined" && sLocation.indexOf("?") == -1) {
			sLocation = QuickrGeneralUtil.decodeEntities(G_CacheCompliantUrlTemplate).replace("{0}", sLocation);
		}
		
		//load an external js file
		/*
		var oExtObj = document.createElement("script");
		oExtObj.setAttribute("src", sLocation);
		oExtObj.setAttribute("type", "text/javascript");
		var oHeadLoc = document.getElementsByTagName("head")[0];
		if (oHeadLoc) oHeadLoc.appendChild(oExtObj);
		*/
		document.write("<script type=\"text/javascript\" src=\"" + sLocation + "\"><\/script>");
	},	
		
	
	loadCGIVariables: function(sid) {
		var targ = document.getElementById(sid);
		
		if (targ) {
			targ.src = this.getBaseUrl() + "/h_CGIVariables?Open";
		}
	
	},

	getBaseUrl: function () {
		var ret = "";
		
		var loc = window.location.href;
		var loc_l = loc.toLowerCase();
		var idx = loc_l.indexOf(".nsf");
		
		if (idx > -1) {
			ret = loc.substring(0, idx+4);
		}
		
		return ret;
	},
	
	getRootUrl: function() {
		var loc = window.location.href + ":///";
		var p1 = loc.substring(0, loc.indexOf("://") + 3);
		
		loc = loc.substring(loc.indexOf("://") + 3);
		var p2 = loc.substring(0, loc.indexOf("/"));
		
		return p1 + p2;
		
	},
	
	
    getNodeValue: function(node, idx, key){
        if (typeof(idx) == "undefined" || idx == null) 
            idx = 0;
        if (typeof(key) == "undefined" || key == null) 
            key = "text";


		var ret = "";
		var x = node[idx];
		if (x) {
			var y = x.getElementsByTagName(key);
			if (y && y[0] && y[0].firstChild) {
				ret = x.getElementsByTagName(key)[0].firstChild.nodeValue;
			}
		}

		return ret;
	},
	
	hideClassesIfTrue: function (classname, tf, bVisibility) {
		var bVis=(typeof(bVisibility)=="undefined" ? false : bVisibility);
		if ( tf ) {
			var els = QuickrGeneralUtil.getElementsByClassName(classname);
			if (els) {
				for (var i = 0; i < els.length; i++) {
					if (bVis) {
						// just make invisible
						els[i].style.height = "0";
						els[i].style.padding = "0";
						els[i].style.margin = "0";
					}
					else {
						// complete visual removal
						els[i].style.display = "none";
					}
				}
			}
		}	
	},

	showClassesIfTrue: function (classname, tf) {
		if ( tf ) {
			var els = QuickrGeneralUtil.getElementsByClassName(classname);
			if (els) {
				for (var i = 0; i < els.length; i++) {
					els[i].style.display = "block";
				}
			}
		}	
	},


	//supporting functions
    getElementsByClassName: function(className, tag, elm){
		var testClass = new RegExp("(^|\\s)" + className + "(\\s|$)");
		var tag = tag || "*";
		var elm = elm || document;
		var elements = (tag == "*" && elm.all)? elm.all : elm.getElementsByTagName(tag);
		var returnElements = [];
		var current;
		var length = elements.length;
		for(var i=0; i<length; i++){
			current = elements[i];
			if(testClass.test(current.className)){
				returnElements.push(current);
			}
		}
		return returnElements;
	},
	
	replaceQSValue: function (source, name, value) {
		var hasParam = false;
		source = "&" + source;
	
	
		idx = source.indexOf("&" + name + "=");
	
        if (idx > -1) 
            hasParam = true;
	
		if (!hasParam) {
			source += "&" + name + "=" + value;
        }
        else {
			source = source.substring(1);
			var params = source.split("&");
			source = "";
			for (var i = 0; i  < params.length; i++) {
				source += "&";
				if (params[i].indexOf(name + "=") > -1) {
					source += name + "=" + value;
                }
                else {
					source += params[i];
				}
			}
		}
	
		while (source.indexOf("&") == 0) {
			source = source.substring(1);
		}
	
		return source;
	
	},
	
	getQSValue: function (source, sname, sdefault) {
		var ret = sdefault;
		var loc = source + "&=";
	
		var idx = loc.indexOf("&"+sname+"=");
	
		if (idx > -1) {
			var sortx = loc.substring(idx);
			sortx = sortx.substring(sortx.indexOf("=")+1);
			sortx = sortx.substring(0,sortx.indexOf("&"));
	
			ret = sortx;
	
		}
	
		return ret;
	},
	
	convertToNum: function (val) {
		var decSep = haiku.h_Intl_DecimalString;
		
		var ALL_CHARS = "0123456789" + decSep;
		var ret = "";
		
		val += decSep + decSep;
		
		for (var i = 0; i < val.length; i++) {
			var chr = val.substring(i, i + 1);
			if (ALL_CHARS.indexOf(chr) > -1) {
				ret += chr;
				if (chr == decSep) {
					ALL_CHARS = "0123456789";
				}
			}
			
		}
		
		return parseFloat(ret);
	},
	
	formatBytes: function (val) {
		var BYTE_TO_KB = 1024;
		var BYTE_TO_MB = 1048576;
		var suffix = " B";
		
		var decSep = ".";
		
		
		var ret = this.convertToNum(val);
		
		if ( ret > BYTE_TO_MB ) {
			ret = ret / BYTE_TO_MB;
			suffix = " MB";
        }
        else 
		if ( ret > BYTE_TO_KB ) {
			ret = ret / BYTE_TO_KB;
			suffix = " KB";
		}
		

		
		
		ret = Math.round(ret*100)/100;
		
		var returnString = ret + suffix;
		
		if (returnString.indexOf(decSep) > -1 && decSep != haiku.h_Intl_DecimalString) {
			returnString = returnString.replace(".",haiku.h_Intl_DecimalString);
		}
		
		
		return returnString;
	
	},
	
	//if security is enabled, some of the dom preoduced has extra \ chars before quotes.  just remove them
	massageSecurityDomNode: function(node, bForce) {
		if ( typeof node == "object") {
			if (bForce || (typeof G_XSSProtectionEnabled != "undefined" && G_XSSProtectionEnabled == true) ) {
				var c = node.childNodes;
				for (var i = 0; i < c.length; i++) {
					if (c[i].nodeValue != null) {
						c[i].nodeValue = c[i].nodeValue.replace(/\\\"/g,"\"");
					}

					QuickrGeneralUtil.massageSecurityDomNode(c[i], bForce);
				}
				if (typeof c.nodeValue != "undefined") {
					c.nodeValue = c.nodeValue.replace(/\\\"/g,"\"");
				}
			}
		}
	},
	
	isBlank: function (val) {
		return (typeof(val) == "undefined" || val == "" || val == null);
	
	},
	
	c_IESPACER: " &nbsp; ",
	addIESpacingHack: function(src, stype) {  //used only in IE for BiDi LIs
        if (typeof stype == "undefined" || stype == null) 
            stype = "*";
		
		if ( h_ClientBrowser.isIE () && document.body.dir == 'rtl') {
			var aLis=src.getElementsByTagName(stype);
			for (var ii = 0; ii < aLis.length; ii++) {
				aLis[ii].innerHTML = QuickrGeneralUtil.c_IESPACER + aLis[ii].innerHTML + QuickrGeneralUtil.c_IESPACER;
			}
		}
	},
	
	isArray: function (val) {
		return (typeof val == "object" && val.constructor.toString().indexOf("Array") > -1);
	},
	
	isString: function (val) {
		return (typeof val == "string");
	},	
	
	encodeEntities: function (val) {
        if (QuickrGeneralUtil.isArray(val)) {
			for (var ii = 0; ii < val.length; ii++)
				val[ii] = QuickrGeneralUtil.encodeEntities(val[ii]);
        }
        else 
		if (QuickrGeneralUtil.isString(val)) {
			val = QuickrGeneralUtil.decodeEntities(val); //first decode whatever is there so we don't double-encode the strings...
                if ((val.indexOf("<") > -1 || val.indexOf(">") > -1 || val.indexOf("'") > -1 || val.indexOf("\"") > -1)) {
				val = val.replace(new RegExp("\&","g"),"&amp;");
				val = val.replace(new RegExp("\<","g"),"&lt;");
				val = val.replace(new RegExp("\>","g"),"&gt;");
				val = val.replace(new RegExp("\'","g"),"&#39;");
				val = val.replace(new RegExp("\"","g"),"&quot;");
			}
		}
		
		return val;
	},
	decodeEntities: function (val) {
        if (QuickrGeneralUtil.isArray(val)) {
			for (var ii = 0; ii < val.length; ii++)
				val[ii] = QuickrGeneralUtil.decodeEntities(val[ii]);
        }
        else 
            if (QuickrGeneralUtil.isString(val) && val.indexOf("&") > -1) {
			// Just in case someone encoded other than through encodeEntities() (above),
			// unwind multiple encodings of the & character here.
			while (val.indexOf("&amp;") > -1) {
				val = val.replace(new RegExp("\&amp;","g"),"&");
			}
				
			val = val.replace(new RegExp("\&lt;","g"),"<");
			val = val.replace(new RegExp("\&gt;","g"),">");
			val = val.replace(new RegExp("\&apos;","g"),"'");
			val = val.replace(new RegExp("\&\#39;","g"),"'");
			val = val.replace(new RegExp("\&quot;","g"),"\"");

		}
		return val;
	},
	
	decodeApostrophes: function (val, forceBackSlash) {
        if (typeof(forceBackSlash) == "undefined") 
            forceBackSlash = false;
        if (typeof val == "string" && val.indexOf("&") > -1) {
			val = val.replace(new RegExp("\&apos;","g"),"'");
			val = val.replace(new RegExp("\&\#39;","g"),"'");
            if (forceBackSlash) 
                val = val.replace(new RegExp("'", "g"), "\\'");
		}
		return val;
	},	
	
	encodeTag: function (src, val) {
		var ret = src;
		
		ret = ret.replace(new RegExp("  ","gi")," ");
		ret = ret.replace(new RegExp("< ","gi"),"<");
		ret = ret.replace(new RegExp("<<","gi"),"<");
		ret = ret.replace(new RegExp("<" + val,"gi"),"&lt;" + val);
		ret = ret.replace(new RegExp("<\/" + val,"gi"),"&lt;/" + val);
		
		return ret;
	},
	
	encodeAllTags: function (src) {
		var aTags = ["script","object","embed"];
		
		var ret = src;
		for (var ii = 0; ii < aTags.length; ii++) {
			ret = QuickrGeneralUtil.encodeTag(ret, aTags[ii]);
		}
		
		return ret;
	},
	
	decodeCustomFormFields: function ( aDecodeFields ) {
		for (var ii = 0; ii < aDecodeFields.length; ii++) {
			var fName = aDecodeFields[ii];
			if (typeof fieldNames[fName] == "string") {
				fieldNames[fName] = QuickrGeneralUtil.encodeAllTags(QuickrGeneralUtil.decodeEntities(fieldNames[fName]));
				window[fName] = fieldNames[fName];
			}
		}	
	},
	
	processRoomInfo: function (val) {
		
		val = QuickrGeneralUtil.decodeEntities(val);
		val = QuickrGeneralUtil.decodeEntities(val); //called twice for IE...
		val = QuickrGeneralUtil.encodeEntities(val);
		
		val = val.replace(new RegExp("var h_Room","gi"),"window.h_Room");
		
		val = val.replace(new RegExp("new Array[(]\&apos;","gi"),"new Array('");
		val = val.replace(new RegExp("&apos;,&apos;","gi"),"','");
		val = val.replace(new RegExp("&apos;[)];","gi"),"');");
		val = val.replace(new RegExp("new Array[(]\&\#39;","gi"),"new Array('");
		val = val.replace(new RegExp("\&\#39;,\&\#39;","gi"),"','");
		val = val.replace(new RegExp("\&\#39;[)];","gi"),"');");		
		val = val.replace(new RegExp("\n","gi")," ");
		
		eval(val);
	},
	
	getLinkProtocol: function(linkURL) {
		var newlink = linkURL + ":";
		return newlink.substring(0,newlink.indexOf(":"));
	},
	
	isLinkProtocolAllowed: function(linkURL) {
	
		var bOK = true;
		
		if (typeof G_FilterUriEnabled != "undefined" && typeof G_FilterUriAllowed != "undefined" && G_FilterUriEnabled) {
			
			var linkProtocol = QuickrGeneralUtil.getLinkProtocol(linkURL).toLowerCase();
			
			//always allow http and https
			if (linkProtocol != "http" && linkProtocol != "https") {
				bOK = false;
				var aSchemes = G_FilterUriAllowed.split(',');
				for (var ii = 0; ii < aSchemes.length; ii++) {
					if (aSchemes[ii].toLowerCase() == linkProtocol) {
						bOK = true;
						break;
					}
				}
			}	
		}
		
		return bOK;
	}
	
	
	

}

var QuickrDateUtil = {

	getDateTimeString: function ( date, dateSelector, dateLength, translate ) {
		if( typeof(date) == "string") {
			return date;
		}
		
		if( typeof(date) == "undefined" || date == null ) {
			date = new Date();
		}	
		if ( typeof(dateSelector) == "undefined" || dateSelector == null ) {
			dateSelector = "dateTime";
		}
		if ( typeof(dateLength) == "undefined" || dateLength == null ) {
			dateLength = "short";
		}
		if ( typeof(translate) == "undefined" || translate == null ) {
			translate = true;
		}
		
		
        if (translate) 
            date = QuickrDateUtil.translateDate(date);

		var dateString = QuickrDateUtil.convertDate(date);
		var timeString = QuickrDateUtil.convertTime(date);
		
		if (dateSelector == "dateOnly") {
			return dateString;
        }
        else 
		if (dateSelector == "timeOnly") {
			return timeString;
            }
            else {
			return dateString + " " + timeString;
		}

	},
	
	getDateString: function  (date, dateLength, translate) {
		return this.getDateTimeString(date, "dateOnly", dateLength, translate);
	},

	getTimeString: function (date, dateLength, translate) {
		return this.getDateTimeString(date, "timeOnly", dateLength, translate);
	},
	
	convertDateTo8601String: function(date) {

		return 	date.getUTCFullYear() +
        "-" +
        this.fillingZero(date.getUTCMonth() + 1) +
        "-" +
        this.fillingZero(date.getUTCDate()) +
        "T" +
        this.fillingZero(date.getUTCHours()) +
        ":" +
        this.fillingZero(date.getUTCMinutes()) +
        ":" +
        this.fillingZero(date.getUTCSeconds()) +
			"Z";

	},
		
    fillingZero: function(num){
        return ((num < 10) ? '0' : '') + num;
    },
	
	convertStringToDate: function (xmlDateTime) {
		try {
			if (xmlDateTime.indexOf('T') == -1) {
			
				try {
					// SPR_GHCN7SPB45
					if (haiku.h_Intl_AMString != "" && haiku.h_Intl_PMString != "") {
						//code to make sure there is no extra spaces in the data/time
						var newdate = xmlDateTime;
						
						newdate = newdate.replace(new RegExp(haiku.h_Intl_AMString, "gi"), " " + haiku.h_Intl_AMString + " ");
						newdate = newdate.replace(new RegExp(haiku.h_Intl_PMString, "gi"), " " + haiku.h_Intl_PMString + " ");
						
						xmlDateTime = newdate;
					}
				}
				catch(ee) {
				}
				
				var d;
				var sep = "";

				var dt = new Array();
				var dtTemp = xmlDateTime.split(" ");
				
				for (var ii = 0; ii < dtTemp.length; ii++) {
					if (dojo.string.trim(dtTemp[ii]).length > 0) {
						dt.push(dtTemp[ii]);
					}
				}
				
				var dp = dt[0];
				var tp = dt[1];

				var ampm = haiku.h_Intl_AMString;

				if (dt.length > 2) {
					var dt2 = dt[2];
					if (haiku.h_Intl_AMPMPrefix) {
						if ((typeof(tp)!="undefined") && ((tp == haiku.h_Intl_PMString) || (tp == haiku.h_Intl_AMString))){
							ampm = tp;
							tp = dt2;
						}
                    }
                    else {
						if ((typeof(dt2)!="undefined") && ((dt2 == haiku.h_Intl_PMString) || (dt2 == haiku.h_Intl_AMString))){
							ampm = dt2;
						}
					}
				}

				if (typeof(haiku)!="undefined") {
					try {
						//determine the date from the haiku format
						var ymd = new Array();
						var ymd_s = dp.split(haiku.h_Intl_DateString);
						for (var i = 0; i < haiku.h_Intl_DateFormat.length; i++) {
							var sidx = haiku.h_Intl_DateFormat.substring(i,i+1).toUpperCase();
							ymd[sidx] = ymd_s[i];
						}


						//try and get the time
						if (typeof(tp)=="undefined" || tp.indexOf(haiku.h_Intl_TimeString) == -1) {
							tp = dt[2];
							if (typeof(tp)=="undefined" || tp.indexOf(haiku.h_Intl_TimeString) == -1) {
								tp = "00:00:00";
							}
						}
						var hm = tp.split(haiku.h_Intl_TimeString);
						if (ampm == haiku.h_Intl_PMString && ampm != haiku.h_Intl_AMString) {
							while(hm[0].substring(0,1) == "0") {
								hm[0] = hm[0].substring(1);
							}
							if (QuickrGeneralUtil.convertToNum(hm[0]) < 12) {
								hm[0] = QuickrGeneralUtil.convertToNum(hm[0]) + 12;
							}
						}
                        if (hm.length < 3) 
                            hm[2] = "00";


						//if all is well, build the date object
						if (!isNaN(ymd["Y"]) && !isNaN(ymd["M"]) && !isNaN(ymd["D"]) && !isNaN(hm[0]) && !isNaN(hm[1])) {
							if (QuickrGeneralUtil.convertToNum(ymd["D"]) <= 32 && QuickrGeneralUtil.convertToNum(ymd["M"]) <= 13) {  //if these values are off, then something went wrong with the parsing...
								d = new Date(ymd["Y"], ymd["M"] - 1, ymd["D"], hm[0], hm[1], hm[2]);
							}
						}
                    } 
                    catch (e) {
                    }

				}

				if (typeof(d) == "undefined" || isNaN(d)) {  //we couldn't parse according to haiku, try brute force...
                    if (dp.indexOf("-") > -1) 
                        sep = "-";
                    if (dp.indexOf(".") > -1) 
                        sep = ".";
                    if (dp.indexOf("/") > -1) 
                        sep = "/";

					d = new Date(xmlDateTime);

					if (sep != "/" || isNaN(d.getFullYear())) {
						// this isn't an ISO date format, and it's also not a format JS recognizes. Assume that it's in the form
						// yyyy-MM-dd hh:mm. If we can't parse based on this format, simply return the string as-is.


						if (sep != "/") {
							var ymd = dp.split(sep);

							//if the last element in ymd is longer than the first then the format is actually...
							//dd-MM-yyyy.  SPR #YGUN7C28XK
							if (ymd[2].length > ymd[0].length) {
								var tmpVal = ymd[0];
								ymd[0] = ymd[2];
								ymd[2] = tmpVal;
							}

							if (typeof(tp)=="undefined" || tp.indexOf(":") == -1) {
								tp = dt[2];
								if (typeof(tp)=="undefined" || tp.indexOf(":") == -1) {
									tp = "00:00:00";
								}
							}

							var hm = tp.split(':');
							if (isNaN(ymd[0]) || isNaN(ymd[1]) || isNaN(ymd[2]) || isNaN(hm[0]) || isNaN(hm[1])) {
								return xmlDateTime;
							}

							d = new Date(ymd[0], ymd[1] - 1, ymd[2], hm[0], hm[1]); // month is 0 - 11, hence ymd[1] - 1
                        }
                        else {
							d = xmlDateTime;  // we couldn't parse it...  just return the original string  back
						}
					}
				}

				return d;
			}

			var xDate = xmlDateTime.split('T')[0].replace(/-/g,"");
			var iYear = QuickrGeneralUtil.convertToNum(xDate.substring(0,4));
			var iMonth = QuickrGeneralUtil.convertToNum(xDate.substring(4,6)) - 1;
			var iDay = QuickrGeneralUtil.convertToNum(xDate.substring(6,8));


			var xTime = xmlDateTime.split('T')[1].replace(/:/g,"");
			var iHours = QuickrGeneralUtil.convertToNum(xTime.substring(0,2));
			var iMins = QuickrGeneralUtil.convertToNum(xTime.substring(2,4));
			var iSecs = QuickrGeneralUtil.convertToNum(xTime.substring(4,6));
			
			
			//now we need to get the datetime in GMT...
			var timezoneOffset = 0;
			var iSign = 1;
			
			if (xTime.indexOf("-") > -1) {
				iSign = -1;
				timezoneOffset = QuickrGeneralUtil.convertToNum(xTime.split("-")[1]);
				
            }
            else 
                if (xTime.indexOf("+") > -1) {
				iSign = 1;
				timezoneOffset = QuickrGeneralUtil.convertToNum(xTime.split("+")[1]);
			}

			var utcDate = new Date(iYear, iMonth, iDay, iHours, iMins, iSecs);
			
			if (timezoneOffset != 0) {
				//if we get a number less than 24, then we know that just the hour offset was sent
				if (timezoneOffset < 24) {
					timezoneOffset = timezoneOffset * 100;
				}

				//determine how many hours/mins to offset
				var iMinOffset = timezoneOffset % 100;
				var iHourOffset = (timezoneOffset - iMinOffset) / 100;

				timezoneOffset = (iHourOffset * 3600000) + (iMinOffset * 60000);
				timezoneOffset = -1 * iSign * timezoneOffset;

				utcDate = new Date(utcDate.getTime() + timezoneOffset);
			}

			
			//the time should now be in GMT...  now let's adjust for server's timezone
			var tzone = haiku.ServerTimeZone;
			
			/*There are 5 timezones whose absolute value is greater than 3000.  
			When these timezones are used the timezone offset iscalculated incorrrectly*/
			tzone = QuickrDateUtil.checkConvertTimeZoneLargerThan3000(tzone);
            if (haiku.h_Intl_DaylightSavings) 
                tzone = tzone - 1;
			
			timezoneOffset = tzone * 3600000;

			
			//now create the date object and set it to the server's time.
			return new Date(utcDate.getTime() - timezoneOffset);

		}
		catch(e) {
			return null;
		}
	},


 checkConvertTimeZoneLargerThan3000: function(tzone){
	
	                   if(tzone == 3003)
			tzone=3.5;
		else if (tzone == -3003)
			tzone = -3.5;
		else if (tzone == -3004)
			tzone = -4.5;
		else if (tzone == -3005)
			tzone = -5.5;
		else if (tzone == -3009)
			tzone = -9.5;
	
	return tzone;
	
	},

	returnDateTimeString: function (xmlDateTime) {
		
		
		var dDate = this.convertStringToDate(xmlDateTime);
		
		
		if (typeof dDate != 'string')
			return this.getDateString(dDate) + ' ' + this.getTimeString(dDate);
		else
			return dDate;
	},
	
	translateDate: function(dDate, toGregorian) {
        if (typeof(toGregorian) == "undefined") 
            toGregorian = false;

		if ( dDate != null && typeof(dDate) == "object" && !isNaN(dDate.getFullYear()) ) {
			if (toGregorian) {
				if(isHijri||isHebrew) {
					var newDate;
                    if (isHijri) 
                        newDate = new dateHijri();
                    if (isHebrew) 
                        newDate = new dateHebrew();
					
					newDate.setYear(dDate.getFullYear());
					newDate.setMonth(dDate.getMonth());
					newDate.setDate(dDate.getDate());
					newDate.setHours(dDate.getHours());
					newDate.setMinutes(dDate.getMinutes());
					newDate.setSeconds(dDate.getSeconds());
					
					dDate = newDate.toGregorian();
				}
            }
            else {
                if (isHijri) 
                    dDate = new dateHijri().gregorianToHijri(dDate);
                if (isHebrew) 
                    dDate = new dateHebrew().gregorianToHebrew(dDate);
			}		
		}
		
		return dDate;

	},
	
	convertDate: function (date){
		var ret = "";
		var sep;
		var format;
		var date4DigitYear;
        if (haiku.hasRegionalCookie == true) {
			sep = haiku.h_Cookie_DateString;
			format = haiku.h_Cookie_DateFormat;
			date4DigitYear = haiku.h_Cookie_Date4DigitYear;
		}
        else {
			sep = haiku.h_Intl_DateString;
			format = haiku.h_Intl_DateFormat;
			date4DigitYear = haiku.h_Intl_Date4DigitYear;
		}
		
		var year = date.getFullYear();
        if (date4DigitYear == false) {
			year = year.toString().substring(2);
		}
		
		var month =(((date.getMonth()+1) < 10) ? "0" : "") + (date.getMonth()+1);
		var day =((date.getDate() < 10) ? "0" : "") + date.getDate();
		if(format == haiku.kszDMY) {
			ret = day + sep + month + sep + year;
        }
        else 
            if (format == haiku.kszYMD) {
			ret = year + sep + month + sep + day;
            }
            else {
			ret = month + sep + day + sep + year;
		}
		return ret;
	},

	convertTime: function (date){
		var ret = "";
		var am_pm = "";
		var timeString;
		var clock24Hour;
		var amString;
		var pmString;
		var ampmPrefix;
        if (haiku.hasRegionalCookie == true) {
			timeString = haiku.h_Cookie_TimeString;
			clock24Hour = haiku.h_Cookie_Clock24Hour;
			amString = haiku.h_Cookie_AMString;
			pmString = haiku.h_Cookie_PMString;		
			ampmPrefix = haiku.h_Cookie_AMPMPrefix;
		}
        else {
			timeString = haiku.h_Intl_TimeString;
			clock24Hour = haiku.h_Intl_MilitaryTime;
			amString = haiku.h_Intl_AMString;
			pmString = haiku.h_Intl_PMString;	
			ampmPrefix = haiku.h_Intl_AMPMPrefix;	
		}
		
		var hrs = date.getHours();
		var mins = date.getMinutes();
		var mins = ((mins < 10) ? "0" : "") + mins;
		if(!clock24Hour){
			if(ampmPrefix)
				am_pm = ((hrs >= 12) ? pmString + ' ' : amString + ' ');
			else
				am_pm = ((hrs >= 12) ? ' ' + pmString : ' ' + amString);
			hrs  = ((hrs > 12) ? hrs - 12 : hrs);
            if (hrs == 0) 
                hrs = 12;
		}
		if (ampmPrefix) {
			return (am_pm + hrs + timeString + mins);
        }
        else {
			return (hrs + timeString + mins + am_pm);
		}		
	}	
}

var QuickrCookieUtil = {

	hasCookie: function (name) {
		var ck = this.getCookie(name);
		return (ck != null && ck != "");
	},

	getCookie: function (name, xdefault) {
        if (typeof(xdefault) == "undefined") 
            xdefault = null
		var cname = name + "=";               
		var dc = document.cookie;             
		if (dc.length > 0) {              
			begin = dc.indexOf(cname);       
			if (begin != -1) {           
				begin += cname.length;       
				end = dc.indexOf(";", begin);
                if (end == -1) 
                    end = dc.length;
				return unescape(dc.substring(begin, end));
			} 
		}
		return xdefault;
	},

	setCookie: function (name, value, expires, path) {
		document.cookie = name + "=" + escape(value) + "; path=" + (typeof(path)=="undefined" ? "/" : path) + ((expires == null) ? "" : "; expires=" + expires.toGMTString());
	},

	delCookie: function (name) {
		document.cookie = name + "=; expires=Thu, 01-Jan-70 00:00:01 GMT" +  "; path=/";
	},

	getExpireDate: function (nodays) {
		var UTCstring;
		Today = new Date();
		nomilli=Date.parse(Today);
		Today.setTime(nomilli+nodays*24*60*60*1000);
		UTCstring = Today.toUTCString();
		return UTCstring;
	}
}

var QuickrXMLUtil = {

    getXMLDocFromString: function(stext){
		var doc;
		
		// code for IE
        if (window.ActiveXObject) {
			doc=new ActiveXObject("Microsoft.XMLDOM");
			doc.async="false";
			doc.loadXML(stext);
		}
		// code for Mozilla, Firefox, Opera, etc.
        else {
			var parser=new DOMParser();
			doc=parser.parseFromString(stext,"text/xml");
		}
		
		return doc;
	},
	
    getNodeValuesByTagName: function(xmlDoc, tagname){
		var arr = new Array();
		
		var x = xmlDoc.getElementsByTagName(tagname);
		
		if (x && x.length > 0) {
			for (var i = 0; i < x.length; i++) {
				arr[arr.length] = x[i].childNodes[0].nodeValue;
			}
		}
		
		return arr
	
	
	},
	
	
    fireAjaxRequest: function(url, responseFunc, timeoutSecs, timeoutFunc, errorFunc, doSync){
        if (typeof(timeoutSecs) == "undefined") 
            timeoutSecs = 15;
        if (typeof(doSync) == "undefined") 
            doSync = false;
        ;
		
		var theTimeout = timeoutSecs * 1000;
		var theMethod = "get";
		var theErrFunc = errorFunc || this.Error;
		var theType = "text/plain";
		
		try {
			dojo.xhrGet({
					url: url,
					timeout: theTimeout,
					sync: doSync,
					handleAs: "text",

				load: function(response, ioArgs) { //{type, data, evt) {
					if (typeof(responseFunc) == "string") {
						responseFunc = eval(responseFunc);
					}
		
					if (typeof(responseFunc) == "function") {
						responseFunc (response, this.url);
					} 
				},


				error: function(response, ioArgs) { //function(type, error) {
					if (typeof(errorFunc) == "string") {
						errorFunc = eval(errorFunc);
					}
		
					if (typeof(errorFunc) == "function") {
						errorFunc ("get", response);
					}
				}
			});
	
		}
		catch(e) {
		}	
	},
	
	massageXmlStringForData: function(data) {
		if (typeof data == "string") {
		
			//code will attempt to remove problem characters in the textabstract which IE has a problem with.
			var aSplit = ["<h_TextAbstract><![CDATA[", "]]></h_TextAbstract>"];
			
			var data1 = data.split(aSplit[0]);
			if (data1.length > 1) {
				var data2 = data1[1].split(aSplit[1]);
				
				if (data2.length > 1) {

					data2[0] = encodeURIComponent(data2[0]);
					data2[0] = data2[0].replace(/\%C2\%A0/gi, "%20");
					data2[0] = decodeURIComponent(data2[0]);

					return QuickrXMLUtil.getXMLDocFromString(data1[0] + aSplit[0] + data2[0] + aSplit[1] + data2[1]);
				}
			}

			return QuickrXMLUtil.getXMLDocFromString(data);

        }
        else {
			return data;
		}
	}
}
	

var QuickrSetupUtil = {

	SHOWTYPE_FILES: 	"1",
	SHOWTYPE_PLACES:	"2",
	SHOWTYPE_PLACESONLY: 	"3",
	
	SHOW_COOKIE_NAME:	"ShowContentUI",
	
	ORIG_HELPPAGE_NAME:	"OrigHelpPageUnid",
	SHOW_MYFILES_NAME:	"ShowMyFiles",
	
	_TITLEHOLDER: 		"",
	_HELPPAGEHOLDER:	"",
	
	findUserName: function () {
		var ret = "";
		
        if (ret == "") 
            ret = this._returnNameIfValid(haiku.userName);
        if (ret == "") 
            ret = this._returnNameIfValid(haiku.AbbrevUserName);
        if (ret == "") 
            ret = this._returnNameIfValid(haiku.loginName);
        if (ret == "") 
            ret = this._returnNameIfValid(haiku.distinguishedName);
		
		
		return ret;
		
	
	},
	
	setEntryWindowTitle: function (yn) {
		return;
		
        if (typeof(yn) == "undefined") 
            yn = true;

		if (yn) {
			QuickrSetupUtil._TITLEHOLDER = document.title;
			document.title = QuickrLocaleUtil.getStringResource("QuickrSetupUtil.ENTRYWINDOWTITLE");
			
        }
        else {
			if (QuickrSetupUtil._TITLEHOLDER != "") {
				document.title = QuickrSetupUtil._TITLEHOLDER;
			}
		}
		
	},
	
	setEntryHelpFile: function (yn) {
		
		if (typeof(G_EntryHelpPageUnid) != "undefined") {
            if (typeof(yn) == "undefined") 
                yn = true;
			
			if (yn) {
				if (helpPageUnid != G_EntryHelpPageUnid) {
					QuickrSetupUtil._HELPPAGEHOLDER = helpPageUnid;
					helpPageUnid = G_EntryHelpPageUnid;

				}
            }
            else {
				if (helpPageUnid == G_EntryHelpPageUnid) {
					var oldunid = QuickrSetupUtil._HELPPAGEHOLDER;
					if (oldunid != "") {
						helpPageUnid = oldunid;
					}
				}
			}
		}
		
	},
	
	_returnNameIfValid: function (val) {
		if (val.indexOf(" ")) {
			return val;
        }
        else {
			return "";
		}
	},
	
	redirectToMyPlace: function(rawdata) {
		var data = null;
		
		if (typeof(rawdata) == "string") {
			data = QuickrXMLUtil.getXMLDocFromString(rawdata);
        }
        else {
			data = rawdata;
		}
		

		if (data != null) {
			var entries = data.getElementsByTagName("viewentry");

			var dn1 = haiku.distinguishedName.toLowerCase();
			var dn2 = "cn=" + dn1;

			for (var i = 0; i < entries.length; i++) {
				var dn=email="";

				cols = entries[i].getElementsByTagName("entrydata");
				for (var j = 0; j < cols.length; j++) {
					colName = cols.item(j).getAttribute("name");
					if (colName == "dn") {
						dn = cols.item(j).firstChild.nodeValue.toLowerCase();
					}
                    else 
                        if (colName == "mail") {
						email = cols.item(j).firstChild.nodeValue;
					}

					if (dn != "" && email != "") {  //we've got everything we need.
						if (dn == dn1 || dn == dn2) {
							haiku.emailAddress = email;
							break;
						}
						
					}

				}
				
				if (haiku.emailAddress != "") {
					break;
				}

			}
			
			if (haiku.emailAddress == "") {
				var dn1 = haiku.userName.toLowerCase();
				
				for (var i = 0; i < entries.length; i++) {
					var dn=email="";

					cols = entries[i].getElementsByTagName("entrydata");
					for (var j = 0; j < cols.length; j++) {
						colName = cols.item(j).getAttribute("name");
						if (colName == "displayname") {
							dn = cols.item(j).firstChild.nodeValue.toLowerCase();
						}
                        else 
                            if (colName == "mail") {
							email = cols.item(j).firstChild.nodeValue;
						}

						if (dn != "" && email != "") {  //we've got everything we need.
							if (dn == dn1) {
								haiku.emailAddress = email;
								break;
							}

						}

					}

					if (haiku.emailAddress != "") {
						break;
					}				
				}
				
			}
			
			
			
		}
		
		QuickrSetupUtil.lookupFilesPlaceFromEmail(haiku.emailAddress);
		
	},
	
	loadMyFiles: function () {
		var showMyFiles = QuickrGeneralUtil.getQSValue(window.location.href, this.SHOW_MYFILES_NAME,"");
		if (showMyFiles == "1") {

			if (haiku.emailAddress == "") {
				//for whatever reason, the email address isn't coming through, let's fall back to pull it through the ldapsearch

				var ldapname = this.findUserName();
				if (ldapname.indexOf(" ") > -1) 
					ldapname = ldapname.substring(ldapname.indexOf(" ")+1);
				if (ldapname.indexOf("=") > -1) 
					ldapname = ldapname.substring(ldapname.indexOf("=")+1);					
				if (ldapname.indexOf("/") > -1) 
					ldapname = ldapname.substring(0,ldapname.indexOf("/"));	
				if (ldapname.indexOf("\\") > -1) 
					ldapname = ldapname.substring(0,ldapname.indexOf("\\"));
				ldapname = haiku.distinguishedName;

				var ldapurl = getAbsoluteServerRootURL(self) + "/dm/atom/action?action=ldapsearch&query=" + encodeURIComponent(ldapname);

				QuickrXMLUtil.fireAjaxRequest( ldapurl, QuickrSetupUtil.redirectToMyPlace, 15, "", QuickrSetupUtil.processFilesPlaceError );
				
            }
            else {
				QuickrSetupUtil.redirectToMyPlace(null);

			}
			return true;
		}

		return false;
	},

	fixPageTitle: function(titleNode, titleKey) {
		if (!titleNode) {
			return;
		}
		
		QuickrLocaleUtil.loadStringFiles("common", "/qphtml/skins/common", "QuickrCommonStrings");
		var titleStr = QuickrLocaleUtil.getStringResource(titleKey);
		titleNode.setAttribute("title", titleStr);
		titleNode.innerHTML = titleStr;
		titleNode.style.overflow = 'hidden';
		titleNode.style.whiteSpace = 'nowrap';
		
	},
	
	showQuickrContent: function(newType, external) {
        if (typeof(external) == "undefined") 
            external = false;
		
		if (QuickrSetupUtil.loadMyFiles()) {
			return;
		}
		
		
		
		

		if ( typeof(newType) != "undefined" && newType != null ) {
			QuickrCookieUtil.setCookie(this.SHOW_COOKIE_NAME, newType);
        }
        else {
			newType = QuickrGeneralUtil.getQSValue(window.location.href, "ShowType","");
			if (newType != "") {
				QuickrCookieUtil.setCookie(this.SHOW_COOKIE_NAME, newType);
			}
		}


        if (typeof(h_InstallType) == "undefined") 
            h_InstallType = this.SHOWTYPE_PLACES;

		if (external) {

			var url = this.getSetupBase() + "&ShowType=" + QuickrCookieUtil.getCookie(this.SHOW_COOKIE_NAME);
			
			window.location.href = url;
			
        }
        else {
		
			/*************************************
			* This array will store the style.display values for the three classes of elements
			*
			* First is the elements for Places-specific content
			* Second is the elements for shared content
			* Third is the elements for File-specific content
			* Forth is a special ID for the "Work with Templates" link.
			* This is the elements for the entry stuff only
			**************************************/
			var arrShow;

			if (h_InstallType == this.SHOWTYPE_FILES) { //THIS IS AN ENTY INSTALL...  SHOW ONLY ENTRY STUFF
				arrShow = new Array("none", "none", "block", "none");
				
				QuickrSetupUtil.setEntryHelpFile(true);
				QuickrSetupUtil.setEntryWindowTitle(true);
				


            }
            else 
                if (h_InstallType == this.SHOWTYPE_PLACES) { //THIS IS AN FULL INSTALL...  SHOW ALL STUFF
				var checkType = h_InstallType;
				if ( QuickrCookieUtil.hasCookie(this.SHOW_COOKIE_NAME) ) {
					checkType = QuickrCookieUtil.getCookie(this.SHOW_COOKIE_NAME);
				}

				var id_p = document.getElementById("typePlaces");
				var id_f = document.getElementById("typeFiles");

				if (checkType == this.SHOWTYPE_FILES) {
					arrShow = new Array("none", "block", "block", "none");

                        if (id_p) 
                            id_p.className = id_p.className.replace("lotusSelected", "");
                        if (id_f) 
                            id_f.className += " lotusSelected";
                        
                        
                    }
                    else 
                        if (checkType == this.SHOWTYPE_PLACES || checkType == this.SHOWTYPE_PLACESONLY) {
					arrShow = new Array("block", "block", "none", "block");

                            if (id_p) 
                                id_p.className += " lotusSelected";
                            if (id_f) 
                                id_f.className = id_f.className.replace("lotusSelected", "");
				}
				
				QuickrSetupUtil.setEntryHelpFile( checkType==this.SHOWTYPE_FILES );
				QuickrSetupUtil.setEntryWindowTitle( checkType==this.SHOWTYPE_FILES );
							

                }
                else 
                    if (h_InstallType == this.SHOWTYPE_PLACESONLY) { //THIS IS A PLACES INSTALL...  SHOW PLACES STUFF
				var checkType = h_InstallType;
				if ( QuickrCookieUtil.hasCookie(this.SHOW_COOKIE_NAME) ) {
					checkType = QuickrCookieUtil.getCookie(this.SHOW_COOKIE_NAME);
				}

				arrShow = new Array("block", "none", "none", "block");
				
				QuickrSetupUtil.setEntryHelpFile( false );
				QuickrSetupUtil.setEntryWindowTitle( false );
							

			} 

			if ( typeof(arrShow) != "undefined" ) {
				var els_p = QuickrGeneralUtil.getElementsByClassName ("QuickrPlacesContent");	//places-specific ui
				var els_s = QuickrGeneralUtil.getElementsByClassName ("QuickrSharedContent");	//shared ui to be displayed on full install
				var els_f = QuickrGeneralUtil.getElementsByClassName ("QuickrFilesContent");	//files-specific ui		
				for (var i = 0; i < els_p.length; i++) {
					els_p[i].style.display = arrShow[0];
				}
				for (var i = 0; i < els_s.length; i++) {
					els_s[i].style.display = arrShow[1];
				}			
				for (var i = 0; i < els_f.length; i++) {
					els_f[i].style.display = arrShow[2];
				}
				
				//massage the templates link...
				var el = document.getElementById("Toc_PlaceTypes");
				if (el) {
					el.parentNode.parentNode.style.display = arrShow[3];
				}				
			}
		}

	},
		
	showMyFiles: function () {

		var url = this.getSetupBase() + "&Login&" + this.SHOW_MYFILES_NAME + "=1";

		window.location.href = url;
	},
	
	getSetupBase: function () {
	
		var xbase = "LotusQuickr";
		if (typeof(getHaikuSubDir) == "function") {
			xbase = getHaikuSubDir();
		}
		var setupHaiku = xbase.toLowerCase();
		var url = QuickrGeneralUtil.getJunctionString() + "/" + xbase + "/" + setupHaiku + "/Main.nsf/h_Toc/22049553d70e00ef85256bb60054a7cb/?OpenDocument";
		
		return url;
	
	},
	
	lookupFilesPlace: function( frm ) {
		return this.lookupFilesPlaceFromEmail(frm.email.value);
			
	},
	
	lookupFilesPlaceFromEmail: function( email ) {
			var url = QuickrGeneralUtil.getServletRoot() + "/QuickrEntry?getEntryPlaceInfo=1&email=" + encodeURIComponent(email);
			
			QuickrXMLUtil.fireAjaxRequest( url, QuickrSetupUtil.processFilesPlace, 15, "", QuickrSetupUtil.processFilesPlaceError );
			
			return false;
					
		
	},
	
	_ERRORSHOWN: false,
	processFilesPlace: function ( xmlstring ) {
		eval(xmlstring);
		
		if (QuickrEntryPlaceInfo.exists) {
			var newloc = QuickrEntryPlaceInfo.placeLocation;
			var sJun = QuickrGeneralUtil.getJunctionString();

			//if we've got a junction string, then we are behind TAM or a similar device.
			//Remove the reference to the server and add the junction string			
			if (newloc.toLowerCase().indexOf("http") == 0) {
				newloc = newloc.substring(newloc.indexOf("//")+2);
				newloc = newloc.substring(newloc.indexOf("/"));
			}
			//SPR #GMU7L5J6M, if the loc started with Junction name, then do not add sJun
			if (sJun != "" && newloc.toLowerCase().indexOf(sJun.toLowerCase()) != 0) {
			    newloc = sJun + newloc;
			}

			window.location.href = newloc;
        }
        else {
			if (!QuickrSetupUtil._ERRORSHOWN) {
				var err = QuickrLocaleUtil.getStringResource("QuickrSetupUtil.ERRORS.PLACE_NOT_FOUND");
				err = err.replace("{0}", QuickrEntryPlaceInfo.email);

				alert(err);

			}
			
			if (window.location.href.indexOf("&" + QuickrSetupUtil.SHOW_MYFILES_NAME + "=1") > -1) {
				QuickrSetupUtil._ERRORSHOWN = true;
				window.location.href = QuickrGeneralUtil.getBaseUrl();
			}
			
		}
		
		
		
	},
	
	processFilesPlaceError: function () {
		alert(QuickrLocaleUtil.getStringResource("QuickrSetupUtil.ERRORS.SERVLET_NOT_CONFIGURED"));
		window.location.href = (window.location.href + "&").split("&")[0];
	},
	
	getTextWidth: function( text ) {
		var elSpan = document.createElement("span");
		elSpan.className = "lotusText";
		elSpan.innerHTML = text.replace(/\"/g, '&quot;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
		document.body.appendChild(elSpan);

		// SPR_CWAG7USPWR
		var spanWidth = "";
		if ( elSpan.offsetWidth > 0) {
			spanWidth = elSpan.offsetWidth;
        }
        else {
			spanWidth = 0 - elSpan.offsetWidth;
		}		
		
		elSpan.parentNode.removeChild(elSpan);

		return spanWidth;		
	},
	
	adjustPrefilledTextBox: function( id, extraPX ) {
		var elSearch = dojo.byId(id);
		if (elSearch && elSearch.value.length > 0) {
			var spanWidth = QuickrSetupUtil.getTextWidth(elSearch.value)
			if ( h_ClientBrowser && h_ClientBrowser.isIE() ) {
				spanWidth += 10;
			}
			if (extraPX) {
				spanWidth += extraPX;
			}
			
			elSearch.style.width = spanWidth+"px";			
		}
	}
	
	
	
	
}












// MEMBER LOOKUP

var MemberLookupUtil = {
	
	origBodyOnClick: null,
	
	currentControl: null,
	
	submitControlForm: false,
	

	
	curRole: "members",

	tmrMS: 300,
	tmout: null,
	iName: "-1",
	maxNames: 15,
	aSelections: new Array(),

	init: function () {
		this.aSelections.length = 0;
		if (G_maxNames != "") {
			this.maxNames=parseInt(G_maxNames);
		}
	},

	onKey: function (val,e) {
		// stop lookup timer
		if (this.tmout != null) {
			clearTimeout(this.tmout);
		}

		var bAbort=false;
		var bDoNothing=false;
		var key;
		if (window.event)			  // IE
			key = e.keyCode;
        else 
            if (e.which) 
			key = e.which;
		var ch=String.fromCharCode(key);

		switch (key) {
		case 13:						  // enter
			//this.chooseName();
			return false;
		/*
		case 38:						  // up arrow
			this.prevName();
			return false;
		case 40:						  // down arrow
			this.nextName();
			return false;
		*/
		case 27:						  // esc
			bAbort=true;
			break;
		case 9:
			bDoNothing=true;
			break;
			
		default:
			break;
		}

		// s <-- string being typed
		var s="";
		var i = val.lastIndexOf("),");
		i = (i<0 ? 0 : i+2);
		if (i<val.length) {
			s=val.substring(i);
		}

		if (bAbort || s.length==0) {
			 this.hideNames();
		}
		else {
			if (!bDoNothing) {
				// set timer to do lookup on the string typed so far
                this.tmout = setTimeout(function(){
                    MemberLookupUtil.doIt(s);
                }, this.tmrMS);
			}
		}
		return false;
	},

	doIt: function(val) {
		// LDAP Search service URL (optional: &flags=g,e)
		var flags="";

		var svcUrl = getAbsoluteServerRootURL(self) + "/dm/atom/action?action=ldapsearch&query=" + encodeURIComponent(val) + flags;

		try {

			dojo.xhrGet({
				url: svcUrl,
				handleAs: "text",
				load: function(response, ioArgs) {
					var xmlData=MemberLookupUtil.getXMLDocFromString(response);	
					MemberLookupUtil.init();
					MemberLookupUtil.showNames(xmlData,val);
				},
				error: function(response, ioArgs ) {
					MemberLookupUtil.error(error,val);					
				}			

			});
			
			var looking_str = QuickrLocaleUtil.getStringResource("QUICKRCOMMON.LOOKING");

            var html = '<ul' +
            '<li class="selected">' +
            '<img src="/qphtml/html/common/ajax_loader.gif"/>' +
            '&nbsp;<em>' +
            looking_str +
            '</em>&hellip;' +
            '</li></ul>';

			var el = dojo.byId("m_autocomplete"+MemberLookupUtil.curRole+"_choices");
			
			if (el) {
				//SPR #QCAO7GVFC5
				if (document.forms["findFilesForm"] && document.forms["findFilesForm"].email && MemberLookupUtil.curRole == "members" && document.body.dir == "rtl") {
					var newLeft = findPos(document.forms["findFilesForm"].email)[0];
					newLeft = newLeft - parseFloat(el.style.minWidth.replace(/px/,""));
					
					el.style.left = newLeft +"px";
				}			
			
				el.innerHTML=html;
				el.style.display="block";
			}
		}
		catch(e) {
		}
	},

	error: function(err,sLookup) {	
		var looking_up_str = QuickrLocaleUtil.getStringResource("QUICKRCOMMON.ERROR_IN_LOOKING_UP");

        var html = '<ul' +
        '<li tabindex="0" class="selected">' +
        looking_up_str +
        ' "' +
        QuickrGeneralUtil.encodeEntities(sLookup) +
        '"' +
        '</li></ul>';

		var el = dojo.byId("m_autocomplete"+MemberLookupUtil.curRole+"_choices");
		el.innerHTML=html;
 		el.style.display="block";
	},

	// Added for PNOT79UP7H - should be common util!
    getXMLDocFromString: function(s){
		var doc;
		
		// code for IE
        if (window.ActiveXObject) {
			doc=new ActiveXObject("Microsoft.XMLDOM");
			doc.async="false";
			doc.loadXML(s);
		}
		// code for Mozilla, Firefox, Opera, etc.
        else {
			var parser=new DOMParser();
			doc=parser.parseFromString(s,"text/xml");
		}
		
		return doc;
	},
	
	showChoices: function (yn, html) {
        if (typeof(yn) == "undefined") 
            yn = true;
		
		var el = dojo.byId("m_autocomplete"+MemberLookupUtil.curRole+"_choices");
		
		if (el) {
			if (yn) {
				if (typeof(html) != "undefined" && html != null) {
					el.innerHTML = html;
				}
				el.style.display = "block";
				
				
				var el2 = dojo.byId(MemberLookupUtil.curRole+"_container");
                if (el2) 
                    el2.focus();

				
				MemberLookupUtil.origBodyOnClick = document.body.onclick;
				document.body.onclick = MemberLookupUtil.onBodyClick;
				
            }
            else {
				el.style.display = "none";
				
				document.body.onclick = MemberLookupUtil.origBodyOnClick;
				MemberLookupUtil.origBodyOnClick = null;
			}
		}
	
	},
	
	selectName: function(newval) {
		if (newval == "") {
			var str = QuickrLocaleUtil.getStringResource("QUICKRCOMMON.ERROR_NO_EMAIL_ADDR");
			alert(str);
		
        }
        else {
			MemberLookupUtil.currentControl.value = newval.replace(/,/g, "/");
			MemberLookupUtil.hideNames();
			MemberLookupUtil.currentControl.focus();		
		}
	},

	showNames: function (root,sLookup) {

		var html = "";
		var nameHtml='';

		var top = root.getElementsByTagName("viewentries");
		var nEntries = top.item(0).getAttribute("toplevelentries");
		var iUsableName = -1;

		if (nEntries > 0) {
			// Found some entries
			var entries = root.getElementsByTagName("viewentry");
			for (var i=0; i<entries.length && i<this.maxNames; i++) {
				// Show up to 15 names
				
				
				var email = "";
				var cn = "";

				cols = entries[i].getElementsByTagName("entrydata");

				for (var j = 0; j < cols.length; j++) {
					colName = cols.item(j).getAttribute("name");
					if (colName == "mail") {
						if (cols.item(j).childNodes.length > 0) {
							email = cols.item(j).firstChild.nodeValue;
						}
					}
                    else 
                        if (colName == "cn") {
						if (cols.item(j).childNodes.length > 0) {
							cn = cols.item(j).firstChild.nodeValue;
						}
					}
                        else 
                            if (email != "" && cn != "") {
						break;
					}
				}

				var temp = QuickrLocaleUtil.getStringResource("MemberLookupUtil.CHOICES.FORMAT");
				temp = temp.replace("{0}", cn);
				temp = temp.replace("{1}", email);

				iUsableName++;

				nameHtml += 	'<a ' +
						'onmouseout="MemberLookupUtil.unhilite(this);" onmouseover="MemberLookupUtil.hilite(this);"' +
						'onblur="MemberLookupUtil.unhilite(this);" onfocus="MemberLookupUtil.hilite(this);"' +
                'href="javascript:void MemberLookupUtil.selectName(&quot;' +
                email +
                '&quot;)">' +
                temp +
                '</a>';
							
			
				
			}
		}

		if (iUsableName < 0) {
		    var str = QuickrLocaleUtil.getStringResource("QUICKRCOMMON.NO_NAMES_AVAILABLE");
			html += '<a class="selected">' +  str + '</a>';
		}
		else {
			if (nEntries > this.maxNames) {
				var str = QuickrLocaleUtil.getStringResource("QUICKRCOMMON.ENTRIES_NAMES_AVAILABLE");
				str = str.replace("{0}", nEntries);
				str = str.replace("{1}", this.maxNames);
				html += '<a><em>** '+ str + '</em></a>';
			}
			html += nameHtml;
		}

		MemberLookupUtil.showChoices(true, html);

	},

	
	hilitedControl: null,
	hilite: function(ctrl) {
		if (ctrl) {
			MemberLookupUtil.unhilite(MemberLookupUtil.hilitedControl);
			
			ctrl.className += " selected";
			MemberLookupUtil.hilitedControl = ctrl;
		}
	},
	unhilite: function(ctrl) {
		if (ctrl) {
			ctrl.className = ctrl.className.replace("selected","");
		}
	},	
	
	

	hiliteName: function(i) {
		var el=dojo.byId(MemberLookupUtil.curRole+"_name_"+this.iName);
		if (el) {
			el.className="";
		}
		el=dojo.byId(MemberLookupUtil.curRole+"_name_"+i);
		if (el) {
			el.className="selected";
			this.iName=i;
		}
	},

	hideNames: function() {
		this.iName=-1;
		dojo.byId("m_autocomplete"+MemberLookupUtil.curRole+"_choices").style.display="none";
	},

	onBodyClick: function(e) {
		dojo.byId("m_autocomplete"+MemberLookupUtil.curRole+"_choices").style.display="none";
	},

 	preventDefaultAction: function (e) {
 		try {
 			e.preventDefault();
        } 
        catch (err1) {
 		}
 	},	
	
	flagCurrentControl: function(ctrl, submitForm) {
		MemberLookupUtil.currentControl = ctrl;
		
		
        if (typeof(submitForm) == "undefined") 
            submitForm = false;
		MemberLookupUtil.submitControlForm = submitForm;
		
	}	


}


//BBXSS Changes
/*********************************************************************************
*	This object is used in converting the backend data passed 
*	from the server into javascript data used by the UI.  This
*	was necessary for the XSS security work.  First, instantiate
*	the object Then set the rawString value containing the 
*	backend data.  If you want to have a function called with 
*	the data items for each row passed in as parameters, then 
*	set the callbackFunction. If you want a set of arrays to get
*	updated with the appropriate values for each row, set the 
*	targetArrays to the array of arrays.  
*********************************************************************************/
// Constructor.  Pass in row delimiter, column delimiter, and the index of the
// column which is not blank to be added.
// ex: var xssData = new QuickrBackendDataUtil( D_RowDelimiter , D_ColumnDelimiter , 0);
function QuickrBackendDataUtil(sRowDelim, sColumnDelim, iNotBlank) {
	//make sure the parameters passed in have values
    if (typeof(sRowDelim) == "undefined" || sRowDelim == null) 
        sRowDelim = "%~~%";
    if (typeof(sColumnDelim) == "undefined" || sColumnDelim == null) 
        sColumnDelim = "%~%";
    if (typeof(iNotBlank) == "undefined" || iNotBlank == null) 
        iNotBlank = 0;
	
	//define the internal vars
	this._rowDelim = sRowDelim;
	this._columnDelim = sColumnDelim;
	this._notBlank = iNotBlank;
	this._rawArray = new Array();

	//these are set after the object is instantiated.
	this.rawString = "";
	this.targetArrays = new Array();
	this.callbackFunction = null;
	this.dataItem = null;

}

// Takes the raw string and performs the necessary actions on it
// if the callbackFunction was defined, then it will be called
// for every "row" of data.  If the targetArrays is defined, 
// then just put the column values in the appropriate targets
QuickrBackendDataUtil.prototype.processRawData = function() {
	this._populateRawArray();
	
	var aRaw = this._rawArray;
	var aTarget = this.targetArrays;
	
	if (typeof this.callbackFunction == "function") {  //the callback function was defined, call it for every row
		for (var ii = 0; ii < aRaw.length; ii++) {
			if (aRaw[ii].length > 0) {
				var tmpSplit = aRaw[ii].split( this._columnDelim ); //split the row according to the column delimiter
				tmpSplit[tmpSplit.length] = this.dataItem;  //always pass the dataItem as the final real parameter just in case the callback function needs it
				if (this._notBlank < 0 || (tmpSplit[this._notBlank] && tmpSplit[this._notBlank] != '')) {
					this.callbackFunction( tmpSplit );  //callback the specified function passing in the column values as paramters
				}

			}
		}
		
    }
    else 
	if (aTarget.length > 0) { //the targetArrays was defined, populate it instead.
		for (var ii = 0; ii < aRaw.length; ii++) {
			if (aRaw[ii].length > 0) {
				var tmpSplit = aRaw[ii].split( this._columnDelim ); //split the row according to the column delimiter
				if (this._notBlank < 0 || (tmpSplit[this._notBlank] && tmpSplit[this._notBlank] != '')) {
					for (var jj = 0; jj < tmpSplit.length; jj++) {
						if (jj < aTarget.length ) {
							if (typeof aTarget[jj] == "object") {
								aTarget[jj].push(tmpSplit[jj]);
                                }
                                else {
								aTarget[jj] = tmpSplit[jj];
							}
						}
					}
				}
			}
		}
		
	}
	
	this._resetData();  //reset whatever we don't need anymore...
}
//resets the data for this instantiation of the object
QuickrBackendDataUtil.prototype._resetData = function() {
	this.rawString = "";
	this._rawArray = new Array();
	this.targetArrays = new Array();
	this.callbackFunction = null;
	this.dataItem = null;
}
//takes the raw string passed from the backend and puts each row into
//a separate entry in the rawArray according to the row delimiter.
QuickrBackendDataUtil.prototype._populateRawArray = function() {

	var sRaw = this.rawString;	
	var aTarget = this._rawArray;

	var tmp = new Array();
	if (sRaw.indexOf(this._rowDelim) > -1) {
		tmp = sRaw.split(this._rowDelim);
		for (var ii = 0; ii < tmp.length; ii++) {
			if (tmp[ii] != "") {
				aTarget.push( tmp[ii] );
			}
		}
    }
    else {
		aTarget.push( sRaw );
	}
}
/*********************************************************************/
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2005, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/*********************************************************************/

//-------------------------------------------------------------
//  Quickplace Ajax library
//-------------------------------------------------------------

// Quickplace "AJAX" Object
function QPAjax()
{
	this.Request = QPAjax_Request;
	this.RequestJS = QPAjax_RequestJS;
	this.RequestXML = QPAjax_RequestXML;
	this.SubmitForm = QPAjax_SubmitForm;
	this.Error = QPAjax_Error;	  // Default error handler if none specified
}

function randomChar(len)  {
	var x = "0123456789ABCDEF";
	var tmp = "";
	for(var i=0;i< len;i++)  {
		tmp += x.charAt(Math.ceil(Math.random()*100000000)%x.length);
	}
	return tmp;
}
	
function appendNonceInURL(url) {
	if (url && url != "") {				
		var noncetoken = getCookie("NonceToken");
		if (noncetoken == null || noncetoken.length < 1) {
			var nonce_str = randomChar(32);
			if (nonce_str) {
				setCookie("NonceToken",nonce_str);
				noncetoken = nonce_str;
			}
		}
		var newurl = url;
		if (newurl.indexOf("nonce=") == -1) {
			if (newurl.indexOf("?") == -1) {
				newurl += "?";
			} else {
				newurl += "&";
			}
			newurl += "nonce=" + noncetoken;
			return newurl;
		}				
	}
	return url;
}

// Make an XMLHTTP request;
//
// Required args:
//  url: the request URL
//  sFunc: "success" callback function with returned data as argument.
//
// Optional args:
//  meth: "get" or "post".
//  eFunc: "error" callback function with error code as argument.
//  type: The MIME type determining format of returned data.
//        Default is "text/plain" (response passed back "as is", as raw text).
//
// 
//
function QPAjax_Request(url, sFunc, meth, eFunc, type)
{
	var theMethod = meth || "get";
	var theErrFunc = eFunc || this.Error;
	var theType=returnSubType(type);

	try {
		if (theMethod=="get") {
			dojo.xhrGet ({
				url: url,
				handleAs: (typeof(theType)=="undefined" ? "text" : theType),
				load: function(data){sFunc(data)},
				error: function(error){theErrFunc(error)}
			});
		}
		else {
			url = appendNonceInURL(url);
			dojo.xhrPost ({
				url: url,
				handleAs: (typeof(theType)=="undefined" ? "text" : theType),
				load: function(data){sFunc(data)},
				error: function(error){theErrFunc(error)}
			});
			}
	}
	catch(e) {
		this.Error(e);
	}
}


// Request data assumed to be javascript code,
// try to evaluate and run the returned javascript.
//
// Example:
// --------
// demo.js on the server contains:
//
// function helloWorld() {
//     alert( "Hello world!\n" +
//         "I'm some javascript." );
//     return "I have returned";
// }
// helloWorld();
//
// Your client-side code:
//
// function showReturnValue( type, evaldObj ) {
//     alert('The script returned ' + evaldObj );
// }
//
// ajax = new QPAjax();
// ajax.RequestJS((demoLocation + 'demo.js'), showReturnValue);
//
function QPAjax_RequestJS(url, sFunc, meth, eFunc)
{
	QPAjax_Request(url, sFunc, meth, eFunc, "javascript");
}


// Request XML data,
// try to create an XML document from the returned XML.
// (This data can then be parsed using the JS DOM APIs).
function QPAjax_RequestXML(url, sFunc, meth, eFunc)
{
	QPAjax_Request(url, sFunc, meth, eFunc, "xml");
}


// Submit a Form asynchronously
//
// No URL required, because the form's action property is used.
//
// Required args:
//  formId: the id of the <form> tag
//  sFunc: "success" callback function with returned data as argument.
//
// Optional args:
//  eFunc: "error" callback function with error code as argument.
//
function QPAjax_SubmitForm(formId, sFunc, eFunc)
{
	var theErrFunc = eFunc || this.Error;

	try {
		dojo.xhrPost ({
			form: formId,
			load: function(data){sFunc(data)},
			error: function(error){theErrFunc(error)}
		});
	}
	catch(e) {
		this.Error(e);
	}
}

// FIX ME: report error
function QPAjax_Error(error)
{
	alert(QuickrLocaleUtil.getStringResource("AJAX.ERROR") + error.message);
}

// Returns the subtype 
// 
//Dojo.xhr requires handleAs to be the subtype only (ex: "text", "xml")
function returnSubType(mType){
	
	if (mType == "text/plain") 
		return "text";
	
	else if (typeof(mType) == "undefined") 
		return;
		
	else 
		return (mType.substring(mType.indexOf("/") + 1, mType.length));

}
/*********************************************************************/
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2005, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/*********************************************************************/

//-------------------------------------------------------------
//  Quickplace Context Menu library
//-------------------------------------------------------------

var g_pageX = 0;
var g_pageY = 0;

//---------------------------------------------------------------------

function QP_ContextMenu_Item(type, label, action, target, title, title_disabled, icon, submenu)
{
	this.type = type; 
	this.label = label || "";
	this.action = action || "";
	this.target = target || "_self";
	this.title = title || this.label;
	this.title_disabled = title_disabled || this.title;
	this.icon = icon;
	this.submenu = submenu;

}

function QP_ContextMenu(name, extraClass, bIcons)
{
	this.name				= name;
	this.extraClass		= extraClass;
	this.items				= new Array();
	this.bShowIcons		= (bIcons===undefined ? true : bIcons);
	
	this.write				= QP_ContextMenu_write;
	this.show				= QP_ContextMenu_show;
	this.addItem			= QP_ContextMenu_addItem;
	this.addSubmenu		= QP_ContextMenu_addSubmenu;
	this.addHTML			= QP_ContextMenu_addHTML;
	this.addSeparator		= QP_ContextMenu_addSeparator;
	this.addImage			= QP_ContextMenu_addImage;
	this.fixName			= QP_ContextMenu_fixName;
	this.makeItem			= QP_ContextMenu_makeItem;
	this.makeSeparator	= QP_ContextMenu_makeSeparator;
	this.addBizCard		= QP_ContextMenu_void;

	this.HTML				= 0;
	this.LINK				= 1;
	this.LINK_SUBMENU		= 2;
	this.IMAGE				= 3;
	this.SEPARATOR			= 4;
}

function QP_PersonMenu(szDN, szCN, szDisplayName, szEmail, szPhone, szPhoto, szDescription, szProfileUnid)
{ 
	var fixedName = QP_ContextMenu_fixName(szDN);

	// Inherit from QP_ContextMenu
	this.base				= QP_ContextMenu;
	this.base(fixedName);

	this.CN					= szCN;
	this.DN					= szDN;
	this.displayName		= szDisplayName || szCN;
	this.email				= szEmail || "";
	this.phone				= szPhone || "";
	this.photo				= szPhoto || "";
	this.description		= szDescription || "";
	this.profileUnid		= szProfileUnid || "";
	
	this.addBizCard		= QP_PersonMenu_addBizCard;
	this.makeBizCard		= QP_PersonMenu_makeBizCard;
	this.write				= QP_PersonMenu_write;
}
QP_PersonMenu.prototype = new QP_ContextMenu;

// ---------------------------------------------------------

function QP_ContextMenu_void()
{ 
	return false;
}

function QP_ContextMenu_get(name)
{ 
	return document.getElementById(name + "_Menu");
}

function QP_ContextMenu_exists(name)
{ 
	return (document.getElementById(name + "_Menu") != null);
}

// Convert menu name (which may be a Notes canonical name) to a valid HTML Id that we can use
// as a basis for menu-related HTML elements.
// Must begin with a letter ([A-Za-z]) and may be followed by any number of letters, digits ([0-9]),
// hyphens ("-"), underscores ("_"), colons (":"), and periods (".").
function QP_ContextMenu_fixName(name) {
	if (typeof(name) == "undefined")
		return "";
	else
		return name.replace(/[.=\/ ]/g, "-");
//	return encodeForUrl(encodeURIComponent(name));
}

// Set coordinates to mouse click position
function QP_ContextMenu_mouseTracker(e)
{
    e = e || window.Event || window.event;
    g_pageX = e.pageX || e.clientX;
    g_pageY = e.pageY || e.clientY;
}


// ---------------------------------------------------------

function QP_ContextMenu_addItem(label, action, target, title, icon, title_disabled)
{ 
	this.items[this.items.length] = new QP_ContextMenu_Item(this.LINK, label, action, target, title, title_disabled, icon);
}

function QP_ContextMenu_addSubmenu(label, action, target, title, icon, title_disabled, submenu)
{ 
	this.items[this.items.length] = new QP_ContextMenu_Item(this.LINK_SUBMENU, label, action, target, title, title_disabled, icon, submenu);
}

function QP_ContextMenu_addImage(label, action, target)
{ 
	this.items[this.items.length] = new QP_ContextMenu_Item(this.IMAGE, label, action, target);
}

function QP_ContextMenu_addHTML(label, action, target)
{ 
	this.items[this.items.length] = new QP_ContextMenu_Item(this.HTML, label, action, target);
}

function QP_ContextMenu_addSeparator(label, action, target)
{ 
	this.items[this.items.length] = new QP_ContextMenu_Item(this.SEPARATOR, "", "", "");
}

// ----------------------------------------------------------
// Generate HTML for one menu item
//
function QP_ContextMenu_makeItem(szLabel, szAction, szTitle)
{
	var title = szTitle || szLabel;
	var action = szAction || "#";
	var html = "";

	html += '<li><a id="' + this.name + '_' + QP_ContextMenu_fixName(szLabel) + '"';
	if (szAction == "") {
		 // Item is inactive - show as greyed out
		 html += ' href="javascript:void(0);" class="h-contextMenu-disabled"';
	}
	else {
		 if (title != "")
			  html += ' title="' + title + '"';
		 html += ' href="' + action + '"';
	}
	html += '>' + szLabel + '</a></li>';
	return html;
}

// ----------------------------------------------------------
// Generate HTML separator for context menu items
//
function QP_ContextMenu_makeSeparator()
{
	return '<li class="h-context-separator"><hr/></li>';
}


// ----------------------------------------------------------

function QP_PersonMenu_addBizCard(szDisplayName, szEmail, szPhone, szPhoto, szDescription, szUNID)
{ 
	this.displayName		= szDisplayName || this.szCN;
	this.email				= szEmail || "";
	this.phone				= szPhone || "";
	this.photo				= szPhoto || "";
	this.description		= szDescription || "";
	this.profileUnid		= szUNID || "";
}

// ----------------------------------------------------------
// Generate HTML separator for context menu items
//
function QP_PersonMenu_makeBizCard()
{
	var html = "";
	html += '<div class="photoCard">';
	html += '<img id="' + this.name + '_photo" src="' 
		+ getMemberPhotoLink(this.CN, this.DN, this.DisplayName, this.email, this.photo, this.profileUnid)
		+ '" alt="">';
	html += '</div>';

	html += '<div class="businessCard">';
	html += '<ul style="list-style-type:none; margin-left:0px;">';
	html += '<li id="' + this.name + '_name" class="cardName">' + this.displayName.replace(/\\\'/g, "'") +'</li>';
	html += '<li id="' + this.name + '_email">' + ceInsertMarkersforStaticString(this.email, 'ceEMAIL') + '</li>';
	//For SPR ASHH8NM4UE
	var tmp = this.description.replace(/\\\'/g,"'");
	html += '<li id="' + this.name + '_desc">' + QuickrGeneralUtil.encodeEntities(tmp) + '</li>';
	html += '<li id="' + this.name + '_phone">' + this.phone + '</li>';
	html += '</ul>';
	html += '</div>';
	return html;
}

// ----------------------------------------------------------

function QP_PersonMenu_write()
{ 
	var html = "";

	// Create the span that surrounds the entire menu
	var menu = document.createElement("span");
	menu.id = (this.name + "_Menu");
	if((document.body.dir=='rtl')&&(h_ClientBrowser.isIE ())){menu.style.display="none";}
	else menu.style.left="-9999px";
	menu.style.position="absolute";
	// SPR_WEBB7QGSDU
	menu.style.zIndex="1001";
	
	// Create unordered list
	html += '<div class="personMenu">';

	html += this.makeBizCard();

	html += '<div class="personMenuActions">';

	html += '<ul id="' + this.name + '_Top" style="list-style-type:none; margin-left:0px;"';
	for (var i = 0; i < this.items.length; i++)
	{
		if (this.items[i].type == this.LINK) {
			html += this.makeItem(this.items[i].label, this.items[i].action);
		}
		else if (this.items[i].type == this.SEPARATOR) {
			 html += this.makeSeparator();
		}
	}
	html += '</ul>';
	html += '</div>';
	html += '</div>';

	menu.innerHTML = html;
	document.body.appendChild(menu);
}

// Accessibility: To save focus which can be used after menu hide

var hash_savedFocus = {};


// ----------------------------------------------------------

function QP_ContextMenu_write()
{ 
	var ul = document.createElement("ul");
	ul.className="lotusActionMenu";
	//for a11y
	dojo.attr(ul,"tabindex",0);
 	if (this.extraClass)
 		ul.className += (" " + this.extraClass);
	ul.style.opacity="0.999999";
	if((document.body.dir=='rtl')&&(h_ClientBrowser.isIE ())){ul.style.visibility="hidden";}
	else if (document.body.dir=='rtl') {ul.style.right="-9999px";}
	else {ul.style.left="-9999px";}

	//a11y: handle escape key down
	dojo.connect(ul,"onkeydown",dojo.hitch(this,function(event){
		if(event.keyCode == dojo.keys.ESCAPE){
			
			dijit.focus(hash_savedFocus[this.name+"_Menu"]);
			var saveFocusNode = null;
			if(hash_savedFocus[this.name+"_Menu"])
				saveFocusNode = hash_savedFocus[this.name+"_Menu"].node;
			if(saveFocusNode && saveFocusNode.parentNode && saveFocusNode.parentNode.parentNode && saveFocusNode.parentNode.parentNode.id && saveFocusNode.parentNode.parentNode.id.substring(saveFocusNode.parentNode.parentNode.id.length-5)=="_Menu")
			{
				QP_ContextMenu_hideSubmenus(saveFocusNode.parentNode.parentNode.id);
			}else{
				QP_ContextMenu_hide();
			}						

			event.stopPropagation();
		}
	}));

	
	var bAddSep=false;
	for (var i = 0; i < this.items.length; i++)
	{
		switch (this.items[i].type) {
		case this.LINK:
			var li=document.createElement("li");
			var a=document.createElement("a");

			a.id=this.name+"_"+QP_ContextMenu_fixName(this.items[i].label);
			a.innerHTML=this.items[i].label;

			var liClass="";
			var action=this.items[i].action;
			if (action == "") {
				// Item is inactive
				liClass="disabled"; // FIX ME: temporary until One UI style exists
				a.href="#";
				a.onclick=function(){return false;}
			}
			else {
				a.href=action;
				a.target=(this.items[i].target=="_blank" ? "_blank" : "_self");
				
				//a11y: hide menu when action item is triggered.
				dojo.connect(a,"onkeydown",function(event){
					if(event.keyCode == dojo.keys.ENTER)
						onBodyClick(event);
				});

				
				a.onmouseover = a.onfocus =function(){QP_ContextMenu_hideSubmenus(this.parentNode.parentNode.id);};
			}

			if (bAddSep) {
				if (liClass.length > 0)
					liClass += " ";
				liClass += "lotusMenuSeparator";
				bAddSep=false;
			}

			if (liClass.length > 0)
				li.className=liClass;

			li.appendChild(a);
			ul.appendChild(li);
			break;

		case this.LINK_SUBMENU:
			var li=document.createElement("li");

			var a=document.createElement("a");
			a.href="#";
			a.onclick=function(){return false;}
			a.innerHTML=this.items[i].label;

			var liClass="submenu";
			if (this.items[i].submenu == "") {
				// Item is inactive
				liClass += " disabled"; // FIX ME: temporary until One UI style exists
			}
			else {
				a.id=this.name+"__SUB__"+this.items[i].submenu;
				var submenuHandler = function(){
					var smName=this.id.substring(this.id.lastIndexOf("__SUB__")+7);
					QP_ContextMenu_hideSubmenus(this.parentNode.parentNode.id);
					QP_ContextMenu_showSubmenu(this, smName);
				};
				// a11y: handle enter key to launch sub menu
				dojo.connect(a,"onkeydown",function(event){
					//console.debug("event.keyCode="+event.keyCode);
					if(event.keyCode == dojo.keys.ENTER)
						submenuHandler.call(this);
				});
				a.onmouseover = submenuHandler;
			}

			if (bAddSep) {
				liClass += " lotusMenuSeparator";
				bAddSep=false;
			}

			li.className=liClass;
			li.appendChild(a);
			ul.appendChild(li);
			break;

		case this.SEPARATOR:
			bAddSep=true;
			break;

		default:
			break;
		}
	}

	var id=this.name+"_Menu";
	var m1=dojo.byId(id);
	if (m1) {
		// menu already exists - replace it
		var pa=m1.parentNode;
		pa.replaceChild(ul,m1);
		ul.id=id;
	}
	else {
		// create new
		var div = document.createElement("div");
		div.style.position="absolute";
		if((document.body.dir=='rtl')&&(h_ClientBrowser.isIE ())){div.style.right="0px";}
		else 
		div.style.left="0px";
		div.style.top="0px";
		div.style.zIndex="900";
		div.appendChild(ul);
		ul.id=id;
		document.body.appendChild(div);
	}	
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// DISPLAY FUNCTIONS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Active menu and item w/in menu
var g_activeMenu = null;
var g_activeItem = null;

// Active menu "stack"
var g_activeIdx = -1;
var g_visibleMenu = new Array();

// Offsets for precise positioning of submenus.
// May need adjusting if changes made in CSS
var hOffsetAdjust = 4;
var vOffsetAdjust = 6;

// Return absolute position of an elem as [x,y]
function findPos(elem)
{
	var x = y = 0;
	if (elem.offsetParent) {
		x = elem.offsetLeft
		if(document.body.dir=='rtl'){x+=elem.offsetWidth;}
		y = elem.offsetTop
		while (elem = elem.offsetParent) {
			x += elem.offsetLeft
			y += elem.offsetTop
		}
	}
	return [x,y];
}

// Show a submenu beside the current active menu item
function QP_ContextMenu_showSubmenu(item, menu)
{
	var pos = findPos(item);
	g_activeItem = item;
	var RTLV = 0;
	if(document.body.dir=='rtl'){RTLV=2*item.offsetWidth;}
	QP_ContextMenu_show(menu,false,(pos[0]+item.offsetWidth-hOffsetAdjust)+5-RTLV, (pos[1]-vOffsetAdjust)+6);
}

// Show a menu (any type)
function QP_ContextMenu_show(menu, bHidePrev, inx, iny, bPersonMenu)
{
	bPersonMenu = (typeof bPersonMenu == "undefined" ? false : bPersonMenu);

	if (inx && iny) {
		// coordinates specified
		g_pageX = inx;
		g_pageY = iny;
	}
	var bHide = (bHidePrev===undefined ? true : bHidePrev);
	if (bHide)
		 QP_ContextMenu_hide();

	g_activeMenu = document.getElementById(menu + "_Menu");
	if (g_activeMenu) {
		// Store the menu id on the "stack"
		g_visibleMenu[++g_activeIdx] = g_activeMenu;

		// adjust the X/Y position so that the entire Menu will show
		var mWidth = g_activeMenu.offsetWidth;
		var mHeight = g_activeMenu.offsetHeight;

		var mScrollPos = document.documentElement.scrollTop;
		if (typeof(window.innerWidth)=='number') {
			//Non-IE
                        if (mScrollPos==0 && window.pageYOffset!=0){ mScrollPos = window.pageYOffset; }
			if (window.innerHeight < (g_pageY - mScrollPos + mHeight)) {
                               g_activeMenu.style.top = g_pageY + (window.innerHeight - (g_pageY - mScrollPos + mHeight) - 2) + "px";
			} else {
      		               g_activeMenu.style.top =  (g_pageY) + "px";
                        }
		}
		else if(document.documentElement && document.documentElement.clientHeight) {
			//IE 6+ in standards compliant mode
			mScrollPos = document.documentElement.scrollTop;
			if (document.documentElement.clientHeight < (g_pageY - mScrollPos + mHeight)) {
                               g_activeMenu.style.top = g_pageY + (document.documentElement.clientHeight - (g_pageY - mScrollPos + mHeight) - 2);
			} else {
       		               g_activeMenu.style.top =  (g_pageY + document.body.scrollTop);
                        }
		}
		else if (document.all) {
			// IE
			mScrollPos = document.documentElement.scrollTop;
			if (document.documentElement.clientHeight < (g_pageY - mScrollPos + mHeight)) {
                               g_activeMenu.style.top = g_pageY + (document.documentElement.clientHeight - (g_pageY - mScrollPos + mHeight) - 2);
			} else {
       		               g_activeMenu.style.top =  (g_pageY + document.body.scrollTop);
                        }
		}


		if((document.body.dir=='rtl')&&(h_ClientBrowser.isIE ()))
		{
		if (document.body.clientWidth < (mWidth+document.body.scrollWidth -g_pageX - mWidth)){
			if (g_pageX < mWidth) {
				g_activeMenu.style.right = (document.body.clientWidth - mWidth - 2) + "px";
			} else {
				g_activeMenu.style.right = (document.body.clientWidth - g_pageX - 2) + "px";
			}
		}
		else {
			if (g_pageX < mWidth) {
				g_activeMenu.style.right = (document.body.scrollWidth - mWidth ) + "px";	
			} else {
				g_activeMenu.style.right = (document.body.scrollWidth - g_pageX ) + "px";
			}
		}
	
		}
		else if(!bPersonMenu && document.body.dir=='rtl')
		{
			if (g_pageX + document.body.scrollLeft < mWidth)
				left = (document.body.scrollLeft - mWidth - 2);
			else
				left = (document.body.scrollLeft - g_pageX);
			g_activeMenu.style.right = Math.min(0,left) + "px";
		}
		else
		{
			var RTLV = 0;
			if(document.body.dir=='rtl') {RTLV = mWidth;}
			if (document.body.clientWidth < (g_pageX + document.body.scrollLeft + mWidth))
				left = (document.body.clientWidth - mWidth - 2 - RTLV);
			else
				left = (g_pageX + document.body.scrollLeft-RTLV);
			g_activeMenu.style.left = Math.max(0,left) + "px";
		}

		g_activeMenu.parentNode.style.zIndex = 1000 + g_activeIdx;
		g_activeMenu.style.display="block";
		g_activeMenu.style.visibility="visible";
		
		//a11y: save the focus and set focus on active Menu.
		hash_savedFocus[g_activeMenu.id] = dijit.getFocus(this);
		g_activeMenu.focus();
	}

	// Hide menu when click outside or timer elapses
	dojo.connect(document, "onmouseup", "onBodyClick");
//	dojo.connect(g_activeMenu, "onmouseout", "onMenuMouseout");
}

function onMenuMouseout(e)
{
	setTimeout("QP_ContextMenu_hide();",3000);
}

function onBodyClick(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	if (elem.className.indexOf("-context") < 0)
		 QP_ContextMenu_hide();
}

// Hide the active menu
function QP_ContextMenu_hide()
{
	while (g_activeIdx >= 0) {
		var bPersonMenu = false;
		if (typeof g_visibleMenu[g_activeIdx].firstChild != "undefined") {
			if (g_visibleMenu[g_activeIdx].firstChild.className == "personMenu") {
				bPersonMenu = true;
			}
		}
		if((document.body.dir=='rtl')&&(h_ClientBrowser.isIE ())){g_visibleMenu[g_activeIdx--].style.visibility="hidden";}
		else if (!bPersonMenu && document.body.dir=='rtl') g_visibleMenu[g_activeIdx--].style.right="-9999px";
		else g_visibleMenu[g_activeIdx--].style.left="-9999px";
	}
}

// Hide all submenus below the active menu
function QP_ContextMenu_hideSubmenus(menuId)
{
	thisMenu = document.getElementById(menuId);
	while (g_activeIdx >= 0 && g_visibleMenu[g_activeIdx] != thisMenu) {
		if((document.body.dir=='rtl')&&(h_ClientBrowser.isIE ())){g_visibleMenu[g_activeIdx--].style.visibility="hidden";}
		else if (document.body.dir=='rtl') g_visibleMenu[g_activeIdx--].style.right="-9999px";
		else g_visibleMenu[g_activeIdx--].style.left="-9999px";
	}
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// MAIN "ONLOAD" FUNCTION TO ATTACH EVENT HANDLERS TO ELEMENTS ON PAGE THAT CAN HAVE A CONTEXT MENU.
// CALL THIS ONLY AFTER PAGE IS LOADED.
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function QP_ContextMenu_attachMenus(elem)
{
	var menuContainer=elem||document;

	if (UIContextMenusAreEnabled())
	{
		var bDocuments = UIContextMenuIsEnabled("documents");
		var bFolders = UIContextMenuIsEnabled("folders");
		var bMyPlaces = UIContextMenuIsEnabled("my_places");
		var bUserNames = UIContextMenuIsEnabled("user_names");

		try {
			// Attach handlers to all elements on page that require one
			var sl = menuContainer.getElementsByTagName("span");

			for (var i=0; i < sl.length; i++)
			{
				var span = sl[i];
				if ((bDocuments && span.className=="h-doc-anchor")
					|| (bFolders && span.className=="h-folder-anchor"))
				{
					var aTags = span.getElementsByTagName("a");
					if (aTags[0]) {
						dojo.connect(span, "onmouseover", "onDocMouseOver");
						dojo.connect(span, "onmouseout", "onDocMouseOut");
					}
				}
				else if (bUserNames && (span.className=="h-user-anchor" || span.className=="vcard"))
				{
					var aTags = span.getElementsByTagName("a");
					if (aTags[0]) {
 						dojo.connect(span, "onmouseover", "onPersonMouseOver");
 						dojo.connect(span, "onmouseout", "onPersonMouseOut");
					}
				}
				else if (bMyPlaces && span.className=="h-my-places-anchor") 
				{
					var aTags = span.getElementsByTagName("a");
					if (aTags[0]) {
						makeMyPlacesContextMenu(aTags[0].innerHTML, aTags[0].href, span);
						dojo.connect(span, "onmouseover", "onMyPlacesMouseOver");
						dojo.connect(span, "onmouseout", "onMyPlacesMouseOut");
					}
				}
				else if (bDocuments && span.className=="h-attachments-anchor") 
				{
					makeAttachmentsMenu(span.id, span.getAttribute("attachments"));
					dojo.connect(span, "onmouseover", "onAttMouseOver");
					dojo.connect(span, "onmouseout", "onAttMouseOut");
				}
			}
		}
		catch(e) {
			// Dojo not installed? Degrade to no menus
		}
	}
} // QP_ContextMenu_attachMenus()


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// EVENT HANDLERS FOR ATTACHMENT MENUS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function onAttMouseOver(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = (elem.className=="h-contextMenu-icon") ? elem : elem.nextSibling;

	if (img) {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_s.gif");
		dojo.connect(img, "onmouseup", "onAttContextMenu");
	}
	e.preventDefault();
}

function onAttMouseOut(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = (elem.className=="h-contextMenu-icon") ? elem : elem.nextSibling;

	if (img) {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_u.gif");
	}
	e.preventDefault();
}

function onAttContextMenu(e)
{
	var img = (e.target) ? e.target : e.srcElement;
	if(!img){
		img = e;
	}
	var pos = findPos(img);
	QP_ContextMenu_show(img.parentNode.id,true,pos[0],(pos[1]+img.offsetHeight));
	try{
		e.preventDefault();
	}
	catch(ex){
	}
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// EVENT HANDLER FOR "CREATE" MENU
//
// NOTE: Not supported in 8.1/8.2!
// These are here for 8.0 themes.
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

var newQPObjMenu;

function onNewQPObjMouseOver(e)
{
	return false;
}

function onNewQPObjMouseOut(e)
{
	return false;
}

function createQPObjMenuItem(formUnid, title, description, docType, importField, publishedFormId)
{
	return false;
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// EVENT HANDLERS FOR DOCUMENT & FOLDER CONTEXT MENUS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function onDocMouseOver(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = (elem.nodeName.toUpperCase()=="A") ? elem.nextSibling : elem;

	if (img) {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_s.gif");
		img.onclick=function(){onDocContextMenu(this);return false;}
	}
	e.preventDefault();
}

function onDocMouseOut(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = (elem.nodeName.toUpperCase()=="A") ? elem.nextSibling : elem;

	if (img) {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_u.gif");
	}
	e.preventDefault();
}

function onDocContextMenu(btn)
{
	var a = btn.previousSibling;
	if (a) {
		// this is the doc name anchor
		try {
			var pos = findPos(btn);
			var imgSrc = btn.src;
			var url = (typeof(h_FolderStorage)=="undefined" ? a.href : "../../"+h_FolderStorage+"/"+a.id+"/?OpenDocument");
			
			dojo.xhrGet ({
				url: url + "&Form=h_DocXml&nowebcaching",
				handleAs: "xml",
				load: function(data) {showDocContextMenu(a.id,a.href,data,btn,imgSrc,pos[0],(pos[1]+btn.offsetHeight));}
			});

			btn.src = "/qphtml/html/common/ajax_loader.gif";
		}
		catch(e) {
			window.location.reload();
		}
	}
}

function showDocContextMenu(name,url,data,img,imgSrc,x,y)
{
	//if they are an editor but the doc is currently locked, they should not see all of the context menu items
	var currentUserAccess_saved = window.currentUserAccess;
	if ( getTagValue(data, "qp_doc", "h_DraftVersionUNID") != "" && window.currentUserAccess == 4 ) window.currentUserAccess = 3;
	
	img.src=imgSrc;
	makeDocContextMenu(name,url,data);
	QP_ContextMenu_show(name,true,x,y);
	
	window.currentUserAccess = currentUserAccess_saved;
}

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// EVENT HANDLERS FOR USER NAME CONTEXT MENUS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function _getPersonMouseImage(elem) {

	
	var img = (elem.nodeName.toUpperCase()=="A") ? elem.nextSibling : elem;
	
	if (img.nodeName.toUpperCase()=="SPAN") {
		return _getPersonMouseImage(img.parentNode);
	} else {
		return img;
	}
	

}
function onPersonMouseOver(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = _getPersonMouseImage(elem);
	
	if (img && img.tagName.toLowerCase()=="img") {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_dropdown.gif");
		img.onclick=function(){onPersonContextMenu(this);return false;}
	}
	e.preventDefault();
}

function onPersonMouseOut(e)
{
	var MSG_CLICK_FOR_USERPROFILE = QuickrLocaleUtil.getStringResource("QP_STRINGS.MSG_CLICK_FOR_USERPROFILE");
	var elem = (e.target) ? e.target : e.srcElement;
	var img = _getPersonMouseImage(elem);
	
	
	if (img && img.tagName.toLowerCase()=="img") {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/clear_pixel.gif");
		img.setAttribute("alt", MSG_CLICK_FOR_USERPROFILE);
		img.setAttribute("height", "16");
		img.setAttribute("width", "16");
	}
	e.preventDefault();
}

function onPersonContextMenu(btn)
{
	var a = btn.previousSibling;
	if (a) {
		// this is the doc name anchor
		try {
			// title attribute is DN
			var dn=QP_ContextMenu_fixName(a.title);
			var pos = findPos(btn);
			var imgSrc = btn.src;

			dojo.xhrGet ({
				url: a.href + "&Form=h_MemberXml&nowebcaching",
				handleAs: "xml",
				load: function(data) {showPersonContextMenu(dn,a.href,data,btn,imgSrc,pos[0],(pos[1]+btn.offsetHeight));}
			});
			
			btn.src = "/qphtml/html/common/ajax_loader.gif";
		}
		catch(e) {
			window.location.reload();
		}
	}
}

function showPersonContextMenu(dn,url,data,img,imgSrc,x,y)
{
	img.src=imgSrc;
	makeUserContextMenu(dn,url,data);
	QP_ContextMenu_show(dn,true,x,y,true);
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// EVENT HANDLERS FOR MY PLACES CONTEXT MENUS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

function onMyPlacesContextMenu(e)
{
	QP_ContextMenu_mouseTracker(e);

	var img = (e.target) ? e.target : e.srcElement;
	var a = img.previousSibling;

	if (a) {
		QP_ContextMenu_show(a.innerHTML + "_MyPlaces");
	}
	e.preventDefault();
}

function onMyPlacesMouseOver(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = (elem.nodeName.toUpperCase()=="A") ? elem.nextSibling : elem;

	if (img) {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_s.gif");
		dojo.connect(img, "onmouseup", "onMyPlacesContextMenu");
	}
	e.preventDefault();
}

function onMyPlacesMouseOut(e)
{
	var elem = (e.target) ? e.target : e.srcElement;
	var img = (elem.nodeName.toUpperCase()=="A") ? elem.nextSibling : elem;

	if (img) {
		// this is the context menu icon
		img.setAttribute("src", "/qphtml/html/common/menu_u.gif");
	}
	e.preventDefault();
}


// ~~~~~~~~~~~~~~~~~~~~~~~~
//
// ATTACHMENT MENU ANCHORS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~


// Generate the <span> containing a document or folder anchor and whatever else is needed
// to associate a context menu with that element.

// SPR #MPUL7K2KWM : exe file download problem in  2008/10/30 
var Browser = 'isNonIE'
if((navigator.userAgent.indexOf('MSIE') >= 0) && (navigator.userAgent.indexOf('Opera') < 0)) 
	Browser = 'isIE'; 
	
function GenerateAttachmentsAnchor(unid,name,size,form)
{
	var aMSO = [	G_FormIDs.CreateMSWordFormUNID, 
			G_FormIDs.CreateMSExcelFormUNID, 
			G_FormIDs.CreateMSPowerPointFormUNID
	];
	
	var html="";
	
   	// SPR XHKG76WAJ9: filter unwanted attachments
	if ( name.indexOf('/') > -1 ) {
		//SPR: #RTIN7NRHLY
		var aN = name.split('/');
		var aS = size.split(',');
		
		if (aMSO.indexOf(form) > -1) {
			// MS Office doc: real attachment is first in list
			name = aN[0]
			size = aS[0];
			
		} else {
			// Filter out all the TMPxxxx files from the list (generated from quickr backend)
			var aN_temp = new Array();
			var aS_temp = new Array();

			for (i=0; i<aN.length; i++) {
				if (!QuickrGeneralUtil.isInternalFileName(aN[i],form)) {
					aN_temp.push( aN[i] );
					aS_temp.push( aS[i] );
				}
			}
			if (form == G_FormIDs.HTMLPageFormUNID) {
				name = aN_temp[aN_temp.length-1];
				size = aS_temp[aS_temp.length-1];
				if (typeof(name) == "undefined") {
					name = "";
				}
			} else {
				name = aN_temp.join("/");
				size = aS_temp.join(",");
			}
		}		
	}

	//SPR: #RTIN7NRHLY
	if (name.indexOf('/') < 0) {
		// There's only one attachment
		szAlt = QuickrGeneralUtil.encodeEntities(name);
		szAlt = size ? QuickrLocaleUtil.getStringResource("CONTEXT.DOWNLOADSIZE").replace("{0}",szAlt).replace("{1}",size) : QuickrLocaleUtil.getStringResource("CONTEXT.DOWNLOAD").replace("{0}",szAlt);
		name = encodeURIComponent(name);
		var linkurl = generateAttachmentLinkHref(unid,name);
		var linktarget = "";
		if (linkurl.indexOf("QuickrSupportUtil") == -1) {
			linktarget = " target=\"_blank\" ";
		}
		html = '<a href="' + linkurl + '"'
			+ ' alt="'+szAlt+'" title="'+szAlt+'" ' + linktarget + '>'
			+ '<img style="border:none;" src="/qphtml/html/common/download.gif" alt="'+szAlt+'"/>'
			+ '<img alt="" class="h-contextMenu-icon" height="16" width="16" '
			+ 'src="/qphtml/html/common/clear_pixel.gif"/>'
			+ '</a>';
	}
	else {
		mName = unid + "_files";
		html = '<span id="'+mName+'" attachments="'+escape(name)+';'+escape(size)+'" class="h-attachments-anchor">'
			+ '<img style="border:none;padding-right:2px;" src="/qphtml/html/common/download.gif"/>'
			+ '<a href="javascript:;" onclick="javascript:onAttContextMenu(this)" ><img class="h-contextMenu-icon" '
			+ 'title="' + QuickrLocaleUtil.getStringResource("CONTEXT.ATTACHMENTS") + '" alt="' 
			+ QuickrLocaleUtil.getStringResource("CONTEXT.ATTACHMENTS") 
			+ '" src="/qphtml/html/common/menu_u.gif"/></a>'
			+ '</span>';
	 }
 	return html;
}

// Generate the menu for a set of attachments.
function makeAttachmentsMenu(name,aNS)
{
	var menu = new QP_ContextMenu(name,"",false);
	if (!menu.exists)
	{
		var unid = name.substring(0,name.indexOf('_'));
		var a = aNS.split(';');
		//SPR: #RTIN7NRHLY
		var aN = unescape(a[0]).split('/');
		var aS = unescape(a[1]).split(',');
		for (i=0; i<aN.length; i++) {
			// SPR #MPUL7K2KWM : exe file download problem in  2008/10/30 
			if(aN[i].indexOf('\.exe') > 0 && Browser == 'isIE'){
				menu.addItem(aN[i],
							 '../../$defaultview/' + unid + '/$File/' + encodeURIComponent(aN[i]) ,
							 generateAttachmentLinkHref(unid,aN[i]),
							 "", null, "/qphtml/html/common/doc_download.gif",
							 QuickrLocaleUtil.getStringResource("CONTEXT.DOWNLOADBYTES").replace("{0}",aS[i]));
			}
			else{
				var szUrl = generateAttachmentLinkHref(unid,aN[i]);
				var szTarget = "";
				if (szUrl.indexOf("QuickrSupportUtil") == -1) {
					szTarget = "_blank";
				}
				menu.addItem(aN[i],
							 szUrl, szTarget, null, "/qphtml/html/common/doc_download.gif",
							 QuickrLocaleUtil.getStringResource("CONTEXT.DOWNLOADBYTES").replace("{0}",aS[i]));  
			}
			
		}
		menu.write();
	}
}

function generateAttachmentLinkHref (docid, fileName) {
		
	return QuickrGeneralUtil.getDownloadLink(docid, fileName);
		
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// USER NAME CONTEXT MENU ANCHORS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Generate the <span> containing a user name anchor (<a> tag) and whatever else is needed
// to associate a context menu with that element.
//
function makeUserNameAnchor(szDN, szCN, szCNPostfixHTML)
{
	var MSG_CLICK_FOR_USERPROFILE = QuickrLocaleUtil.getStringResource("QP_STRINGS.MSG_CLICK_FOR_USERPROFILE");
	var url=getMemberInfoLink(szDN);
	if (url && szCN != '')
	{	
		var memPostfix = szCNPostfixHTML || ''; // Default: no text - e.g., "(Group)" - after name
		// Add a blank before <span> to make it work in Safari. SPR #DYLU7AV623 "Safari UI: banner display problem" 
		return ' <span class="h-user-anchor">'
			 + '<a href="' + url + '" title="' + szDN + '">' + szCN + memPostfix + '</a>'
			 + '<img alt="' + MSG_CLICK_FOR_USERPROFILE + '" title="' + MSG_CLICK_FOR_USERPROFILE + '" class="h-contextMenu-icon" height="16" width="16" src="/qphtml/html/common/clear_pixel.gif"/>'
			 + '</span>';
	}
	else {
		return szCN;
	}
}


// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//
// DOCUMENT & FOLDER CONTEXT MENU ANCHORS
//
// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// Duplication of preprocessor #defines, so we can have this code here and not in template
// for now - should probably move back to template (h_ContextMenus.h) eventually.
var D_QPTypeFolder = "1";
var LABEL_YES = QuickrLocaleUtil.getStringResource("QP_CONTEXT_MENU.LABEL_YES");

// Generate the anchor (<a>) tag for a document, folder, etc.
function GenerateQPObjURLAnchorTag(folderName, qpObjUnid, urlPointer, urlNewWindow, szDocType)
{ 
	var objUrl = GenerateQPObjURLString (folderName, qpObjUnid, urlPointer);

	var aTag = '<a';
	aTag += ' id="' + qpObjUnid + '"'; // NB! Assumes this will never appear twice on the same page!
	aTag += ' href="' + objUrl + '"';

	if (urlNewWindow==LABEL_YES) {
		aTag += ' target="_blank"';
	}
	aTag += '>';

	return (aTag);
}

// Generate the <span> containing a document or folder anchor and whatever else is needed
// to associate a context menu with that element.
function GenerateQPObjURLAnchor(type, aTag, aInner)
{ 
	var span = '<span class=' + (type==D_QPTypeFolder?"h-folder-anchor":"h-doc-anchor") + '>';

	// Add the <a> tag and its inner HTML
	span += (aTag + aInner.replace(new RegExp("<","g"),"&lt;") + '</a>');
	span += '<a href="javascript:;" onclick="javascript:onDocContextMenu(this);" ><img class="h-contextMenu-icon" title="' + QuickrLocaleUtil.getStringResource("CONTEXT.OPTIONS") + '" alt="' + QuickrLocaleUtil.getStringResource("CONTEXT.OPTIONS") + '" src="/qphtml/html/common/menu_u.gif"/></a>';
	span += '</span>';

	return (span);
}


// ~~~~~~~~~~~~~~~~~~~
//
// SIMPLE XML PARSING
//
// ~~~~~~~~~~~~~~~~~~~

// Parse XML containing document-related data.
function getTagValue(xmlDoc, docTag, tag)
{
	try
	{
		//Open the XML Document
		var root = xmlDoc;
		var docs = root.getElementsByTagName(docTag);
		var docTags = docs[0].getElementsByTagName(tag);

		if (docTags.length >= 1) {
			 var val = getNodeValue(docTags[0]);
			 return val;
		}
		else {
			 return "";
		}
	}
	catch (e)
	{
		return "";
	}
}

function getNodeValue (node) {
	if (typeof node.textContent != 'undefined')
	{
		return node.textContent;
	}
	else if (typeof node.innerText != 'undefined')
	{
		return node.innerText;
	}
	else if (typeof node.text != 'undefined')
	{
		return node.text;
	}
	else
	{
		switch (node.nodeType)
		{
			case 3:
			case 4:
				return node.nodeValue;
				break;
			case 1:
			case 11:
				var innerText = '';
				for (var i = 0; i < node.childNodes.length; i++)
				{
					innerText += getNodeValue(node.childNodes[i]);
				}
				return innerText;
				break;
			default:
				return '';
		}
	}
}
/*********************************************************************/
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2005, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/*********************************************************************/

//-------------------------------------------------------------
// Quickplace Drag & Drop library
//-------------------------------------------------------------

function QP_DragAndDrop_makeHandle(unid)
{
	return '<img class="drag-image" id="DH_'+unid+'"'
		+ ' onmouseover="this.origSrc=this.src;this.style.cursor=\'move\';this.src=\'/qphtml/html/common/draghndl_hover.gif\';"'
		+ ' onmouseout="this.src=this.origSrc;this.style.cursor=\'default\';"'
		+ ' src="/qphtml/html/common/drag_icon.gif"'
		+ ' title="' + QuickrLocaleUtil.getStringResource("DND.DRAG") + '" alt="'
		+ QuickrLocaleUtil.getStringResource("DND.DRAG") + '"/>';
}

var h_bInsideDragSource = false;
//------------------------------------------------------------------------------------
// Tag to mark the beginning of a drag source area.
//
function QP_DragAndDrop_makeContainer(tag, unid, cName)
{
	var c=((cName===undefined || cName=="") ? "" : " class=\""+cName+"\"");
	return '<'+tag+' id="DC_'+unid+'"'+c
		 + ' onmouseover="this.className=\'h-dragSource-selected\'; document.getElementById(\'DH_'+unid+'\').style.visibility=\'visible\';"'
		 + ' onmouseout="this.className=\'h-dragSource-deselected\'; document.getElementById(\'DH_'+unid+'\').style.visibility=\'hidden\';"'
		 + '>';
}

function QP_DragAndDrop_sourceBegin(tag, unid, nC, lev)
{
	var html="";

	// Do not make a doc with response(s) draggable unless manager
	if (UIDragAndDropIsEnabled() && lev==1 && currentUserAccess>2) {

		// Terminate preceeding drag source first
		html += QP_DragAndDrop_sourceEnd(tag);

		if (!(currentUserAccess<6 && nC>0))
		{
			h_bInsideDragSource = true;
			html += QP_DragAndDrop_makeContainer(tag, unid);
		}
	}
	return html;
}

//------------------------------------------------------------------------------------
// Tag to mark the end of a drag source area.
//
function QP_DragAndDrop_sourceEnd(tag)
{ 
	var html="";
	if (h_bInsideDragSource) {
		h_bInsideDragSource = false;
		html += ("</" + tag + ">");
	}
	return html;
}


//------------------------------------------------------------------------------------
// Create all objects needed for drag & drop
//
function QP_DragAndDrop_createObjects(tag, szContainerId)
{
	if (UIDragAndDropIsEnabled() && currentUserAccess>2)
	{
		QP_DragAndDrop_initDragSources(tag, szContainerId);
//		QP_DragAndDrop_initDropTargets("toc", "div");
		QP_DragAndDrop_createForm();
	}
}

//------------------------------------------------------------------------------------
// Initialize all drag sources
// within a containing table whose id is szContainerId.
//
function QP_DragAndDrop_initDragSources(tag, szContainerId)
{

	var dl = document.getElementById(szContainerId);
	if (dl != null && UIDragAndDropIsEnabled() && currentUserAccess>2)
	{
		var dragList =  qp_getElementsByClassName("h-dragSource", "*", dl);

		for (var i=0; i < dragList.length; i++)
		{
			var ds = new dojo.dnd.HtmlDragSource(dragList[i], "dojoDragList");

			var unid = dragList[i].id.substring(8); // FIX ME: magic number
			var dh = document.getElementById("DH_"+unid);
			if (dh) {
				dojo.html.disableSelection(dh);
				ds.setDragHandle(dh);
			}

			dojo.connect(ds, "onDragEnd", function(e) {

				// Get enclosing drag source element
				if (e.dragObject && e.dragStatus == "dropSuccess") {
					// dragged it to a drop target
					var dragNode = e.dragObject.domNode;
					if (dragNode) {
						var parent = dragNode.parentNode;
						var srcUnid = dragNode.id.substring(8); // FIX ME: magic number

						// alert("onDragEnd: " + "\ndropped " +  dragNode.id + " to " + parent.id);
						QP_DragAndDrop_copyMove(srcUnid, parent.id, "1");
							  
						dojo.dom.removeNode(dragNode);
						var dc = document.getElementById("DC_"+srcUnid);
						if (dc) {
							// Remove container of draggable content
							dojo.dom.removeNode(dc);
						}
					}
				}
				//else {
				// Invalid drop
				// alert("drag object="+e.dragObject+"\nstatus="+e.dragStatus);
				//}
			});
		}
	}
}

//------------------------------------------------------------------------------------
// Initialize all drop targets with tag szTag,
// within a containing tag whose id is szContainerId.
//
function QP_DragAndDrop_initDropTargets(szContainerId, szTag)
{
	var container = document.getElementById(szContainerId);
	if (container != null && UIDragAndDropIsEnabled() && currentUserAccess>2)
	{
		var dropList = container.getElementsByTagName(szTag);

		for (var i=0; i < dropList.length; i++) 
		{
			if (dropList[i].className.indexOf("dropTarget") >= 0) 
			{
				// Don't make CURRENT or Index folder a drop target
				if (dropList[i].id != h_FolderStorage && dropList[i].id != "h_Index") {

					var dt = new dojo.dnd.HtmlDropTarget(dropList[i], ["dojoDragList"]);

					// FIX ME BRR:
					// It would be nice to change the folder icon when dragged over,
					// but these Dojo events don't reliably return the id of the
					// element being dragged over, so can't do this for now.

// 					dojo.connect(dt, "onDragOver", function(e) {

// 						console.log(e.target.tagName);
// 						if (e.target.tagName.toLowerCase() == "div") {
// 							var imgs = e.target.getElementsByTagName("img");
// 							if (imgs[0]) {
// 								imgs[0].src = "/qphtml/html/common/folder_selected.gif";
// 							}
// 						}							
// 						else if (e.target.tagName.toLowerCase() == "img")
// 							e.target.src = "/qphtml/html/common/folder_selected.gif";
// 					});
						
// 					dojo.connect(dt, "onDragOut", function(e) {
// 						console.log(e.target.tagName);
// 						if (e.target.tagName.toLowerCase() == "img")
// 							e.target.src = "/qphtml/html/common/folder_close.gif";
// 					});
				}
			}
		}
	}
}

//------------------------------------------------------------------------------------
// Initialize a single drop target
//
function QP_DragAndDrop_initDropTarget(obj)
{
	if (UIDragAndDropIsEnabled() && currentUserAccess>2)
	{
		new dojo.dnd.HtmlDropTarget(obj, ["dojoDragList"]);
	}
}

// --------------------------------------------------
// Copy or move a doc to a folder
// Change to a "wait" cursor until response received.
//
function QP_DragAndDrop_copyMove(srcUnid, destUnid, bMoveIt)
{
	var copyOrMove = (bMoveIt ? "1" : "0");
	var form = document.getElementById("copyMoveForm");
	if (form) {

		var nonceToken = getCookie("NonceToken");
		form.action = getAbsoluteRoomURL(self) + '/' + h_FolderStorage + '/' + srcUnid + '/?EditDocument&PreSetFields=h_Nonce;' + nonceToken;

		form.h_Move.value = copyOrMove;
		form.h_DestRoomNsfName.value = currentRoom.roomNsf;
		form.h_DestFolderUNID.value = destUnid;
		form.h_SetPublishToFolder.value = destUnid;
		form.h_SetDeleteList.value = srcUnid;
		form.h_HandleResponses.value = "1";

		QPAjax_SubmitForm("copyMoveForm", sFunc, eFunc);
	}
}

function sFunc(data)
{
}

// This is sidHaikuPagesNotMoved from nquickplacers.rc.
function eFunc(data)
{
	alert(QuickrLocaleUtil.getStringResource("DND.ERROR"));
	location.reload();
}



// --------------------------------------------------
// Create the form used to submit an asynch request
// to copy or move a doc to a folder
//
function QP_DragAndDrop_createForm()
{
	// Add form to copy/move docs to this page
	var form = document.createElement("form");
	form.id = "copyMoveForm";
	form.method = "POST";
	form.name="h_CopyMoveForm";
	 
	var html = "";
	html += '<input type="hidden" name="h_EditAction" value="h_Ajax">';
	html += '<input type="hidden" name="h_Move">';
	html += '<input type="hidden" name="h_HandleResponses" value="0">';
	html += '<input type="hidden" name="h_AllDocs" value="">';
	html += '<input type="hidden" name="h_DestRoomNsfName" value="">';
	html += '<input type="hidden" name="h_DestFolderUNID" value="">';
	html += '<input type="hidden" name="h_SetPublishToFolder" value="">';
	html += '<input type="hidden" name="h_SetPublishAboveTocEntry" value="">';
	html += '<input type="hidden" name="h_SetDeleteList" value="">';
	html += '<input type="hidden" name="h_SetCommand" value="h_MoveCopyPages">';
	html += '<input type="hidden" name="h_NoSceneTrail" value="1">';
	 
	form.innerHTML = html;
	document.body.appendChild(form);
}		
/*********************************************************************/
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2005, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/*********************************************************************/

//-------------------------------------------------------------
//  Quickplace common folder display functions
//-------------------------------------------------------------

dojo.addOnLoad(function(){
	if(isHijri){dojo.require("dojox.date.IslamicDate");}
	if(isHebrew){dojo.require("dojox.date.HebrewDate");}
});

function returnSaveDateTime(date){
	return convertDate(date) + " " + convertTime(date);
}

function convertDate(date){
	var ret = "";
	var sep = haiku.h_Intl_DateString;
	var year = date.getFullYear();

	if(isHijri){
			date = new dateHijri().gregorianToHijri(date);
			year = date.getFullYear();
		}
	if(isHebrew){
				date = new dateHebrew().gregorianToHebrew(date);
				year = date.getFullYear();
			}
	
	var month =(((date.getMonth()+1) < 10) ? "0" : "") + (date.getMonth()+1);
	var day =((date.getDate() < 10) ? "0" : "") + date.getDate();
	if(haiku.h_Intl_DateFormat == haiku.kszDMY) {
		ret = day + sep + month + sep + year;
	}else if(haiku.h_Intl_DateFormat == haiku.kszYMD){
		ret = year + sep + month + sep + day;
	}else{
		ret = month + sep + day + sep + year;
	}
	return ret;
}

function convertTime(date){
	var ret = "";
	var am_pm = "";
	var hrs = date.getHours();
	var mins = date.getMinutes();
	var mins = ((mins < 10) ? "0" : "") + mins;
	if(!haiku.h_Intl_MilitaryTime){
		am_pm = ((hrs >= 12) ? ' ' + haiku.h_Intl_PMString : ' ' + haiku.h_Intl_AMString);
		hrs  = ((hrs > 12) ? hrs - 12 : hrs);
		if(hrs == 0) hrs = 12;
	}
	return (hrs + haiku.h_Intl_TimeString + mins + am_pm);
}


//-----------------------------------------------------------------
// FUNCTIONS USED TO IMPLEMENT FOLDER SCENE SKIN COMPONENTS

function FolderItemsPerPageLink(n, szN, szTitle)
{
	var cnt = h_FolderNavBaseURL.indexOf("&Count="); 
	var url = h_FolderNavBaseURL.substring(0, cnt+7);
	 
	document.write('<a '
						+ '" alt="' + szTitle + '" title="' + szTitle 
						+ '" href="' + url + n
						+ '&PresetFields=h_SetReadScene;' + h_SetReadScene
						+ '">' + szN + '</a>');
}

var h_F_MyPlacesParms = new Array("&PresetFields=h_SetReadScene;h_MyPlacesList","&PresetFields=h_SetReadScene;h_MyPlacesDetails");

function FolderShowHideDetailsLink(szShow, szHide, szShowTitle, szHideTitle)
{
	var fS = getFolderStyle();
	if (fS == 'h_MyPlaces') {
		// My Places listing
		var loc = location.href;
		var l=m=n=-1;

		// Get which parm if any, and parm's length
		for (var i=0; i<h_F_MyPlacesParms.length; i++) {
			if ((m=loc.indexOf(h_F_MyPlacesParms[i])) != -1) {
				l=h_F_MyPlacesParms[i].length;
				break;
			}
		}

		if ((n=m+l)>0) {
			// Strip param from current URL
			loc = loc.substring(0, m) + loc.substring(n);
		}

        //SPR:#XZSU7WY874
		document.write('<a href="'
							+ loc + '&PresetFields=h_SetReadScene;'
							+ 'h_MyPlacesDetails'
							+ '"'
							+ ' title="' + (h_SetReadScene == 'h_MyPlacesDetails' ? szHideTitle : szShowTitle) + '"'
							+ ' alt="'   + (h_SetReadScene == 'h_MyPlacesDetails' ? szHideTitle : szShowTitle) + '"'
							+ '>'
							+ (h_SetReadScene == 'h_MyPlacesDetails' ? szHide : szShow)
							+ '</a>');
	}
	else {
		// Folder listing
		document.write('<a href="'
							+ '../../h_Toc/' + h_FolderDoc.h_Unid + '/?OpenDocument&Start=' + h_FolderStart
							+ '&Count=' + (h_SetReadScene == 'h_AbstractsFolderRead' ? 20 : 10)
							+ '&PresetFields=h_SetReadScene;'
							+ (h_SetReadScene == 'h_AbstractsFolderRead' ? 'h_StdFolderRead' : 'h_AbstractsFolderRead')
							+ '"'
							+ ' title="' + (h_SetReadScene == 'h_AbstractsFolderRead' ? szHideTitle : szShowTitle) + '"'
							+ ' alt="'   + (h_SetReadScene == 'h_AbstractsFolderRead' ? szHideTitle : szShowTitle) + '"'
							+ '>'
							+ (h_SetReadScene == 'h_AbstractsFolderRead' ? szHide : szShow)
							+ '</a>');
	}
}

// Same as above, for 8.1/8.2 theme
function qp_folder_SetView(details)
{
	location.href='../../h_Toc/'+h_FolderDoc.h_Unid+'/?OpenDocument&Start='+h_FolderStart
		+ '&Count='+(details ? 10 : 20)
		+ '&PresetFields=h_SetReadScene;'
		+ (details ? 'h_AbstractsFolderRead' : 'h_StdFolderRead');
}

function FolderShowHideResponsesLink(szShow, szHide, szShowTitle, szHideTitle)
{
	if (h_SetReadScene != 'h_AbstractsFolderRead') {
		var i = location.href.indexOf("&Collapse");
		var bShow = (i > -1);
		document.write('<a href="' + (bShow ? location.href.substring(0,i) : location.href+"&CollapseView") + '"'
							+ ' title="' + (bShow ? szShowTitle : szHideTitle) + '"'
							+ ' alt="'   + (bShow ? szShowTitle : szHideTitle) + '"'
							+ '>'
							+ (bShow ? szShow : szHide)
							+ '</a>');
	}
}

function FolderShowingItemsText(szFmt) 
{ 
	if (h_FolderDocCount > 0)
	{
		var s = szFmt;
			  
		var iEndIndex =  h_FolderStart.indexOf( ".");
		if	( iEndIndex == -1) {
			iEndIndex = h_FolderStart.length;
		}
		 
		// The thread start (1 in the above string
		var iThreadStart = h_FolderAbsoluteStartPosition;
		// The last thread in the list
		var rangeEnd = h_FolderAbsoluteStartPosition + iTotNumOfDocs - 1;
		 
		// replace the string which has the following syntax	
		s = s.replace( /\%d/, iThreadStart);
		s = s.replace( /\%d/, rangeEnd);
		s = s.replace( /\%d/, h_FolderDocCount);
		document.write(s);
	}
};


//------------------------------------------------------------------------------------
//

function FolderHideIdIfBlank(sId, fFunct) {
	var preloadid = document.getElementById(sId);
	if (preloadid) {
	
		var bHide = true;
		for (var i = 0; i < preloadid.childNodes.length; i++) {
			if (typeof(preloadid.childNodes[i].tagName) != "undefined" && typeof(preloadid.childNodes[i].innerHTML) != "undefined" && preloadid.childNodes[i].tagName != "SCRIPT") {
				bHide = false;
			}
			if (typeof(fFunct) != "undefined") {
				if (fFunct() == "") {
					bHide = true;
				}
			}
		}
		
		if (bHide) {
			preloadid.style.display = "none";
		}
	}
}

function FolderAlternateTableRowsBackground(sId, sClassName) {
	if (sClassName == null) sClassName = "h-folderitem-bg";
	var mydetailslist = document.getElementById(sId);
	if (mydetailslist) {
		var onoffswitch = false;
		var alltrs = mydetailslist.getElementsByTagName("tr");
		for (var idx = 0; idx < alltrs.length; idx++) {
			if (alltrs[idx].className.toLowerCase() == sClassName.toLowerCase()) {
				if (onoffswitch) {				
					alltrs[idx].className += " h-folderItem-bg-alt";
				}
				onoffswitch = !onoffswitch;
			}
		}
	}
}

// "Stretch" button support
function changeWidth(widthSet)
{
	var cookieName = haiku.userName  +'Width';
	if(widthSet=="fluid"){
		document.body.style.width=100+'%';
		document.getElementById("widthPage").style.display="none";
		document.getElementById("widthPageFixed").style.display="inline";
		setCookie(cookieName,'fluid',7);
	}
	else {
		document.body.style.width=900+'px';
		document.getElementById("widthPageFixed").style.display="none";
		document.getElementById("widthPage").style.display="inline";
		removeCookie(cookieName);
		  
		var mainSize = document.getElementById("portletRenderWidth").offsetWidth;
		var bodySize = document.body.offsetWidth;
		if(mainSize>bodySize){
			document.body.style.width = mainSize +50+'px';
		}
	}
}

// IBM Footer
function toggleFooter() {
	var footerL = document.getElementById('footerMain');
	var footerS = document.getElementById('footerSmall');

	if (footerL.style.display == "none"){
		footerS.style.display="none";
		footerL.style.display="block";
		document.getElementById("footerLinkIDExpand").style.display='none';
		document.getElementById("footerLinkIDCollapse").style.display='block';
	}
	else{
		footerL.style.display="none";
		footerS.style.display="block";
		document.getElementById("footerLinkIDExpand").style.display='block';
		document.getElementById("footerLinkIDCollapse").style.display='none';
	}

	var cookieName = haiku.userName +'Footer';
	var x = getCookie(cookieName);
	if (x=="small") {
		removeCookie(cookieName);
	}else{
		setCookie(cookieName,'small',7);
	}
}



///added by bob/mlr for group expansion
/* START
 * NEW CODE TO SHOW MEMBERS OF A GROUP
 */

function showLinkIfGroup (type, id, name, checkboxname, valueSuffix)
{
	if (typeof(valueSuffix) == "undefined") valueSuffix = "#h_Person";
	
	if (typeof(checkboxname) == "undefined" || checkboxname == null) {
		checkboxname = "h_getEntryNames";
	}
	var ALTTEXT_SHOWMEMBERS = QuickrLocaleUtil.getStringResource("FOLDER.SHOWMEMBERS");

	var retStr = "";
	if ( type == "h_ExternalGroup" || (type == "h_Group" && 0 > id.indexOf("*"))) // SPR#SHEZ88VBA6
	{		
		var srcid = escape(id).replace(/%/g,"_").replace(new RegExp("\/","g"),"__");
		
		retStr = "<a style=\"text-decoration:underline;font-weight:bold;\" title=\"" + ALTTEXT_SHOWMEMBERS + "\" id=\"" + srcid + "\" href=\"javascript: void expandMemberGroup(&quot;" + id + "&quot;,&quot;" + srcid + "&quot;,&quot;" + checkboxname + "&quot;,&quot;" + valueSuffix + "&quot;);\">" + name + "</a>";
	}
	else if ((type == "h_Person") || (type == "h_Group")  || (type == "h_Unknown"))
		retStr = name;
	return retStr;

};


/*******************************
* BB - Code goes through the 
* name and replaces commas with 
* slashes for the separatorsin 
* the canonical name.
*******************************/
function NormalizeCanonical(inStr)
{

	if (inStr.indexOf("=") == -1 || inStr.indexOf(",") == -1) return inStr;

	var bReplace = false;
	var outStr = "";
	
	
	/* loop through the string backwards and replace commas with slashes but only if before equals...*/
	for (var i = inStr.length - 1; i >= 0; i--) {
		var tmp = inStr.substring(i,i+1);

		if (tmp == "=") {
			bReplace = true;
		}
		else
		if (tmp == "/") {
			bReplace = false;
		}
		else
		if (tmp == "," && bReplace) {
			tmp = "/";
			if (outStr.substring(0,1) == " ") {  //remove any trailing spaces in between values
				outStr = outStr.substring(1);
			}			
			bReplace = false;
		}

		outStr = tmp + outStr;


	}

	return outStr;
	
	
}



function expandMemberGroup(unid, srcid, checkboxname, valueSuffix)
{
	if (typeof(valueSuffix) == "undefined") valueSuffix = "#h_Person";

	var ALTTEXT_SHOWMEMBERS = QuickrLocaleUtil.getStringResource("FOLDER.SHOWMEMBERS");
	var ALTTEXT_HIDEMEMBERS = QuickrLocaleUtil.getStringResource("FOLDER.HIDEMEMBERS"); 
	//For SPR DTRR8LJM53
	var srcid_new = "new_" + srcid;
	var srcid_new_table = srcid_new + "_table";
	
	var el = document.getElementById(srcid);
	var el_new = document.getElementById(srcid_new_table);
	
	if (el_new) {
		el_new.parentNode.removeChild(el_new);
		el.setAttribute("title", ALTTEXT_SHOWMEMBERS);
		return;	
	}
	
	
	el.setAttribute("title", ALTTEXT_HIDEMEMBERS);
	
	while (el && el.tagName.toLowerCase() != "td") {
		el = el.parentNode;
	}
	
	var el_table = document.createElement("table");
	
	el_table.setAttribute("id",srcid_new_table);
	el_table.setAttribute("width","100%");
	el_table.setAttribute("border","0");
	
	el.appendChild(el_table);
	
//	dojo.require("dojo.widget.*");
//	dojo.require("dojo.widget.TreeV3");
//	dojo.require("dojo.widget.TreeNodeV3");
//	dojo.require("dojo.widget.TreeBasicControllerV3");
//	dojo.hostenv.writeIncludes();
	
	//var htmltemplate = "<input type=\"checkbox\" value=\"{0}" + valueSuffix + "\" name=\"" + checkboxname + "\"/> {1}";
	//For SPR XUYG8W27VV
	showGroupMembership(unid, srcid, checkboxname, false, false, valueSuffix);
	


}


function showGroupMembership(groupName, rootDivName, checkboxname, isExpanded, showTopLevel, valueSuffix) {

	if (typeof(isExpanded) == "undefined") isExpanded = true;
	if (typeof(showTopLevel) == "undefined") showTopLevel = true;

	//For SPR DTRR8LJM53
	var rootName = "new_" + rootDivName + "_table";
	var root = document.getElementById(rootName);
	
	if (root && root.style.display == "none") {
		root.style.display = "block";
	}
	
	var placeName = window.location.href;
	

	placeName = placeName.substring(0, placeName.toLowerCase().indexOf(".nsf"));
	placeName = placeName.substring(0, placeName.lastIndexOf("/"));
	placeName = placeName.substring(placeName.lastIndexOf("/") + 1);

	// service api has changed, please refer to spr #KHUU86NDDE
	// added nowebcaching as cached version was coming up gzipped which prevented multiple
	// expand and contract of groups
	var loc = "/dm/atom/library/@P{0}/action?action=ldapgetgroupmembers&query={1}&nowebcaching";
	
	loc = loc.replace("{0}", placeName);
	loc = loc.replace("{1}", encodeURIComponent(groupName.replace(new RegExp("\/","g"), "_ESCAPE_SLASH_"))); //For SPR CXBJ8VW9SZ
	
	var subNodes = new Array();
	
	dojo.xhrGet ({
		url: loc,
		handleAs: "text",
		load: function (data, ioArgs) {
					
				var xmldata = _qp_getXMLDocFromString(data);
				
				var eroot = xmldata.getElementsByTagName('viewentries')[0];
				
				var entries = eroot.getElementsByTagName("entrydata");
				
				var el_tbody = document.createElement("tbody");
				
				for (var i = 0; i < entries.length; i++) {
					
					var el_tr = document.createElement("tr");
					
					var xname = entries[i].getAttribute('name');
					xname = NormalizeCanonical(xname);
					var xtype = entries[i].getAttribute('type');
					if(xtype != null)
					{
						xtype = NormalizeCanonical(xtype);
					}
					var xval = _qp_getNodeValue(entries[i]);
					
					var retStr = "";
					
					//For SPR DTRR8LJM53
					if (xtype == "G")
					{
						var encoded_xname = escape(xname).replace(/%/g,"_").replace(new RegExp("\/","g"),"__");
						var el_td1 = document.createElement("td");
						el_td1.setAttribute("width","5%");
						el_td1.setAttribute("align","RIGHT");
						//For SPR XUYG8W27VV
						if(valueSuffix == "#h_Person")
						{
							el_td1.innerHTML = "<input type=checkbox name=" + checkboxname + " value=\"" + xname + "#h_ExternalGroup\">";
						}
						else
						{
							el_td1.innerHTML = "<input type=checkbox name=" + checkboxname + " value=\"" + xname + valueSuffix + "\">";
						}
						el_tr.appendChild(el_td1);
						
						var ALTTEXT_SHOWMEMBERS = QuickrLocaleUtil.getStringResource("FOLDER.SHOWMEMBERS");
						var srcid = rootDivName + "_" + encoded_xname;
						var el_td2 = document.createElement("td");
						el_td2.setAttribute("width","95%");
						//For SPR XUYG8W27VV
						el_td2.innerHTML = "<a style=\"text-decoration:underline;font-weight:bold;\" title=\"" + ALTTEXT_SHOWMEMBERS + "\" id=\"" + srcid + "\" href=\"javascript: void expandMemberGroup(&quot;" + xname + "&quot;,&quot;" + srcid + "&quot;,&quot;" + checkboxname + "&quot;,&quot;" + valueSuffix + "&quot;);\">" + xval + "</a>";
						el_tr.appendChild(el_td2);
					}
					else
					{
						var el_td1 = document.createElement("td");
						el_td1.setAttribute("width","5%");
						el_td1.setAttribute("align","RIGHT");
						//For SPR XUYG8W27VV
						el_td1.innerHTML = "<input type=checkbox name=" + checkboxname + " value=\"" + xname + valueSuffix+ "\">";
						el_tr.appendChild(el_td1);
						var el_td2 = document.createElement("td");
						el_td2.setAttribute("width","95%");
						el_td2.innerHTML = xval;
						el_tr.appendChild(el_td2);
					}
					el_tbody.appendChild(el_tr);		
				}
				root.appendChild(el_tbody);	
//			var controller = dojo.widget.createWidget("TreeBasicControllerV3");
//
//			var treeNodes;
//			
//			if (showTopLevel) {
//				treeNodes = [
//					{
//						title: groupName ,
//						expandLevel: (isExpanded)?1:0,
//						children: subNodes
//					}
//				]
//			} else {
//				treeNodes = subNodes;			
//			}
//
//
//			var tree = dojo.widget.createWidget("TreeV3", {listeners: [controller.widgetId]});
//
//			tree.setChildren(treeNodes);
//
//			root.appendChild(tree.domNode);	

		},
		
		error: function (err) {
				console.error(err);
				var ul = document.createElement("ul");
				ul.style.listStyleType  = "none";
				root.appendChild(ul);
				for (var node in subNodes) {					
					if (subNodes[node] && subNodes[node].title) {
						var li = document.createElement("li");
						ul.appendChild(li);
						li.innerHTML = subNodes[node].title;
					}
				}		
//			var controller = dojo.widget.createWidget("TreeBasicControllerV3");
//
//			var treeNodes = [
//				{
//					title: groupName ,
//					expandLevel: 1,
//					children: subNodes
//				}
//			]
//
//
//			var tree = dojo.widget.createWidget("TreeV3", {listeners: [controller.widgetId]});
//
//			tree.setChildren(treeNodes);
//
//			root.appendChild(tree.domNode);	
			
		}
	});






}

function _qp_getXMLDocFromString(stext) {
	var doc;

	// code for IE
	if (window.ActiveXObject)
	{
		doc=new ActiveXObject("Microsoft.XMLDOM");
		doc.async="false";
		doc.loadXML(stext);
	}
	// code for Mozilla, Firefox, Opera, etc.
	else
	{
		var parser=new DOMParser();
		doc=parser.parseFromString(stext,"text/xml");
	}

	return doc;
}

function _qp_getNodeValue(node) {
	try {
		return node.childNodes[0].nodeValue;
	} catch (e) {
		return node.textContent;
	}

}
/* END
 * NEW CODE TO SHOW MEMBERS OF A GROUP
 */
/* ***************************************************************** */
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2008, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/* ***************************************************************** */



URL = {}
URL.utils = {

	expParms : ["&ExpandView","&CollapseView","&Expand=","&Collapse="],
	EXPANDED : "0",
	COLLAPSED : "1",
	NEXPANDED : "2",
	NCOLLAPSED : "3",

	getExpandState: function() {
		// Set vars indicating whether folder contents are expanded or collapsed,
		// and at which document number, if any.
		// Return URL stripped expand/collapse param
		var bU=(typeof(h_FolderNavBaseURL)=="undefined" ? location.href : h_FolderNavBaseURL);
		var state=this.EXPANDED;
		var j = -1, docNo = -1;
		
		// Get which parm if any, and parm's length
		for (var i=0; i<this.expParms.length; i++) {
			if ((j=bU.indexOf(this.expParms[i])) != -1) {
				state=i.toString();
				break;
			}
		}
		
		if ((state==this.NEXPANDED || state==this.NCOLLAPSED) && j>0) {
			// get doc# arg
			docNo=bU.substring(j+this.expParms[state].length);
		}
		
		return {"state":state, "docNo":docNo};
	},

	makeExpandParm: function(state,docNo) {
		switch (state) {
		case this.NEXPANDED:
		case this.NCOLLAPSED:
		//dmh 06/06,spr TMAI8RVACM
		//if (docNo >= 1)
		if(docNo && docNo.substring(0,1)>=1)
			return this.expParms[state]+docNo;
			break;
		case this.COLLAPSED:
			return this.expParms[state];
			break;
		case this.NEXPANDED:
		default:
			return "";
		}
	},

	getViewUrl: function() {
		// actual view url w/o params
		var bU=(typeof(h_FolderNavBaseURL)=="undefined" ? location.href : h_FolderNavBaseURL);
		if ((i=bU.indexOf(".nsf")) > 0) {

			bU=bU.substring(0,i+4);
			var v="h_Index";

			if (typeof(h_FolderStorage) != "undefined")
				v=h_FolderStorage;
			else if (typeof(currentFolderStorage) != "undefined")
				v=currentFolderStorage;
			else if (typeof(defaultFolder) != "undefined")
				v=defaultFolder;
			else if (typeof(h_SystemName) != "undefined")
				v=h_SystemName;

			return bU+"/"+v;
		}
		return bU;
	},

	getProxyUrl: function() {
		// folder proxy doc url w/ ?OpenDocument
		var bU=(typeof(h_FolderNavBaseURL)=="undefined" ? location.href : h_FolderNavBaseURL);
		if ((i=bU.indexOf("?OpenDocument")) > 0) {
			return bU.substring(0,i+13);
		}
		return bU;
	},

	getNextStart: function() {
		// get Start value from "next page" URL
		var n=1;
		var i=-1;
		if (typeof(h_NextPageURL) != "undefined" && (i=h_NextPageURL.indexOf("&Start=")) > 0) {
			h_NextPageURL+="&";
			n=(h_NextPageURL.split("&Start=")[1]).split("&")[0];
		}
		return n;
	},
	
	getPreviousStart: function() {
		// get Start value from "previous page" URL
		var n=1;
		var i=-1;
		if (typeof(h_PreviousPageURL) != "undefined" && (i=h_PreviousPageURL.indexOf("&Start=")) > 0) {
			h_PreviousPageURL+="&";
			n=(h_PreviousPageURL.split("&Start=")[1]).split("&")[0];
		}
		return n;
	},	

	getSortParm: function() {
		// get Start value from "next page" URL
		var bU=(typeof(h_FolderNavBaseURL)=="undefined" ? location.href : h_FolderNavBaseURL);
		var i=-1;
		var col=-1;
		var ord=-1;
		if ((i=bU.indexOf("&ResortAscending=")) > 0) {
			col=parseInt(bU.substring(i+17));
			ord=0;
		}
		else if ((i=bU.indexOf("&ResortDescending=")) > 0) {
			col=parseInt(bU.substring(i+18));
			ord=1;
		}
		else {
			// no sort parm in URL
			return null;
		}
		return {"col":col,"ord":ord};
	},

	makeSortParm: function(col,ord) {
		if (col>=0 && ord>=0) {
			return "&Resort" + (ord==0 ? "A" : "De") + "scending=" + col;
		}
		else return "";
	}
}


// --------------------------------------------------------------------------------
//
// FOLDER MANAGEMENT
//
FM = {
	nonDocF: new Array("h_TaskList", "h_Members", "h_Calendar", "h_Tailor"),

	roomHasDocFolders: function() {
		for (var i=0; i < G_aToc.length; i++) {
			if (G_aToc[i].item.type=="1" && this.nonDocF.indexOf(G_aToc[i].item.SystemName) == -1) {
				return true;
			}
		}
		return false;
	}
}

FM.view = {

	// view object: "MM", etc.
	fvObj: "",
	previousStart: "",
	nextStart: "",
	
	absStart: "",
	absEnd: "",
	absCount: "",
	
	docCount: "",
	aIppVals: [10,20,50,100],

	prefs: {"ipp":"", "start":"", "sortCol":"", "sortOrd":"", "expState":"", "expDocNo":"", "view":""},
	prefsCookieName: "",

	VIEW_LIST : "0",
	VIEW_SUMMARY : "1",
	maxDocumentsToDisplayInAllView : 200,

	nRefreshes: 0,

	init: function(fvO) {

		this.previousStart=URL.utils.getPreviousStart();
		this.nextStart=URL.utils.getNextStart();
		
		this.docCount=(typeof(h_FolderDocCount)=="undefined" ? 100000 : h_FolderDocCount);

		// Get preferences from cookie or defaults
		this.getPrefs();

		// Items-per-page buttons
		if (dojo.byId("itemsPerPage")) {
			this.refreshIpp();
		}

		// Paging (f|p|n|l) buttons:
  		if (dojo.byId("pgButtons")) {
			this.refreshPgBtns();
 		}

		dojo.addOnLoad(function(){
			//init the locale stuff
			QuickrLocaleUtil.loadStringFiles("common", "/qphtml/skins/common", "QuickrCommonStrings");
		});

		this.nRefreshes=0;
	},

	setFVObj: function(fvO) {
		this.fvObj=fvO;
	},

	/* --- PREFERENCES --- */

	getPrefs: function() {
		var szPrefs=QuickrCookieUtil.getCookie("prefs_"+haikuName+"_"+h_PageUnid);
		if (szPrefs && typeof(Quickr81SupportUtil) != "undefined") {
			// folder has a prefs cookie - get prefs from it
			var p=eval(unescape('(' + szPrefs + ')')); 
			this.prefs=p;
		}
		else {
			// no cookie - get prefs from URL or use defaults
			this.prefs.ipp=((typeof(h_FolderCount)=="undefined" ? 20 : h_FolderCount));
			this.prefs.start=((typeof(h_FolderStart)=="undefined" ? 1 : h_FolderStart));
			var exp=URL.utils.getExpandState();
			this.prefs.expState=exp.state;
			this.prefs.expDocNo=exp.docNo;
			var sort=URL.utils.getSortParm();
			if (sort) {
				this.prefs.sortCol=sort.col;
				this.prefs.sortOrd=sort.ord;
			} else {
				this.prefs.sortCol = this.prefs.sortOrd = -1;
			}
			this.prefs.view=(h_SetReadScene=="h_AbstractsFolderRead" ? this.VIEW_SUMMARY : this.VIEW_LIST);
		}
	},

	setPrefs: function() {
		if (G_bStoreFolderCookie && typeof(Quickr81SupportUtil) != "undefined") {
			var dt=new Date(QuickrCookieUtil.getExpireDate("365"));
			var szPrefs = escape('{'
			+ '"ipp":"' + this.prefs.ipp + '",'
			+ '"start":"' + this.prefs.start + '",'
			+ '"sortCol":"' + this.prefs.sortCol + '",'
			+ '"sortOrd":"' + this.prefs.sortOrd + '",'
			+ '"expState":"' + this.prefs.expState + '",'
			+ '"expDocNo":"' + this.prefs.expDocNo + '",'
			+ '"view":"' + this.prefs.view + '"'
			+ '}');
			QuickrCookieUtil.setCookie("prefs_"+haikuName+"_"+h_PageUnid, szPrefs, dt, "/"+G_haikuBaseUrl+"/"+haikuName);
		}
	},

	setIPP: function(n) {
		if (n > 0) {
			this.prefs.ipp=n;
			this.setPrefs();
		}
	},
	getIPP: function() {return this.prefs.ipp;},

	setStart: function(n) {
		if (n != "") {
			this.prefs.start=n;
			this.setPrefs();
		}
	},
	getStart: function() {return this.prefs.start},

	setView: function(n) {
		this.prefs.view=n;
		this.setPrefs();
	},
	getView: function() {return this.prefs.view;},

	setExpand: function(state,docNo) {
		this.prefs.expState=state;
		this.prefs.expDocNo=docNo;
		this.setPrefs();
		this.refreshShowHideResponses();
	},
	getExpand: function() {
		if (this.fvObj=="FV.summary") {
			return ({"state":URL.utils.COLLAPSED, "docNo":-1});
		} else {
			return ({"state":this.prefs.expState, "docNo":this.prefs.expDocNo});
		}
	},

	setSort: function(col,ord) {
		if (col>=0 && ord>=0) {
			this.prefs.sortCol=col;
			this.prefs.sortOrd=ord;
			this.setPrefs();
		}
	},
	getSort: function() {return {"col":this.prefs.sortCol, "ord":this.prefs.sortOrd};},


	/* --- --- */

	makeURL: function(start,count,sortCol,sortOrd,expState,expDocNo,bUpdateView,bForceProxy) {

		var szS = start || this.getStart(); 
		var szC = count || this.getIPP(); 
 		var sort = this.getSort();
 		var sCol = sortCol || (sort ? sort.col : -1);
 		var sOrd = sortOrd || (sort ? sort.ord : -1);
 		var expand = this.getExpand();
 		var eState = expState || (expand ? expand.state : URL.utils.EXPANDED);
 		var eDocNo = expDocNo || (expand ? expand.docNo : -1);
		var bProxy = bForceProxy || false;
		
		if (szS == "lastpage") {
			if(typeof(this.fvObj) != "undefined" && this.fvObj.toLowerCase()=="mm") {
				var i_fullPages = parseInt(this.absCount / szC);
				var i_remainItems = this.absCount % szC;
				var i_startAt = 0;
				if (i_remainItems == 0) {
					i_startAt = this.absCount - szC + 1;
				} else {
					i_startAt = this.absCount - i_remainItems + 1;
				}					
				szS = "&Start=" + i_startAt;
			} else {
				szS = "&StartAtLastPage";
			}
		} else {
			szS = "&Start=" + szS;
		}

		if (bProxy || typeof(Quickr81SupportUtil)=="undefined" || typeof(eval(FM.view.fvObj+".view.refresh"))=="undefined") {
			return (URL.utils.getProxyUrl() + szS + "&Count="+szC + URL.utils.makeSortParm(sCol,sOrd) + URL.utils.makeExpandParm(eState,eDocNo));
		} else {
			return (eval(this.fvObj+'.view.getBaseURL(bUpdateView)')
					  + szS + "&Count="+szC
					  + URL.utils.makeSortParm(sCol,sOrd)
					  + URL.utils.makeExpandParm(eState,eDocNo));
		}
	},

	disableViewBtns: function() {
		dojo.byId("showListDetails").style.display="none";
	},

	initViewBtns: function() {
		var btnS=dojo.byId("summaryBtn");
		var btnD=dojo.byId("detailsBtn");
		if (btnS && btnD) {
			btnS.href="javascript:void(0);";
			btnD.href="javascript:void(0);";
			// hilite correct button, set cookie if not set
			if (this.getView()==this.VIEW_SUMMARY) { 
				btnD.className="lotusSprite lotusView lotusSummaryOff";
				btnS.className="lotusSprite lotusView lotusDetailsOn";
				btnS.onclick=function() {return false;};
				btnD.onclick=function() {
					FM.view.setView(FM.view.VIEW_LIST);
					FV.list.init();
					FM.view.reqData();
				};
			} else {
				btnD.className="lotusSprite lotusView lotusSummaryOn";
				btnS.className="lotusSprite lotusView lotusDetailsOff";
				btnS.onclick=function() {
					FM.view.setView(FM.view.VIEW_SUMMARY);
					FV.summary.init();
					FM.view.reqData();
				};
				btnD.onclick=function() {return false;};
			}
		}
		dojo.byId("showListDetails").style.display="block";
	},

	toggleBtn: function(id,bShow,action) {
		var btnA=dojo.byId(id+"_a");
		var btnS=dojo.byId(id+"_s");
		if (bShow) {
			btnA.style.display="inline";
			btnS.style.display="none";
			if (typeof(action) != "undefined") {
				btnA.onclick=function(){eval(action);return false;};
			}
		}
		else {
			btnA.style.display="none";
			btnS.style.display="inline";
		}
	},

	refreshIpp: function(n) {
		// Refresh items-per-page buttons
		if (typeof(n) != "undefined") {
			this.setIPP(n);
		}

		if (typeof(h_FolderDocCount)=="undefined" || typeof(FM.view.maxDocumentsToDisplayInAllView)=="undefined" || h_FolderDocCount <= FM.view.maxDocumentsToDisplayInAllView) {
			this.aIppVals.push(100000);
		}

		for (var i=0; i<this.aIppVals.length; i++) {
			this.toggleBtn("ipp_"+this.aIppVals[i], (this.aIppVals[i] != this.getIPP()));
		}
		
		this.refreshPgBtns();
	},

	refreshPgBtns: function(n) {
		// Refresh paging (f|p|n|l) buttons
		if (typeof(n) != "undefined") {
			this.setStart(n);
		}

		if (this.getStart()=="1" || this.docCount==0) {
			this.toggleBtn("pgBtn_f",false);
			this.toggleBtn("pgBtn_p",false);
		}
		else {
			this.toggleBtn("pgBtn_f",true,"javascript:FM.view.onPgBtn('1');");
			this.toggleBtn("pgBtn_p",true,"javascript:FM.view.onPgBtn('"+this.previousStart+"');");
		}

		if (this.docCount==0 || this.getStart()=="lastpage" || this.absEnd == this.absCount) {
			this.toggleBtn("pgBtn_n",false);
			this.toggleBtn("pgBtn_l",false);
		} else {
			this.toggleBtn("pgBtn_n",true,"javascript:FM.view.onPgBtn('"+this.nextStart+"');");
			this.toggleBtn("pgBtn_l",true,"javascript:FM.view.onPgBtn('lastpage');");
		}
	},

	refreshABofC: function(a,c,nShowing) {
		// update "showing items a-b of c"
		var fsi=dojo.byId("FolderShowingItems");
		if (this.fvObj=="FV.tasks") {
			fsi.style.display="none";
		} else {
			if (fsi) {
				var b=Math.max(0, a+nShowing-1);
				var fsiText = QuickrLocaleUtil.getStringResource("QP_STRINGS.MSG_SHOWING_ITEMS").replace("{0}",a).replace("{1}",b).replace("{2}",c);
				fsi.innerHTML = fsiText;
				fsi.style.visibility="visible";
			}
		}
	},

	refreshShowHideResponses: function() {
		// show/hide all responses link:
		var shr=dojo.byId("shr_div");
  		if (shr) {
			var a=dojo.byId("shr_a");
			var exp=this.getExpand();
			if (exp.state==URL.utils.COLLAPSED || exp.state==URL.utils.NCOLLAPSED) {
				a.innerHTML=QuickrLocaleUtil.getStringResource("FOLDER.SHOWALL");
				a.title=QuickrLocaleUtil.getStringResource("FOLDER.SHOWALL");
				a.onclick=function(){FM.view.onExpand(URL.utils.EXPANDED,"-1");return false;};
			} else {
				a.innerHTML=QuickrLocaleUtil.getStringResource("FOLDER.HIDEALL");
				a.title=QuickrLocaleUtil.getStringResource("FOLDER.HIDEALL");
				a.onclick=function(){FM.view.onExpand(URL.utils.COLLAPSED,"-1");return false;};
			}
			shr.style.display="block";
		}
	},

	onIpp: function(n) {
	
		this.setStart(1); //reset to the first page when setting the ipp

		if (typeof(Quickr81SupportUtil)=="undefined" || typeof(eval(FM.view.fvObj+".view.refresh"))=="undefined") {
			// view is not ajax-enabled; add params to url and reload the page:
			var url=this.makeURL(this.getStart(),n);
			this.setIPP(n);
			this.refreshPgBtns()
			location.href=url;
			return;
		}

		var now = new Date();
		var mType=returnSubType(eval(FM.view.fvObj+".view.mimeType"));
		try {
			FM.view.disableViewBtns();
			dojo.xhrGet ({
				url: this.makeURL(this.curStart,n),
				handleAs: (typeof(mType)=="undefined" ? "xml" : mType),
				load: function(data) {eval(FM.view.fvObj+'.view.refresh(data)');FM.view.refreshIpp(n);}
			});
			FM.view.showPgLoading(true);
		}
		catch(e) {
		}
	},

	onPgBtn: function(n) {

		if (typeof(Quickr81SupportUtil)=="undefined" || typeof(eval(FM.view.fvObj+".view.refresh"))=="undefined") {
			// view is not ajax-enabled; add params to url and reload the page:
			var url=this.makeURL(n,this.getIPP());
			this.refreshPgBtns(n);
			location.href=url;
			return;
		}

		var now = new Date();
		var mType=returnSubType(eval(FM.view.fvObj+".view.mimeType"));
		try {
			FM.view.disableViewBtns();
			dojo.xhrGet ({
				url: this.makeURL(n,this.getIPP()) + '&timestamp=' + now.getTime(),
				handleAs: (typeof(mType)=="undefined" ? "xml" : mType),
				load: function(data) {eval(FM.view.fvObj+'.view.refresh(data)');FM.view.refreshPgBtns(n);}
			});
			FM.view.showPgLoading(true);
		}
		catch(e) {
		}
	},

	onExpand: function(state,docNum) {

		var url=this.makeURL(this.getStart(),this.getIPP(),null,null,state,docNum);

		if (typeof(Quickr81SupportUtil)=="undefined" || typeof(eval(FM.view.fvObj+".view.refresh"))=="undefined") {
			// view is not ajax-enabled; add params to url and reload the page:
			this.setExpand(state,docNum);
			location.href=url;
			return;
		}

		var now = new Date();
		var mType=returnSubType(eval(FM.view.fvObj+".view.mimeType"));
		try {
			FM.view.disableViewBtns();
			
			dojo.xhrGet ({
				url: url + '&timestamp=' + now.getTime(),
				handleAs: (typeof(mType)=="undefined" ? "xml" : mType),
				load: function (data) {FM.view.setExpand(state,docNum);eval(FM.view.fvObj+'.view.refresh(data)');FM.view.refreshPgBtns();}
			});
			
			FM.view.showPgLoading(true);
		}
		catch(e) {
		}
	},

	onSortBtn: function(btn) {

		if (btn.id.indexOf("sortBtn_")==0) {
			var bAsc=(typeof(btn.className)=="undefined" || btn.className=="" ? true : !(btn.className.indexOf("Ascending")>0));
			var sCol=parseInt(btn.id.substring(8));
			var sOrd=(bAsc?"0":"1");
		}

		if (typeof(Quickr81SupportUtil)=="undefined" || typeof(eval(FM.view.fvObj+".view.refresh"))=="undefined") {
			// view is not ajax-enabled; add params to url and reload the page:
			var url=FM.view.makeURL(FM.view.getStart(),FM.view.getIPP(),sCol,sOrd);
			location.href=url;
			return;
		}

		var now = new Date();
		var mType=returnSubType(eval(FM.view.fvObj+".view.mimeType"));
		try {
			FM.view.disableViewBtns();
			dojo.xhrGet ({
				url: FM.view.makeURL(1,FM.view.getIPP(),sCol,sOrd) + '&timestamp=' + now.getTime(),
				handleAs: (typeof(mType)=="undefined" ? "xml" : mType),
				load: function(data) {FM.view.setSort(sCol,sOrd);eval(FM.view.fvObj+'.view.refresh(data)');FM.view.refreshPgBtns(1);}
			});
			FM.view.showPgLoading(true);
		}
		catch(e) {
		}
	},

	displayView: function() {
		// request proper view data
		if (this.getView()==this.VIEW_SUMMARY) { 
			FV.summary.init();
			FV.summary.view.reqData();
		} else {
			FV.list.init();
			FM.view.reqData(false); // load the initial view w/o updating view (already done)
		}
	},

	reqData: function(bUpdView) {

		if (typeof(Quickr81SupportUtil)=="undefined" || typeof(eval(FM.view.fvObj+".view.refresh"))=="undefined") {
			// view is not ajax-enabled; add params to url and reload the page:
			var url=this.makeURL(this.getStart(),this.getIPP(),null,null,null,null,bUpdView);
			location.href=url;
			return;
		}

		var now = new Date();
		var mType=returnSubType(eval(FM.view.fvObj+".view.mimeType"));

		try {
			FM.view.disableViewBtns();
			dojo.xhrGet ({
				url: this.makeURL(this.getStart(),this.getIPP(),null,null,null,null,bUpdView) + '&timestamp=' + now.getTime(),
				handleAs: (typeof(mType)=="undefined" ? "xml" : mType),
				load: function(response, ioArgs) {eval(FM.view.fvObj+'.view.refresh(response)');FM.view.refreshPgBtns();}
			}); 
			
			FM.view.showPgLoading(true);
		}
		catch(e) {
		}
	},

	print: function() {
		var url=this.makeURL(this.getStart(),this.getIPP(),null,null,null,null,true,true);
		gotoPrint(url);
	},

	showPgLoading: function(bLoading,msg) {
		var pc=dojo.byId("pageContent");
		var pcl=dojo.byId("PageContentLoading");
		if (pc && pcl) {
			if (bLoading) {
				pcl.style.display="block";
				pc.style.display="none";
				FM.view.setPgLoadingMsg(msg);
			} else {
				pcl.style.display="none";
				pc.style.display="block";
			}
		}
	},

	setPgLoadingMsg: function(msg) {
		// FIX ME: translate
		var loading_str = QuickrLocaleUtil.getStringResource("QP_FOLDER_MGMT.LOADING");
		var lMsg=msg || loading_str;
		var plm=dojo.byId("PageContentLoadingMsg");
		if (plm) {
			plm.innerHTML=lMsg;
		}
	},

	attachmentIconAttributes: function(name) {
		var imgSrc = "default";
		var imgAlt = "";
		
		if (typeof(name) != "undefined" && name != null) {
			if (name.indexOf(".") > -1) {
				var suffix = name.substring(name.lastIndexOf(".")+1).toLowerCase();
				
				switch (suffix) {

					case "doc":
					case "docx":
					case "odt":
					case "sxw":
					case "lwp":
					case "dot":
					case "ott":
					case "stw":
					case "mwp":
						imgSrc = "wordprocessing";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.WP_DOC");
						break;
					
					case "xls":
					case "xlsx":
					case "ods":
					case "sxc":
					case "123":
					case "csv":
					case "xlt":
					case "ots":
					case "stc":
					case "12m":
						imgSrc = "data";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.SPREADSHEET");
						break;
					
					case "ppt":
					case "pptx":
					case "prz":
					case "odp":
					case "sxi":
					case "prz":
					case "pot":
					case "otp":
					case "mas":
					case "smc":
					case "sti":
						imgSrc = "presentation";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.PRESENTATION");
						break;
						
					case "pdf":
						imgSrc = "pdf";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.PDF");
						break;
						
					case "txt":
					case "rtf":
					case "log":
					case "csv":
						imgSrc = "text";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.TEXT_DOC");
						break;
						
					case "wav":
					case "mp3":
					case "wma":
						imgSrc = "audio";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.AUDIO");
						break
						
					case "wmv":
					case "mpg":
					case "avi":
					case "mpeg":
					case "mp4":
						imgSrc = "video";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.VIDEO");
						break;
						
					case "zip":
					case "gzip":
					case "rar":
					case "gz":
					case "tar":
					case "arc":
						imgSrc = "compressed";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.ARCHIVE");
						break;
						
					case "gif":
					case "jpg":
					case "jpeg":
					case "bmp":
					case "png":
						imgSrc = "image";
						imgAlt = QuickrLocaleUtil.getStringResource("ICON_ALT.IMAGE");
						break;

				
				}
			
			}	
		
		}
		return [imgSrc,imgAlt];
	},

	getIconImg: function( type, form, attName, bShowLargeIcon ) {
	
		if (typeof(bShowLargeIcon) == "undefined") bShowLargeIcon = false;
		
		var img=document.createElement("img");
		img.setAttribute("border","0");
		img.setAttribute("align","middle");
		img.setAttribute("valign","middle");
		
		var newSrc = GetDocTypeIconImgSrc(type,form,"",((bShowLargeIcon)?"LG":"SM"));
		var imgAlt = GetDocTypeIconImgAlt(type,form,"");
		
		
		//these types might need a different icon
		var aCustomTypes = [ "docupload", "docword", "docexcel", "docppoint", "docplain" ];
		
		var newSrcName = newSrc.substring(newSrc.lastIndexOf("/")+1);
		
		var bCustomType = false;

		for (var i = 0; i < aCustomTypes.length; i++) {
			if (newSrcName.indexOf(aCustomTypes[i]) == 0) {
				bCustomType = true;
				break;
			}
		}
		

		if (bCustomType) {
		
			if (attName != "" && form == G_FormIDs.UploadPageFormUNID) {

				var aFiles = new Array();		

				//first, let's get the uploaded attachments, not the conversions...
				//SPR: #RTIN7NRHLY
				var aN = attName.split('/');  
				for (var i = 0; i < aN.length; i++) {
					if (!QuickrGeneralUtil.isInternalFileName(aN[i],form)) {
						aFiles[aFiles.length] = aN[i];
					}
				}

				//now let's loop through the uploaded files and inspect the types...
				var suffix = null;


				for (var i = 0; i < aFiles.length; i++) {
					var tmpSuffix = "";
					if (aFiles[i].lastIndexOf(".") > -1) {
						tmpSuffix = aFiles[i].substring(aFiles[i].lastIndexOf(".")+1).toLowerCase();
					}

					if (suffix == null && tmpSuffix.length > 0) {
						suffix = tmpSuffix;
					} else if (suffix != tmpSuffix) {  //there is more than one file with a different extension...
						suffix = null;
						break;
					}
				}

				if (suffix != null) {
					var attrs = this.attachmentIconAttributes("test." + suffix);
					var imgSrc = attrs[0] + "_" + ((bShowLargeIcon)?"80":"16") + ".gif";
					if (imgSrc.indexOf("default") != 0) {
						newSrc="/qphtml/skins/quickrentry/images/"+imgSrc;
						imgAlt = attrs[1];
					}
				}
			}
		}
		
		img.src = newSrc;
		img.alt = img.title = imgAlt;
		
		return img;
	},

	reload: function() {
		if (typeof(Quickr81SupportUtil) != "undefined") {
			// use Ajax to refresh content
			FM.view.reqData();
		}
		else {
			location.reload();
		}
	},

	rmUnids: null,
	rmNames: null,

	removeChecked: function() {
		//BB - SPR #RTIN7RTH34
		if ( DoesSelectionHaveResponses(theForm.h_SelectedEntry) ) {
			alert( QuickrLocaleUtil.getStringResource("DOC.CANT") );
			return;
		}
		
		this.rmUnids=FM.check.getSelections(theForm.h_SelectedEntry);
		//SPR:#THES7NXGGZ 
		if (this.rmUnids.length>0 ) {
			//BB - SPR #RTIN7RTH34
			if(confirm(QuickrLocaleUtil.getStringResource("DOC.DELETETHIS")))
			{
				this.rmNames=FM.check.getSelectionTitles(theForm.h_SelectedEntry);
				FM.view.showPgLoading(true,QuickrLocaleUtil.getStringResource("FOLDER.DELETINGMANY"));
				this.rmOneChecked();
			}
		}
		else {
			alert(QuickrLocaleUtil.getStringResource("FOLDER.REMOVE"));
		}
	},

	rmOneChecked: function() {
			if (FM.view.rmUnids.length>0) {
				var dUnid=FM.view.rmUnids[FM.view.rmUnids.length-1];
				var dName=FM.view.rmNames[FM.view.rmNames.length-1];
	
				FM.view.setPgLoadingMsg(QuickrLocaleUtil.getStringResource("FOLDER.DELETING").replace("{0}",dName));
	
				FM.view.rmUnids.length--;
				if (FM.view.rmNames.length>0) {
					FM.view.rmNames.length--;
				}
	
				DM.service.submit(
					(typeof(h_FolderUNID)=="undefined" ? "" : h_FolderUNID),
					dUnid,
					"deleteDocument",
					null,
					//return function to compile any errors if necessary
					function() {
						var data = arguments[1];
	
						if (typeof data == "object") {
							FM.view._getFailedMessagesFromData(data, dName);
						}
	
						FM.view.rmOneChecked();
					},
					QPAjax_Error
				);
			}
			else {
			
				if (FM.view._failedMessages.length > 0) {
					//we've got errors, join them and display in one message
					
					//limit to 10 errors for screen size purposes...
					if (FM.view._failedMessages.length > 10) {
						FM.view._failedMessages.length = 10;
						FM.view._failedMessages.push( QuickrLocaleUtil.getStringResource("MULTISELECT.MORE") );
					}
					
					var errmsg = QuickrLocaleUtil.getStringResource("MULTISELECT.ERRORCONTAINER");
					errmsg = errmsg.replace("{0}", FM.view._failedMessages.join("\n\n") );
					
					alert(errmsg);
					
					//reset the message array...
					FM.view._failedMessages.length = 0;
				}
				
				// we are done
				FM.view.reload();
			}
		},
		
		//holds the error messages
		_failedMessages: new Array(),
		
		
		_getFailedMessagesFromData: function(data, dName) {
			//traverse through the childNodes of the xml document to find the actual error message...
			for (var ii = 0; ii < data.childNodes.length; ii++) {
				if (data.childNodes[ii].nodeName == "p283:error") {
					for (var jj = 0; jj < data.childNodes[ii].attributes.length; jj++) {
						if (data.childNodes[ii].attributes[jj].name == "message") {
							var newmsg = QuickrLocaleUtil.getStringResource("MULTISELECT.REMOVE.ERRORITEM");
							newmsg = newmsg.replace("{0}", dName);
							newmsg = newmsg.replace("{1}", data.childNodes[ii].attributes[jj].firstChild.nodeValue);
							FM.view._failedMessages.push(newmsg);
							break;
						}
					}
				}
				
				//recurse...
				if (data.childNodes[ii].childNodes.length > 0) {
					FM.view._getFailedMessagesFromData(data.childNodes[ii], dName);
				}
	
			}
		
	},

	emptyMsg: function() {
		if (h_FolderStorage=="h_Index") {
			return QuickrLocaleUtil.getStringResource("FOLDER.EMPTYINDEX");
		} else {
			return QuickrLocaleUtil.getStringResource("FOLDER.EMPTYFOLDER")
			+ (currentUserAccess > 2 ? " "+QuickrLocaleUtil.getStringResource("FOLDER.YOUCANCREATE") : "");
		}
	}

} // FM.view



//
// CHECKBOX SUPPORT
//
FM.check = {

	selectAll: function(el) {
		var bC = el.checked;

		if (typeof(theForm.h_SelectedEntry) != "undefined") { 
			if (!isNaN (theForm.h_SelectedEntry.length)) {		
				for (var i = 0; i < theForm.h_SelectedEntry.length; i++) {
					theForm.h_SelectedEntry[i].checked = bC;
				}
			} 
			else {
				theForm.h_SelectedEntry.checked = bC;
			}
		}
	},

	select: function(el) {
		// Uncheck the "select all" box if checked
		if (currentUserAccess >= 6) {
			theForm.allDocsSelected.checked = false;
		}
	},

	getSelections: function(inp) { 
		var aCB = new Array( );
		if (typeof(inp) != "undefined") {
			  
			if (!isNaN(inp.length)) {
				for (var i = 0; i < inp.length; i++) {
					if (inp[i].checked == true) {
						aCB[aCB.length] = inp[i].value;
					}
				}
			}
			else if (inp.checked == true) {
				aCB[aCB.length] = inp.value;
			}
		}
		return aCB;
	},

	getSelectionTitles: function(inp) { 
		var aCB = new Array( );
		if (typeof(inp) != "undefined") {
			  
			if (!isNaN(inp.length)) {
				for (var i = 0; i < inp.length; i++) {
					if (inp[i].checked == true) {
						aCB[aCB.length] = inp[i].title;
					}
				}
			}
			else if (inp.checked == true) {
				aCB[aCB.length] = inp.title;
			}
		}
		return aCB;
	},

	enable: function(inp,yn) { 
		if (typeof(inp) != "undefined") {
			if (!isNaN(inp.length)) {
				for (var i = 0; i < inp.length; i++) {
					inp[i].disabled=(!yn);
				}
			}
			else {
				inp.disabled=(!yn);
			}
		}
	},

	checkByValue: function(inp,v) { 
		if (typeof(inp) != "undefined") {
			if (!isNaN(inp.length)) {
				for (var i = 0; i < inp.length; i++) {
					inp[i].checked=(inp[i].value==v);
				}
			}
			else {
				inp.checked=(inp.value==v);
			}
		}
	},

	makeInput: function(name) {
		var ch;
		if (document.all) {
			// IE: name dropped unless created like this!
			ch=document.createElement("<input name='"+name+"'/>");
		}
		else {
			ch=document.createElement("input");
			ch.setAttribute("name",name);
		}
		return ch;

	},

	makeDisabled: function() {
		var ch=FM.check.makeInput("h_Disabled");
		ch.setAttribute("type","checkbox");
		ch.setAttribute("disabled",true); // ???
		return ch;
	},
	
	trim: function(data){
		return data.replace(/^\s+|\s+$/g,"");
	},
	
	checkAcl: function(acls, user) {		
		for (var i=0; i<acls.length; i++) {
			if (FM.check.trim(acls[i]).toLowerCase() == user.toLowerCase()) {
				return true;
			}
		}
		return false;
	},
	
	makeSelect: function(type,name,unid,authors) {
		var ch;
		var status = false;
		if ((typeof(authors) == "undefined") || (typeof(haiku.canonicalName) == "undefined") || (authors == "") || (haiku.canonicalName == "")) {
			if (currentUserAccess >= 4) {
				status = true;
			}		
		} else {			
			var acls = authors.split(',');
			var user_level = currentUserAccess;
			var user_name = haiku.canonicalName;
			if (user_level > 2) {
				if (user_level >= 4) {
					status = true;
				} else if (user_level == 3) {
					status = FM.check.checkAcl(acls, "[h_Members]");
				}
				if (!status) {
					status = FM.check.checkAcl(acls, user_name);
					if ((!status) && (groupsForUser != "") && (typeof(groupsForUser) != "undefined")){
						for (var j=0; j< groupsForUser.length; j++) {
							status = FM.check.checkAcl(acls, groupsForUser[j]);
							if (status) break;
						}
					}
				}				
			}
		}
		if ( !status || type=="1") {
			ch=FM.check.makeDisabled();
		} else {
			ch=FM.check.makeInput("h_SelectedEntry");
			ch.setAttribute("type","checkbox");
			ch.setAttribute("value",unid);
			ch.setAttribute("title",QuickrGeneralUtil.decodeEntities(name));
		}
		return ch;
	},

	makeSelectAll: function() {
		var ch;
		if (currentUserAccess<6) {
			ch=FM.check.makeDisabled();
			//SPR #JROE8A8NLR
			//ch.setAttribute("type","checkbox");
			ch.id="allDocsSelected";
			ch.setAttribute("title",QuickrLocaleUtil.getStringResource("LABEL.SELECTALL"));
		}
		else {
			ch=FM.check.makeInput("allDocsSelected");
			ch.setAttribute("type","checkbox");
			ch.id="allDocsSelected";
			ch.setAttribute("title",QuickrLocaleUtil.getStringResource("LABEL.SELECTALL"));
		}
		return ch;
	}

} // FM.check


// =====================================================


FV = {}


FV.responses = {

	aChOnLev : new Array(0,0),	  // # of Doc children on level [i]

	// Indent & Expand image tags
	indImgTag : '<img style="width:18px;height:18px;vertical-align:middle;" src="/qphtml/html/common/treenode_%s.gif"/>',
	indImgTagBg : '<style>.indImgTagBg{background-image:url(/qphtml/html/common/%RTLtreenode_grid_%g.gif);}</style><img class="indImgTagBg" style="width:18px;height:18px;vertical-align:middle;'
			+ '" src="/qphtml/html/common/treenode_%s.gif"/>',
	twImgTag : '<style>.twImgTagBg{background-image:url(/qphtml/html/common/%RTLtreenode_grid_%g.gif);}</style><a title="%t" href="javascript:FV.responses.doTheTwist(\'%n\',%b);" ><img class="twImgTagBg" style="width:18px;height:18px;vertical-align:middle;'
		+ '" alt="%l" src="/qphtml/html/common/treenode_expand_%s.gif"'
		+ ' /></a>',
	rspImgTag :'<img src="/qphtml/html/common/response%a.gif" style="padding-right:0.5em;vertical-align:middle;"/>',

	rspImg: function(bAtt) {
		return (bAtt ? this.rspImgTag.replace(/%a/,'-attach') : this.rspImgTag.replace(/%a/,''));
	},

	indImg: function(src, bg) {
		var temp =  (bg ? this.indImgTagBg.replace(/%s/,src).replace(/%g/,bg) : this.indImgTag.replace(/%s/,src));
		return ((document.body.dir=="rtl")?temp.replace(/%RTL/,'bidi/') : temp.replace(/%RTL/,'') );
	},

	twImg: function(bExp, bg, num) {
		var pm = (bExp?'plus':'minus');
		var alt = (bExp?QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND"):QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.COLLAPSE"));
		var temp =  this.twImgTag.replace(/%s/,pm).replace(/%n/,num).replace(/%b/,bExp).replace(/%g/,bg).replace(/%l/,alt).replace(/%t/,alt);
		return ((document.body.dir=="rtl")?temp.replace(/%RTL/,'bidi/') : temp.replace(/%RTL/,'') );
	},

	doTheTwist: function(docNum, bExpand) {
		FM.view.onExpand((bExpand ? URL.utils.NEXPANDED : URL.utils.NCOLLAPSED), docNum);
	},

	makeIndent: function(lev,docNo,nC,bAtt) { 
		var html = "";
		var rImg = (lev>1 ? this.rspImg(bAtt) : "");
		
		// record #children at this level
		this.aChOnLev[lev] = nC;
		
		if (lev > 1) {
			// One child down
			this.aChOnLev[lev-1]--;
			
			// write preceeding blanks
			html += this.indImg('blank');
			for (var i=2; i < lev; i++) {
					if (this.aChOnLev[i-1] > 0)
						html += this.indImg('blank', 'v');
					else
						html += this.indImg('blank');
			}
		}
		
		if (nC > 0) {
			// doc has child(ren)
			
			// Select "+" or "-" for twisty
			var bExp = false;
			var expand=FM.view.getExpand();
			switch (expand.state.toString())
			{
			case URL.utils.NEXPANDED:
				if (docNo != expand.docNo &&
					 docNo != expand.docNo.substr(0,docNo.length))
					bExp = true;
				break;
			case URL.utils.NCOLLAPSED:
				if (docNo == expand.docNo ||
					 docNo != expand.docNo.substr(0,docNo.length))
					bExp = true;
				break;
			case URL.utils.COLLAPSED:
				bExp = true;
				break;
			default:
				;
			}
			
			if (lev > 1)
				html += this.twImg(bExp, (this.aChOnLev[lev-1]>0 ? 't' : 'l'), docNo);
			else
				html += this.twImg(bExp, 'x', docNo);
		}
		else if (lev > 1) {
			// no children
			html += this.indImg('blank', (this.aChOnLev[lev-1]>0 ? 't' : 'l'));
		}
		
		html += rImg;
		return html;
	},

	SimpleResponseIndent: function(lev, nC, bAtt) { 
		var html = "";
		var rImg = "";
		
		// record #children at this level
		this.aChOnLev[lev] = nC;
		
		if (lev > 1) {
			// One child down
			this.aChOnLev[lev-1]--;
			
			// write preceeding blanks
			html += this.indImg('blank');
			for (var i=2; i < lev; i++) {
				if (this.aChOnLev[i-1] > 0)
					html += this.indImg('blank', 'v');
				else
					html += this.indImg('blank');
			}
			rImg=this.rspImg(bAtt);
		}
		
		html += this.indImg('blank', (this.aChOnLev[lev-1]>0 ? 't' : 'l'));
		
		html += rImg;
		return html;
	}
}


// ------------------------------------------------------------

FV.list = {

	init: function() {
		FV.list.view.init();
		dojo.byId("pageNavBar").style.display="block";
		FM.view.refreshShowHideResponses();
	}
}

FV.list.view = {

	baseURL: URL.utils.getProxyUrl() + "&Form=h_FolderViewJSON&charset=utf-8",
	mimeType: "text/javascript",
	// Use these when convert to use ReadViewEntries:
//   	baseURL: URL.utils.getViewUrl() + "?ReadViewEntries&PreFormat&OutputFormat=JSON",
//   	mimeType: "application/x-javascript",
	aColVal: new Array(),

	init: function() {
		FM.view.setFVObj("FV.list");
	},

	getBaseURL: function(bUpdView) {
		// update view (variables)?
		return this.baseURL + "&PreSetFields=h_UpdateView;"+(typeof(bUpdView)=="undefined" || bUpdView ? "1" : "0");;
	},

	resetColVal: function() {
		this.aColVal.length=0;
	},

	setColVal: function(col,val) {
		
		if((col=="h_Created")||(col=="h_DisplayModified")){
		if(isHijri||isHebrew){
			val = convertDateString(val);
		}}
		val = val.replace(/\r/gi,"<br/>");
		
		if (col != "") {
			this.aColVal[this.aColVal.length] = {'col': col, 'val' : val};
		}
	},

	refresh: function(data) {
		// Reset vars
		iTotNumOfDocs = 0;
		iDocArrayCount = 0;

		try
		{
			var items=data.items;

			// current view
			var fvt1 = dojo.byId("dragTable") || dojo.byId("dragDiv");

			// new view
			var fvt2=document.createElement("table");
			fvt2.setAttribute("border","0");
			fvt2.setAttribute("cellPadding","0"); 
			fvt2.setAttribute("cellSpacing","0"); 
			fvt2.className="FolderTable"; 
			fvt2.setAttribute("width","100%");
				
			if (items.length > 0) {
			
				var els = qp_getElementsByClassName("h-folderEmpty", "div", fvt1.parentNode);
				if (els.length > 0) {
					els[0].parentNode.removeChild(els[0]);
				}	
				
				// append title bar
				fvt2.appendChild(FV.list.view.makeTitleBar(h_FV_Cols));

				// append view entries
				var fvn=item=null;
				for (var i=0; i<items.length; i++)
				{
					var item=items[i].item;
					
					UpdateDocArray( iDocArrayCount++, item.Unid, item.HasParent, item.HasChildren);

					iTotNumOfDocs++;
					
					// get optional column values
					this.resetColVal();
					var colVals=item.other_columns;
					for (var j = 0; j < (colVals.length-1); j++) {
						this.setColVal(colVals[j].name, colVals[j].value);
					}
					
					fvn=FV.list.view.makeItem(
						item.Type, item.Name.replace(/\\&quot;/g,"&quot;"), item.Unid,
						GenerateQPObjURLAnchorTag(data.FolderStorage, item.Unid, item.URLpointer, item.URLNewWindow, item.Type),
						item.Form, item.HasParent, item.HasChildren, item.DocLevel, item.RevNum, item.DocNumber,
						item.Attachments,
						item.AttachLengths,
						item.IsLocked,
						item.Author,
						item.AuthorDN,
						item.LastEditorDN,
						item.Descendants,
						item.Authors
					);
					fvt2.appendChild(fvn);
				}

				// record last doc #
				//FM.view.nextStart=item.DocNumber;
			}
			else {
				// empty folder
				FM.view.nextStart=0;
				if (qp_getElementsByClassName("h-folderEmpty", "div", fvt1.parentNode).length==0) {
					var div=document.createElement("div");
					div.className="h-folderEmpty";
					div.innerHTML=FM.view.emptyMsg();
					fvt1.parentNode.appendChild(div);
				}
			}
			
			FM.view.previousStart=data.FolderPreviousStart;
			FM.view.nextStart=data.FolderNextStart;
			
			FM.view.absStart = data.FolderAbsStart;
			FM.view.absEnd = Math.max(0, data.FolderAbsStart+iTotNumOfDocs-1);
			FM.view.absCount = data.FolderDocCount;
			

			// update "showing items a-b of c"
			FM.view.refreshABofC(data.FolderAbsStart,data.FolderDocCount,iTotNumOfDocs);
			
			// replace view
			fvt1.parentNode.replaceChild(fvt2,fvt1);
			fvt2.id="dragTable";
			
			if (items.length > 0) {
				// run the context menu/person card/DND stuff
				QP_ContextMenu_attachMenus(fvt2);
				QP_DragAndDrop_createObjects("tbody", "dragTable");
			}
			
			// show new view
			FM.view.showPgLoading(false);

			// View (details/summary) buttons
			FM.view.initViewBtns();
			
			FM.view.nRefreshes++;

			if (items.length > 0 && G_ProfileServer != "") {
				if (FM.view.nRefreshes==1) {
					// 1st time - activate person cards on entire page
					setTimeout("ProfilesIntegration.enablePage();",500);
				} else {
					setTimeout("ProfilesIntegration.enableElement('dragTable')", 500);
				}
			}
		}
		catch (e)
		{
		}
	},

	makeItem: function(type,name,unid,aName,form,hasP,nC,lev,revNum,docNum,attName,attSize,isLocked,auth,aDN,eDN,nDD,authors) {
		//BBXSS Change
		name = name.replace(/\\\"/g, '"');
		
		var tr=document.createElement("tr");
		tr.className="h-folderItem-bg";

		// Checkbox
		var td0=document.createElement("td");
		td0.className="h-folderItem-text";
		td0.setAttribute("width","10");
		var ch=FM.check.makeSelect(type,name,unid,authors);
		td0.appendChild(ch);
		ch.onclick=function(){FM.check.select(this);}
		ch.onmouseover=function(){this.style.cursor='default';}
		tr.appendChild(td0);

		// Checked-out icon
		var td1=document.createElement("td");
		td1.className="h-folderItem-text";
		td1.style.textAlign="center";
		var img=document.createElement("img");
		if (isLocked=="1" && typeof(authors) != "undefined") {
			img.src="/qphtml/html/common/check_out_you.gif";
			//SPR:RELS7LR3XD
			var szCommonName=getCommonName(authors);
			img.alt=img.title=szCommonName;		
		} else {
			img.src="/qphtml/html/common/transparent.gif";
		}
		td1.appendChild(img);
		tr.appendChild(td1);

		// Doc icon
		var td2=document.createElement("td");
		td2.className="h-folderItem-text";
		td2.style.textAlign="center";
		if (lev=="1") {
			td2.appendChild(FM.view.getIconImg(type,form,attName));
		}
		tr.appendChild(td2);

		// Drag handle, response indent(s), title, rev#
		var td3=document.createElement("td");
		td3.className="h-folderItem-text";
		var span=document.createElement("span");
		if (lev=="1" && type != "1") {
			span.className="h-dragSource";
			span.id="dragSrc_"+unid;
			span.innerHTML=QP_DragAndDrop_makeHandle(unid);
		}
//		span.innerHTML += GenerateResponseIndent(lev,docNum,nC,(attName!=''))
		span.innerHTML += FV.responses.makeIndent(lev,docNum,nC,(attName!=''))
		+ (typeof(aName) != "undefined" ? GenerateQPObjURLAnchor(type,aName,name) : name);
		td3.appendChild(span);
		if (revNum && revNum != "") {
			 // removed for 8.1+
			 //td3.appendChild(document.createTextNode("&nbsp;"+GenerateRevisionText(revNum)));
		}
		tr.appendChild(td3);

		// Other (optional/custom) columns:
		for (var i=0; i<this.aColVal.length; i++) {
			var td=document.createElement("td");
			td.className="h-folderItem-text";

			switch (this.aColVal[i].col) {
			case "h_Author":
				td.innerHTML=GetMemberProfileName(aDN,this.aColVal[i].val);
				td.style.whiteSpace="normal";
				break;
			case "h_LastEditorDisplayName":
				td.innerHTML=GetMemberProfileName((eDN==""?aDN:eDN),this.aColVal[i].val);
				td.style.whiteSpace="normal";
				break;
			case "Status":
			    if (this.aColVal[i].val == "Success") {
			        var a=document.createElement("a");
					//a.innerHTML="complete";
					a.innerHTML="<img src=\"/qphtml/html/common/iconConfirmation_16.gif\" alt=\"\" /> complete";
					a.title="publishstatus";
					a.style.textDecoration="none";
					td.appendChild(a);
				}
				else if (this.aColVal[i].val == "Pending"){
			        var a=document.createElement("a");
					//a.innerHTML="complete";
					a.innerHTML="<img src=\"/qphtml/html/common/iconPending_16.gif\" alt=\"\" /> Pending";
					a.title="publishstatus";
					a.style.textDecoration="none";
					td.appendChild(a);
				}
				else {
			        var a=document.createElement("a");
					//a.innerHTML="complete";
					a.innerHTML="<img src=\"/qphtml/html/common/iconError_16.gif\" alt=\"\" /> Failed";
					a.title="publishstatus";
					a.style.textDecoration="none";
					td.appendChild(a);
				}
				
			    break;

			case "h_DisplayModified":
			case "h_Modified":  
			case "h_Created":
				// disabled anchor w/ timestamp when hover
				var ts=this.aColVal[i].val;
				var d=FV.date.i18n(ts.substring(0, ts.indexOf(" ")));
				var t=FV.date.getDisplayTime(ts.substring(ts.indexOf(" ")+1));
				var displayTs = d + " " + t;
				iSpc=displayTs.indexOf(' ');
				var a=document.createElement("a");
				a.innerHTML=(iSpc>=0 ? displayTs.substring(0,iSpc) : displayTs);
				a.title=a.alt=displayTs;
				a.style.textDecoration="none";
				td.appendChild(a);
				break;
			case "h_AttachmentNames":
				if (typeof(attName) != "undefined" && attName != "") {
					// Special case for attachments
					td.className="h-folderItem-text download";
					td.innerHTML=GenerateAttachmentsAnchor(unid,attName,attSize,form);
				}
				break;
			default:
				td.innerHTML=this.aColVal[i].val;
				break;
			}
			tr.appendChild(td);
		}

		// tbody needed for IE!
 		var tbody=document.createElement("tbody");

		// Make the tbody a drag container if:
 		// - not a folder or response
		// - user not a Reader
		// - not a top doc with responses unless manager
		if (UIDragAndDropIsEnabled()
			 && type != "1"
			 && lev==1
			 && currentUserAccess>2
			 && (nC==0 || currentUserAccess>=6))
		{
			tbody.id="DC_"+unid;
			tbody.onmouseover=function(){this.className="h-dragSource-selected"; dojo.byId("DH_"+unid).style.visibility="visible";};
			tbody.onmouseout=function(){this.className="h-dragSource-deselected"; dojo.byId("DH_"+unid).style.visibility="hidden";};
		}

 		tbody.appendChild(tr);
		return tbody;
	},

	makeTitleBar: function(aCols) {
		var tr=document.createElement("tr");
		tr.className="lotusSort";
		tr.id="viewTitleBar";

		// checkbox col
		var td0=document.createElement("td");
		td0.className="h-folderItem-text";
		// SPR #DANE7GMNTL: spacing problems when cols hidden
		//td0.setAttribute("width","0");
		td0.setAttribute("width","1%"); 
		var ch=FM.check.makeSelectAll();
		td0.appendChild(ch);
		ch.onclick=function(){FM.check.selectAll(this);}
		tr.appendChild(td0);

		// checked-out icon col
		var th0=document.createElement("th");
		th0.setAttribute("vAlign","middle");
		// SPR #DANE7GMNTL: spacing problems when cols hidden
		//th0.setAttribute("width","16");
		th0.setAttribute("width","1%");
		th0.style.textAlign="center";
		var img=document.createElement("img");
		img.src="/qphtml/html/common/transparent.gif";
		th0.appendChild(img);
		tr.appendChild(th0);

		var a;
		var th;
		var col;
		var sort=FM.view.getSort();
		for (var i=0; i<aCols.length; i++) {

			col=aCols[i];

			th=document.createElement("th");
			th.setAttribute("nowrap","");
			th.setAttribute("vAlign","middle");
			th.setAttribute("width",col.width);
			th.style.overflow = 'hidden';
			th.style.verticalAlign = 'middle';
			th.style.padding="3px 0px";
			th.style.textAlign=col.align;

			a=document.createElement("a");
			a.innerHTML=col.name;
			a.href="javascript:void(0);";
			if (col.sort > -2) {
				// sortable col
				var atitle=QuickrLocaleUtil.getStringResource("FOLDER.SORTCOL");
				atitle = atitle.replace("{0}", col.name);
				a.title = atitle;
				a.id="sortBtn_"+col.pos;

				if (typeof(Quickr81SupportUtil) != "undefined") {
					// new style 2-way Ajax sort with cookies
					a.onclick=function(){FM.view.onSortBtn(this);return false;};

					if (sort) {
						if (col.pos==sort.col) {
							a.className="lotusActiveSort lotus" + (sort.ord=="0" ? "A" : "De") + "scending";
						}
					}
					else if (col.sort >= 0) {
						a.className="lotusActiveSort lotus" + (col.sort=="0" ? "A" : "De") + "scending";
						FM.view.setSort(col.pos,col.sort);
					}
				}
				else {
					// old style 3-way sort
					var html=MakeTitle(col.name,col.pos);
					var bIsSorted=(html.indexOf("Sorted")>0);
					var i1=html.indexOf("href=");
					if (i1>0) {
						var html2=html.substring(i1+5);
						var i2=html2.indexOf(" ");
						var url=html2.substring(0,i2);
						if (bIsSorted) {
							a.className="lotusActiveSort lotus" + ((url.indexOf("Descending")>0) ? "A" : "De") + "scending";
						}
						a.href=url;
					}
				}
			}
			else {
				// not sortable
				a.style.cursor="default";
				a.style.textDecoration="none";
			}

			th.appendChild(a);
			tr.appendChild(th);
		} 

		// Needed for IE!
		var tbody=document.createElement("tbody");
		tbody.appendChild(tr);
		return tbody;
	}

} // FV.list.view


// ------------------------------------------------------------

FV.summary = {

	init: function() {
		FV.summary.view.init();
		dojo.byId("pageNavBar").style.display="block";
		dojo.byId("shr_div").style.display="none";
	}
}

FV.summary.view = {

	baseURL: URL.utils.getProxyUrl() + "&Form=h_FolderViewJSON&charset=utf-8",
   mimeType: "text/javascript",

	init: function() {
		FM.view.setFVObj("FV.summary");
	},

	getBaseURL: function(bUpdView) {
		// update view (variables)?
		return this.baseURL + "&PreSetFields=h_UpdateView;"+(typeof(bUpdView)=="undefined" || bUpdView ? "1" : "0");;
	},

	reqData: function() {

		var now = new Date();
		var mType=returnSubType(eval(FM.view.fvObj+".view.mimeType"));
		try {
				dojo.xhrGet ({
					url: FM.view.makeURL(FM.view.getStart(), FM.view.getIPP(),null,null,URL.utils.COLLAPSED,-1,false)+'&timestamp='+now.getTime(),
					handleAs: (typeof(mType)=="undefined" ? "text" : mType),
					load: function(response) {eval(FM.view.fvObj+'.view.refresh(response)');FM.view.refreshPgBtns();}
			});
			FM.view.showPgLoading(true);
		}
		catch(e) {
		}
	},

	refresh: function(data) {
		// Reset vars
		iTotNumOfDocs = 0;
		iDocArrayCount = 0;

		try
		{
			var items=data.items;

			// current view
			var fvt1 = dojo.byId("dragTable") || dojo.byId("dragDiv");

			// new view
			var fvt2=document.createElement("div");
				
			if (items.length > 0) {
				var els = qp_getElementsByClassName("h-folderEmpty", "div", fvt1.parentNode);
				if (els.length > 0) {
					els[0].parentNode.removeChild(els[0]);
				}
				
				// append title bar
				fvt2.appendChild(FV.summary.view.makeTitleBar(h_FV_Cols));

				// append view entries
				var fvn=item=null;
				for (var i=0; i<items.length; i++)
				{
					var item=items[i].item;
					
					UpdateDocArray( iDocArrayCount++, item.Unid, item.HasParent, item.HasChildren);

					iTotNumOfDocs++;
					
					fvn=FV.summary.view.makeItem(
						item.Type,
						item.Name.replace(/\\&quot;/g,"&quot;"),
						item.Unid,
						GenerateQPObjURLAnchorTag(data.FolderStorage, item.Unid, item.URLpointer, item.URLNewWindow, item.Type),
						item.Form,
						item.HasParent,
						item.HasChildren,
						item.DocLevel,
						item.RevNum,
						item.DocNumber,
						item.Attachments,
						item.AttachLengths,
						item.IsLocked,
						item.Author,
						item.AuthorDN,
						item.LastEditor,
						item.LastEditorDN,
						item.Created,
						item.Modified,
						item.Descendants,
						// SPR#RALF8B9NVW
						item.Abstract.replace(new RegExp("\&amp;","g"),"&"),
						// QuickrGeneralUtil.decodeEntities(QuickrGeneralUtil.decodeEntities(item.Abstract)),
						item.Authors
					);
					fvt2.appendChild(fvn);
				}

				// record last doc #
				//FM.view.nextStart=item.DocNumber;
			}
			else {
				// empty folder
				FM.view.nextStart=0;
				if (qp_getElementsByClassName("h-folderEmpty", "div", fvt1.parentNode).length==0) {
					var div=document.createElement("div");
					div.className="h-folderEmpty";
					div.innerHTML=FM.view.emptyMsg();
					fvt1.parentNode.appendChild(div);
				}
			}

			
			FM.view.previousStart=data.FolderPreviousStart;
			FM.view.nextStart=data.FolderNextStart;

			FM.view.absStart = data.FolderAbsStart;
			FM.view.absEnd = Math.max(0, data.FolderAbsStart+iTotNumOfDocs-1);
			FM.view.absCount = data.FolderDocCount;
			
			
			// update "showing items a-b of c"
			FM.view.refreshABofC(data.FolderAbsStart,data.FolderDocCount,iTotNumOfDocs);
			
			// replace view
			fvt1.parentNode.replaceChild(fvt2,fvt1);
			fvt2.id="dragTable";
			
			if (items.length > 0) {
				// run the context menu/person card/DND stuff
				QP_ContextMenu_attachMenus(fvt2);
				QP_DragAndDrop_createObjects("div", "dragTable");
			}
			
			// show new view
			FM.view.showPgLoading(false);

			// View (details/summary) buttons
			FM.view.initViewBtns();
			
			FM.view.nRefreshes++;

			if (items.length > 0 && G_ProfileServer != "") {
				if (FM.view.nRefreshes==1) {
					// 1st time - activate person cards on entire page
					setTimeout("ProfilesIntegration.enablePage();",500);
				} else {
					setTimeout("ProfilesIntegration.enableElement('dragTable')", 500);
				}
			}
		}
		catch (e)
		{
		}
	},

	makeItem: function(type,title,unid,aTitle,form,hasP,nC,lev,revNo,docNo,atchNm,atchSz,bLock,aCN,aDN,eCN,eDN,cDT,mDT,nDD,abst,authors) {
	
		//BBXSS Change
		title = title.replace(/\\\"/g, '"');
		
		
		// format date/times
		var szCrtOn = QuickrLocaleUtil.getStringResource("FOLDER.CREATED").replace("{0}", this.formatDateTime(cDT,true));
		var szUpdBy = QuickrLocaleUtil.getStringResource("FOLDER.UPDATED").replace("{0}", this.formatDateTime(mDT));
		szUpdBy = szUpdBy.replace("{1}", ((eDN=='' && eCN=='') ? '' : GetMemberProfileName(eDN,eCN)));
	
		var div_0=document.createElement("div");
		var div_1,div_2,div_3,a,ch,h4,img,table,tbody,tr,td,ul,li;

		// ------------------------
		// table containing basic info
		table=document.createElement("table");
		if (iTotNumOfDocs==1) {
			// first entry
			table.className="lotusTable noBorder";
			table.style.paddingTop=".5em";
		} else {
			table.className="lotusTable";
		}
		table.style.width="100%";
		tbody=document.createElement("tbody");
		tr=document.createElement("tr");

		// checkbox
		var td=document.createElement("td");
		td.style.width="20px";
		ch=FM.check.makeSelect(type,title,unid,authors);
		td.appendChild(ch);
		ch.onclick=function(){FM.check.select(this);}
		ch.onmouseover=function(){this.style.cursor='default';}
		tr.appendChild(td);

		// doc icon
		td=document.createElement("td");
		td.style.width=(type=="1" ? "28px" : "20px");
		td.appendChild(FM.view.getIconImg(type,form,atchNm));
		tr.appendChild(td);

		// title link
		td=document.createElement("td");
		h4=document.createElement("h4");
		div_1=document.createElement("div");
		div_1.style.display="block";
		// drag handle
		if (type != "1") {
			div_1.className="h-dragSource";
			div_1.id="dragSrc_"+unid;
			div_1.innerHTML=FV.summary.view.makeHandle(unid);
		}
		div_1.innerHTML += (typeof(aTitle) != 'undefined' ? GenerateQPObjURLAnchor(type,aTitle,title) : title);
		h4.appendChild(div_1);
		td.appendChild(h4);
		tr.appendChild(td);

		if (type != "1") {
			// Not a folder...
			// download
			td=document.createElement("td");
			td.className="lotusMeta lotusAlignRight";
			td.style.width="100px";
			if (atchNm != 0) {
				td.innerHTML='<span class="lotusMeta">'+QuickrLocaleUtil.getStringResource("LABEL.DOWNLOAD")+'&nbsp;&nbsp;</span>'
					 +GenerateAttachmentsAnchor(unid,atchNm,atchSz,form);
			} else {
				td.innerHTML="&nbsp;";
			}
			tr.appendChild(td);
			
			// more/hide links
			td=document.createElement("td");
			td.className="lotusMeta lotusAlignRight";
			td.style.width="80px";
			div_1=document.createElement("div");
			div_1.className="entryInlineRead";
			div_1.style.display="block";
			
			// More (default)
			a=document.createElement("a");
			a.id="more_"+unid;
			a.href="javascript:void FV.summary.view.more('"+unid+"');";
			a.innerHTML=QuickrLocaleUtil.getStringResource("LABEL.MORE");
			a.style.display="inline";
			div_1.appendChild(a);
			// Hide
			var a=document.createElement("a");
			a.id="hide_"+unid;
			a.className="hideLink";
			a.href="javascript:void FV.summary.view.showDetail('"+unid+"',0);";
			a.innerHTML=QuickrLocaleUtil.getStringResource("LABEL.HIDE");
			a.style.display="none";
			div_1.appendChild(a);
			// Loading
			img=document.createElement("img");
			img.id="load_"+unid;
			img.alt = "loading";
			img.src="/qphtml/html/common/ajax_loader.gif";
			img.style.display="none";
			div_1.appendChild(img);

			td.appendChild(div_1);
		}
		tr.appendChild(td);
		tbody.appendChild(tr);
		table.appendChild(tbody);
		div_0.appendChild(table);

		// ------------------------
		// table containing details
		table=document.createElement("table");
		table.className="lotusTable noBorder";
		table.style.width="100%";
		tbody=document.createElement("tbody");
		tr=document.createElement("tr");

		// under checkbox
		var td=document.createElement("td");
		td.style.width="20px";
		tr.appendChild(td);

		// Checked-out icon +8px under drag handle
		td=document.createElement("td");
		td.style.width="28px";
		var img=document.createElement("img");
		if (bLock=="1" && typeof(authors) != "undefined") {
			img.src="/qphtml/html/common/check_out_you.gif";
			//SPR:RELS7LR3XD
			//SPR:XMYG7XQ56Q
			var szCommonName=getCommonName(authors);
			img.alt=img.title=szCommonName;	
			td.appendChild(img);	
		}		
		tr.appendChild(td);

		// dates
		var td=document.createElement("td");
		div_1=document.createElement("div");
		div_1.className="lotusMeta";
		div_1.innerHTML=szUpdBy+" | "+szCrtOn;

		td.appendChild(div_1);

		div_1=document.createElement("div");
		div_1.id="summaryDetails_"+unid;
		div_1.className="summaryDetails";
		div_1.style.display="none";

		// <div class="entryInlineReadFields_"+unid> greenwichmean.gif </div>
		if (abst != "") {
			div_2=document.createElement("div");
			div_2.className="summaryAbstract";
			div_2.innerHTML=abst;
			div_1.appendChild(div_2);
		}
		// <div class="entryInlineRead_"+unid>

		// Responses
		if (nDD != "" && nDD != "0") {
			div_2=document.createElement("div");
			div_2.className="h-abstractEntryResponses";
			// twisty
			img=document.createElement("img");
			img.id="TW_"+unid;
			img.className="twisty";
			img.setAttribute("src", "/qphtml/html/common/treenode_expand_plus.gif");
			img.alt=QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND");
			img.title=QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND");
			var aLink=document.createElement("a");
			aLink.href="javascript:;";
			aLink.onclick=function(){eval("javascript:FV.summary.view.getResponses(this.firstChild,'"+docNo+"','"+nDD+"','"+unid+"');");return false;};
			aLink.appendChild(img);
			div_2.appendChild(aLink);
			// rsp icon
			img=document.createElement("img");
			img.setAttribute("src", "/qphtml/html/common/response"+(atchNm!=""?"-attach":"")+".gif");
			img.style.padding="0 0.5em 0 0";
			img.style.verticalAlign="middle";
			div_2.appendChild(img);
			// #rsp
			div_2.appendChild(document.createTextNode(nDD));
			div_2.appendChild(document.createTextNode(" "+QuickrLocaleUtil.getStringResource("LABEL.RESPONSES")));
			// rsp thread container
			div_3=document.createElement("div");
			div_3.id="RD_"+unid;
			div_2.appendChild(div_3);
			div_1.appendChild(div_2);
		}

		// Quick Actions
		div_2=document.createElement("div");
		div_2.className="lotusActions";
		div_2.id="summaryActions_"+unid;
		div_1.appendChild(div_2);

		td.appendChild(div_1);
		tr.appendChild(td);
		tbody.appendChild(tr);
		table.appendChild(tbody);

		// Make the div a drag container if:
 		// - not a folder or response
		// - user not a Reader
		// - not a top doc with responses unless manager
		if (UIDragAndDropIsEnabled()
			&& type != "1"
			&& lev==1
			&& currentUserAccess>2
			&& (nC==0 || currentUserAccess>=6))
		{
			div_0.id="DC_"+unid;
			div_0.onmouseover=function(){dojo.byId("DH_"+unid).style.visibility="visible";};
			div_0.onmouseout=function(){dojo.byId("DH_"+unid).style.visibility="hidden";};
		}

		div_0.appendChild(table);
		return div_0;
	},

	getResponses: function(twisty,docNum,cnt,unid) {
		if (twisty.src.indexOf("minus.gif")>0) {
			var divR=document.getElementById('RD_'+unid);
			divR.innerHTML = "";
			divR.style.display="none";
			twisty.src="/qphtml/html/common/treenode_expand_plus.gif";
			twisty.alt=QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND");
			twisty.title=QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND");
		}
		else {
			var sort=FM.view.getSort();
			var url=this.baseURL
			+ URL.utils.makeSortParm(sort.col,sort.ord)
			+"&ExpandView&Start="+docNum+".1&Count="+cnt+"&Form=h_FolderViewJSON&charset=utf-8&nowebcaching";
			
			try {		
				dojo.xhrGet({
					url: url,
					handleAs: "javascript",
					load: function(data, evt){FV.summary.view.showResponses(data,unid)},
					error: function(error){FV.summary.view.responseErr()}
				});
			}
			catch(e) {
				this.Error(e);
			}
		}
	},

	showResponses: function(data,unid) {
		 try {
			  var html = "";
			  var items = data.items;
			  for (i = 0; i < items.length; i++)
			  {
					var item=items[i].item;
					
					html+=FV.responses.SimpleResponseIndent(item.DocLevel,item.HasChildren,item.Attachments)
						 +GenerateQPObjURLAnchor(item.Type,
														 GenerateQPObjURLAnchorTag(data.FolderStorage,item.Unid,item.URLpointer,item.URLNewWindow, item.Type),
														 item.Name)
						 +'<br/>';
			  }
			  
			  var divR=document.getElementById('RD_'+unid);
			  divR.innerHTML = html;
			  QP_ContextMenu_attachMenus(divR);
			  divR.style.display="block";
			  
			  QuickrGeneralUtil.massageSecurityDomNode(divR);
			  
			  var imgT=document.getElementById('TW_'+unid);
			  imgT.src="/qphtml/html/common/treenode_expand_minus.gif";
			  imgT.alt=QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.COLLAPSE");
			  imgT.title=QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.COLLAPSE");
		 }
		 catch (e) {
		 }
	},

	responseErr: function(e){},

	formatDateTime: function(dt,bDateOnly) {
		bDO=(bDateOnly=="undefined" ? false : bDateOnly);
		if (dt.indexOf(" ") == -1) {
			return QuickrLocaleUtil.getStringResource("FOLDER.DATE").replace("{0}",FV.date.i18n(dt));
		} else {
			var d=FV.date.i18n(dt.substring(0, dt.indexOf(" ")));
			var t=FV.date.getDisplayTime(dt.substring(dt.indexOf(" ")+1));
			return (bDO
					? QuickrLocaleUtil.getStringResource("FOLDER.DATE").replace("{0}",d)
					: QuickrLocaleUtil.getStringResource("FOLDER.DATETIME").replace("{0}",d).replace("{1}",t));
		}
	},

	more: function(unid) {
		if (dojo.byId("actions_"+unid)) {
			// actions exist
			this.showDetail(unid,2);
		}
		else if (dojo.byId(unid+"_Menu")) {
			// create actions
			this.makeActions(unid);
			this.showDetail(unid,2);
		}
		else if (typeof(h_FolderStorage) != "undefined") {
			// get doc data
			try {
				var url="../../"+h_FolderStorage+"/"+unid+"/?OpenDocument";
				dojo.xhrGet({
					url: url + "&Form=h_DocXml&nowebcaching",
					handleAs: "xml",
					load: function (data) {FV.summary.view.makeMenuAndActions(unid,url,data);}
				});
				// show ajax loading....
				this.showDetail(unid,1);
			}
			catch(e) {
				this.showDetail(unid,0);
			}
		}
	},

	makeMenuAndActions: function(unid,url,data) {
		makeDocContextMenu(unid,url,data);
		this.makeActions(unid);
		this.showDetail(unid,2);
	},

	// Context menu actions to use for "quick actions" in summary view
	// NOTE: must localize these strings
	aActions: [
		{"name":"QP_FOLDER_MGMT.CHECK_OUT_AND_EDIT",				"pre":""},
		{"name":"QP_FOLDER_MGMT.NEW_RESPONSE",						"pre":"R_"},
		{"name":"QP_FOLDER_MGMT.NEW_RESPONSE_WITH_HISTORY",	"pre":"R_"},
		{"name":"QP_FOLDER_MGMT.NOTIFY",								"pre":""}
	],
	makeActions: function(unid,ul) {
		// create actions from context menu
		var actions=dojo.byId("summaryActions_"+unid);
		var ul=document.createElement("ul");
		ul.className="lotusInlinelist";
		ul.id="actions_"+unid;
		ul.style.padding="0px";
		for (var i=0,n=0; i<this.aActions.length; i++) {
			var action_name = QuickrLocaleUtil.getStringResource(this.aActions[i].name);
			var li=this.makeAction(unid,action_name,this.aActions[i].pre);
			if (li) {
				if (++n==1) li.className="lotusFirst";
				ul.appendChild(li);
			}
		}
		actions.appendChild(ul);
	},

	makeAction: function(unid,name,prefix) {
		// make action from context menu action
		var li=null;
		var id=unid+"_"+prefix+QP_ContextMenu_fixName(name);
		var ma=dojo.byId(id);
		if (ma && ma.nodeName.toUpperCase()=="A") {
			li=document.createElement("li");
			var a=document.createElement("a");
			a.href=ma.href;
			a.innerHTML=name;
			li.appendChild(a);
		}
		return li;
	},

	aSD: [
		{"d":"none", "h":"none",  "m":"inline","l":"none"},
		{"d":"none", "h":"none",  "m":"none",  "l":"inline"},
		{"d":"block","h":"inline","m":"none",  "l":"none"}
	],
	showDetail: function(unid,state) {
		dojo.byId("summaryDetails_"+unid).style.display=this.aSD[state].d;
		dojo.byId("hide_"+unid).style.display=this.aSD[state].h;
		dojo.byId("more_"+unid).style.display=this.aSD[state].m;
		dojo.byId("load_"+unid).style.display=this.aSD[state].l;
	},

	makeHandle: function(unid) {
		return '<img style="padding-right:4px;vertical-align:top;visibility:hidden;" id="DH_'+unid+'"'
		+ ' onmouseover="this.origSrc=this.src;this.style.cursor=\'move\';this.src=\'/qphtml/html/common/draghndl_hover.gif\';"'
		+ ' onmouseout="this.src=this.origSrc;this.style.cursor=\'default\';"'
		+ ' src="/qphtml/html/common/drag_icon.gif"'
		+ ' title="' + QuickrLocaleUtil.getStringResource("DND.DRAG") + '" alt="'
		+ QuickrLocaleUtil.getStringResource("DND.DRAG") + '"/>';
	},

	makeTitleBar: function(aCols) {
		var a,ch,div,ul,li;
		div=document.createElement("div");
		div.className="lotusSort";
		div.id="viewTitleBar";

 		ul=document.createElement("ul");
		ul.className="lotusInlinelist";
		ul.style.padding="0px";

		// "select all" checkbox
		ch=FM.check.makeSelectAll();
		ch.onclick=function(){FM.check.selectAll(this);}
		li=document.createElement("li");
		li.appendChild(ch);
		li.className="lotusFirst allCheckbox";
		ul.appendChild(li);

		// "Sort by"
		li=document.createElement("li");
		li.appendChild(document.createTextNode(QuickrLocaleUtil.getStringResource("LABEL.SORTBY")));
		li.className="lotusFirst";
		ul.appendChild(li);

		var sort=FM.view.getSort();
		for (var i=0; i<aCols.length; i++) {

			var col=aCols[i];
			if (col.sort > -2) {
				// sortable col
				li=document.createElement("li");
				if (i==0) li.className="lotusFirst";
				a=document.createElement("a");
				a.innerHTML=col.name;
				a.href="#";
				
				var atitle=QuickrLocaleUtil.getStringResource("FOLDER.SORTCOL");
				atitle = atitle.replace("{0}", col.name);
				a.title = atitle;
				a.id="sortBtn_"+col.pos;
				
				// new style 2-way Ajax sort with cookies
				a.onclick=function(){FM.view.onSortBtn(this);return false;};
				
				if (sort) {
					if (col.pos==sort.col) {
						a.className="lotusActiveSort lotus" + (sort.ord=="0" ? "A" : "De") + "scending";
					}
				}
				else if (col.sort >= 0) {
					a.className="lotusActiveSort lotus" + (col.sort=="0" ? "A" : "De") + "scending";
					FM.view.setSort(col.pos,col.sort);
				}
				
				li.appendChild(a);
				ul.appendChild(li);
			}
		} 

		div.appendChild(ul);
		return div;
	}

}


// ------------------------------------------------------------

FV.tasks = {

	init: function() {
		FV.tasks.view.init();
		dojo.byId("pageNavBar").style.display="block";
		var pnbt=dojo.byId("pageNavBarTop");
		var thdr=dojo.byId("h_taskHeader1");
		if (pnbt && thdr) {
			// move tasks nav to top nav bar
			var thdr2=thdr.cloneNode(true);
			var pnbt2=document.createElement("div");
			pnbt2.className="lotusPaging";
			pnbt2.appendChild(thdr2);
			pnbt.parentNode.replaceChild(pnbt2,pnbt);
			pnbt2.id="pageNavBarTop";
			thdr.parentNode.removeChild(thdr);

		}
	}
}

FV.tasks.view = {

	baseURL: URL.utils.getProxyUrl(),

	getBaseURL: function() {
		return this.baseURL;
	},

	init: function() {
		FM.view.setFVObj("FV.tasks");
		FM.view.init();
		// force IPP and Start to be defaults or whatever's in URL,
		// because preset cookie values don't affect non-AJAX views
		FM.view.setIPP((typeof(h_FolderCount)=="undefined" ? 20 : h_FolderCount));
		FM.view.setStart((typeof(h_FolderStart)=="undefined" ? 1 : h_FolderStart));
		FM.view.refreshIpp();
		FM.view.refreshPgBtns();
	}
}


// ------------------------------------------------------------

FV.calendar = {

	init: function() {
		FV.calendar.view.init();
		var pnbt=dojo.byId("pageNavBarTop");
 		var chdr=dojo.byId("h_calendarHeader");
		if (pnbt && chdr) {
			// move calendar nav to top nav bar
			var chdr2=chdr.cloneNode(true);
			var pnbt2=document.createElement("div");
			pnbt2.className="lotusPaging";
			pnbt2.appendChild(chdr2);
			pnbt.parentNode.replaceChild(pnbt2,pnbt);
			pnbt2.id="pageNavBarTop";
			chdr.parentNode.removeChild(chdr);

		}
 	}
}

FV.calendar.view = {

	baseURL: URL.utils.getProxyUrl(),

	getBaseURL: function() {
		 return this.baseURL;
	},

	gridBtns: ["","calSelectTwoDays","calSelectOneWeek","calSelectTwoWeeks","calSelectOneMonth"],
	gridImgs: ["","cal2day-sel.gif","calweek-sel.gif","cal2week-sel.gif","calmonth-sel.gif"],

	init: function() {
		FM.view.setFVObj("FV.calendar");
		FM.view.init();
		// force IPP and Start to be defaults or whatever's in URL,
		// because preset cookie values don't affect non-AJAX views
		FM.view.setIPP((typeof(h_FolderCount)=="undefined" ? 20 : h_FolderCount));
		FM.view.setStart((typeof(h_FolderStart)=="undefined" ? 1 : h_FolderStart));

		// select cal view icon
		var i=location.href.indexOf("&Grid=");
		var g=3;
		var btn;
		if (i>0) {
			g=parseInt(location.href.substring(i+6));
		}
		if (g>0 && g<this.gridBtns.length) {
			btn=dojo.byId(this.gridBtns[g]);
			if (btn) {
				btn.src="/qphtml/attachments/"+this.gridImgs[g];
			}
		}
		if (document.body.dir == "rtl") {
			// reverse the direction of arrow button
			btn=dojo.byId("calSelectPrev");
			if (btn) {
				btn.src="/qphtml/attachments/calnext.gif";
			}
			btn=dojo.byId("calSelectNext");
			if (btn) {
				btn.src="/qphtml/attachments/calprev.gif";
			}
		}
	}
}


// ------------------------------------------------------------

FV.date = {

	parseDateString: function ( dateString, dateElements)
	{	 
		logEnter("parseDateString");

		// extract the first element from the date string
		var slashIdx1 = parseInt( dateString.indexOf( haiku.h_Intl_DateString), 10);
		if( slashIdx1 == -1) return( false);

		var element1 = dateString.substring( 0, slashIdx1);
		if( !isNumericString( element1)) return( false);

		// extract the middle element
		var slashIdx2 = parseInt( dateString.lastIndexOf( haiku.h_Intl_DateString),10);
		if( slashIdx2 == -1) return( false);

		var element2 = dateString.substring( slashIdx1 + 1, slashIdx2);
		if( !isNumericString( element2)) return( false);

		// extract the last element
		var element3 = dateString.substring( slashIdx2 + 1);
		if( !isNumericString( element3)) return( false);
	

		// parse year, month, and day according to h_Intl_DateFormat
		if( haiku.h_Intl_DateFormat == haiku.kszDMY) 
		{
			dateElements[0] = parseInt( element1,10); // day
			dateElements[1] = parseInt( element2,10); // month
			dateElements[2] = parseInt( element3,10); // year
		}

		else if( haiku.h_Intl_DateFormat == haiku.kszYMD)
		{
			dateElements[2] = parseInt( element1,10);	// year
			dateElements[1] = parseInt( element2,10); // month
			dateElements[0] = parseInt( element3,10); // day
		}

		else // default to haiku.kszMDY
		{
			dateElements[1] = parseInt( element1,10); // month
			dateElements[0] = parseInt( element2,10); // day
			dateElements[2] = parseInt( element3,10); // year
		}

		return( true);
 
		logExit("parseDateString"); 
	},

	getDisplayDate: function (day, month, year)
	{
		var dateSep;
		var dateFormat;
		var date4DigitYear;
		if(haiku.hasRegionalCookie == true)
		{//user has set regional
			dateSep        = haiku.h_Cookie_DateString;
			dateFormat     = haiku.h_Cookie_DateFormat;
			date4DigitYear = haiku.h_Cookie_Date4DigitYear;
		}
		else
		{
			dateSep        = haiku.h_Intl_DateString;
			dateFormat     = haiku.h_Intl_DateFormat;
			date4DigitYear = haiku.h_Intl_Date4DigitYear;
		}

		var dateString;
		var yr;
		if(date4DigitYear == false)
		{
			yr = year.toString().substring(2);
		}
		else 
		{
			yr = year.toString();
		}

		if( dateFormat == haiku.kszDMY)
		{
			dateString =(( day<10) ? "0"+day : day).toString( ) + dateSep + (( month<10) ? "0"+month : month).toString( ) + dateSep + yr;
		}

		else if( dateFormat == haiku.kszYMD)
		{
			dateString = yr + dateSep + (( month<10) ? "0"+month : month).toString( ) + dateSep + (( day<10) ? "0"+day : day).toString( );
		}

		else // default to haiku.kszMDY
		{
			dateString =(( month<10) ? "0"+month : month).toString( ) + dateSep + (( day<10) ? "0"+day : day).toString( ) + dateSep + yr;
		}
		return( dateString);
	},
	i18n: function(date) {
		// Convert to Hijri or Hebrew or... 
		var hDate="";
		if (isHijri) { 
			var hDate = new dateHijri().gregorianToHijri(new Date(date));
		} else if (isHebrew) {
			var hDate = new dateHebrew().gregorianToHebrew(new Date(date));
		} else if(haiku.hasRegionalCookie == true) {
			var dateElements = new Array( 0, 0, 0);
			FV.date.parseDateString(date, dateElements);
			return FV.date.getDisplayDate(dateElements[0], dateElements[1], dateElements[2]);
		} else {
			return date;
		}
			
		var sep = haiku.h_Intl_DateString;
		if (haiku.h_Intl_DateFormat==haiku.kszDMY) {
			return hDate.getDate() + sep + (hDate.getMonth()+1) + sep + hDate.getFullYear();
		}
		else if (haiku.h_Intl_DateFormat==haiku.kszYMD) {
			return hDate.getFullYear() + sep + (hDate.getMonth()+1)+ sep + hDate.getDate();
		}
		else {
			return (hDate.getMonth()+1) + sep + hDate.getDate() + sep + hDate.getFullYear();
		}
	},
	
	getDisplayTime: function(timeString) {
		if(haiku.hasRegionalCookie == false)
			return timeString;
			
		var timePos = timeString.search(/\d\d\W\d\d/g);;	
		var hourStr = timeString.substring(timePos, timePos + 2);
		var minStr  = timeString.substring(timePos + 3, timePos + 5);
		
		if(haiku.h_Cookie_Clock24Hour == true)
		{// 24 hour format
			if((timeString.substring( timeString.indexOf(" ") + 1) == haiku.h_Intl_PMString 
			   || timeString.substring( timeString.indexOf(" ") + 1) == haiku.h_Cookie_PMString ) 
			   && hourStr != "12")
			{
				hourNum = Number(hourStr) + 12;
				hourStr = hourNum.toString();
			}
			else if((timeString.substring( timeString.indexOf(" ") + 1) == haiku.h_Intl_AMString 
			   || timeString.substring( timeString.indexOf(" ") + 1) == haiku.h_Cookie_AMString ) 
			   && hourStr == "12")
			{
				hourNum = Number(hourStr) - 12;
				hourStr = hourNum.toString();
			}
			return (hourStr + haiku.h_Cookie_TimeString + minStr);
		}

		var AMPMString;
		if(timeString.indexOf(" ") == -1)
		{// input 24 hour format
			var hourNum = Number(hourStr);
			if(hourNum == 0)
			{
				hourNum = Number(hourStr) + 12;
				hourStr = hourNum.toString();
				AMPMString = haiku.h_Cookie_AMString;
			}
			else if(hourNum > 0 && hourNum <= 11)
			{
				AMPMString = haiku.h_Cookie_AMString;				
			}
			else if(hourNum == 12)
			{
				AMPMString = haiku.h_Cookie_PMString;	
			}
			else(hourNum > 12 && hourNum <= 23)
			{
				hourNum = Number(hourStr) - 12;
				hourStr = hourNum.toString();
				AMPMString = haiku.h_Cookie_PMString;
			}
		}	
		else if(timeString.substring( timeString.indexOf(" ") + 1) != haiku.h_Intl_AMString && timeString.substring( timeString.indexOf(" ") + 1) != haiku.h_Intl_PMString)
		{
			if(haiku.h_Cookie_AMPMPrefix == true)
			{
				AMPMString = (timeString.substring( 0, timeString.indexOf(" ")) == haiku.h_Cookie_AMString) ? haiku.h_Cookie_AMString : haiku.h_Cookie_PMString;
			}
			else
			{
				AMPMString = (timeString.substring( timeString.indexOf(" ") + 1) == haiku.h_Cookie_AMString) ? haiku.h_Cookie_AMString : haiku.h_Cookie_PMString;
			}
		}
		else
		{
			AMPMString = (timeString.substring( timeString.indexOf(" ") + 1) == haiku.h_Intl_AMString) ? haiku.h_Cookie_AMString : haiku.h_Cookie_PMString;
		}

		if(haiku.h_Cookie_AMPMPrefix == true)
		{
			return (AMPMString + " " + hourStr + haiku.h_Cookie_TimeString + minStr);
		}
		else
		{
			return (hourStr + haiku.h_Cookie_TimeString + minStr + " " + AMPMString);
		}
	}
}
/* ***************************************************************** */
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2007, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/* ***************************************************************** */

/* Copyright IBM Corp. 2007, 2010  All Rights Reserved.              */

/* 5724-S31                                                          */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/*********************************************************************/


// QUICKR DOMINO DOC MANAGEMENT

DM = {
	init: function() {
		if (typeof(dojo) !="undefined") {
			dojo.addOnLoad(function(){
				//init the locale stuff
				QuickrLocaleUtil.loadStringFiles("common", "/qphtml/skins/common", "QuickrCommonStrings");
			});
		}
	},

	roomNsf: function() {
		return (typeof(currentRoom) != "undefined" && currentRoom && currentRoom.roomNsf ? currentRoom.roomNsf : "Main.nsf");
	}

}

DM.service = {

	sFunc: null,
	eFunc: null,

	submitPublishTo: function(publishOpts, svcXml, sFunc, eFunc, bSync) {

	    if (typeof bSync == "undefined" || bSync == null) bSync = false;
	    this.sFunc = sFunc || DM.service.success;
	    this.eFunc = eFunc || DM.service.error;
		if(typeof(publishOpts.credentials) == "undefined")
		{
			publishOpts.credentials ="";
		}
		
		var targetFolder = null;
		var slash = publishOpts.publishLocationPath.lastIndexOf('/');
		if(slash != -1){
			targetFolder = publishOpts.publishLocationPath.substring(0,slash+1);
		}
		
	     var xml = ''
		+ '<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'
		+ ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'
		+ ' xmlns:xsd="http://www.w3.org/2001/XMLSchema">'
		+ '<soap:Header>'
		+ '<serviceVersion>8.0.0</serviceVersion>'
		+ ""//headerXml
		+ '</soap:Header><soap:Body>'
		+ '<publishTo xmlns="http://webservices.clb.content.ibm.com">'
		+ '<publishFile>'+publishOpts.publishFile+'</publishFile>'
		+ '<targetServer>'+publishOpts.targetServer+'</targetServer>'
		+ '<metaData>'+publishOpts.metaData+'</metaData>'
		+ '<path>'+publishOpts.docUnid+'/'+'</path>'
		+ '<formUnid>'+publishOpts.formUnid+'</formUnid>'
		+ '<libraryID>'+publishOpts.libraryId+'</libraryID>'
		+ '<libraryPath>'+publishOpts.libraryPath+'</libraryPath>'
		+ '<credentials>'+publishOpts.credentials+'</credentials>'
		+ '<publishLocationId>'+publishOpts.publishLocationId+'</publishLocationId>'
		+ '<publishLocationPath>'+targetFolder+'</publishLocationPath>'
		+ '<publishAction>'+publishOpts.publishAction+'</publishAction>'
		+ '</publishTo>'//cXml
		+ '</soap:Body></soap:Envelope>';
		
		var post_url = '/dm/services/DocumentService?do401=true';
		post_url = appendNonceInURL(post_url);
		
	    try {
	        dojo.rawXhrPost({
	            url: post_url,
	            handleAs: "xml",
	            postData: xml,
	            sync: bSync,
	            load: function(data) { DM.service.sFunc(data); },
	            error: function(error) { DM.service.eFunc(error); }
	        });
	    }
	    catch (e) {
	        alert(e.message);
	    }
	},

	submit: function(fUnid,dUnid,svc,svcXml,sFunc,eFunc, bSync) {
		if (typeof bSync == "undefined" || bSync == null) bSync = false;
		DM.service.submitWithHeaderXml(fUnid,dUnid,svc,svcXml, "", sFunc, eFunc, bSync);
	},

	submitWithHeaderXml: function(fUnid,dUnid,svc,svcXml,headerXml,sFunc,eFunc, bSync) {

		this.sFunc=sFunc || DM.service.success;
		this.eFunc=eFunc || DM.service.error;
		var cXml = svcXml || this.xml.common(svc,fUnid,dUnid,"");
		var xml = ''
		+ '<soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/"'
		+ ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'
		+ ' xmlns:xsd="http://www.w3.org/2001/XMLSchema">'
		+ '<soap:Header>'
		+ '<serviceVersion>8.0.0</serviceVersion>'
		+ headerXml
		+ '</soap:Header><soap:Body>'
		+ cXml
		+ '</soap:Body></soap:Envelope>';
		
		var post_url = '/dm/services/DocumentService?do401=true';
		post_url = appendNonceInURL(post_url);
		
		try {
			dojo.rawXhrPost ({
				url: post_url,
				handleAs: "xml",
 				postData: xml,
 				sync: bSync,
				load: dojo.hitch(this, "sFunc", fUnid, dUnid),
				error: dojo.hitch(this, "eFunc")
			});
		}
		catch(e) {
			alert(e.message);
		}
	},

	success: function(fUnid,dUnid,data){
		try {
			var envelope = data.lastChild;
			var body = envelope.lastChild;
			var response1 = body.lastChild;
			var return1 = response1.lastChild;
			var error = return1.lastChild;
			if(error.localName == "error") {
				var errorType = error.getAttribute("type");
				var errorMessage = error.getAttribute("message");
				if(errorType == "GeneralInformation" && errorMessage != "" && errorMessage != null) {
					alert(errorMessage);
				}
			}
		}
		catch(e) {
		}
		this.reload();
	},
	error: function(e){alert(e.message);},

	reload: function() {
		if (typeof(FM.view) != "undefined" && typeof(Quickr81SupportUtil) != "undefined") {
			// use Ajax to refresh content
			FM.view.reqData();
		}
		else {
			location.reload();
		}
	}
}


DM.service.xml = {

	common: function(svc,fU,dU,att) {
		return '<'+svc+' xmlns="http://webservices.clb.content.ibm.com">'
		+ ' <path>/@P'+haikuName+'/@R'+DM.roomNsf()+'/@F'+fU+'/@D'+dU+att+'</path></'+svc+'>';
	},

	checkin: function(fU,dU,att) {
		return '<checkinDocument xmlns="http://webservices.clb.content.ibm.com">'
		+ ' <document path="/@P'+haikuName+'/@R'+DM.roomNsf()+'/@F'+fU+'/@D'+dU+'"/></checkinDocument>';
	}
}


DM.read = {
	// operations on a doc while in a "read scene":
	
	publishto:function(editable,formUnid,fUnid,dUnid,dName,dAttachmentNames,sFunc){
		popPublishWizard(editable,formUnid,fUnid,dUnid,dName,dAttachmentNames,sFunc);
		
	},
	 
	checkout: function(fUnid,dUnid) {
		DM.service.submit(fUnid,dUnid,"lockDocument",null,DM.read.loadDraft,DM.read.error);
	},

	checkin: function(fUnid,dUnid,bMassageData) {
		
		var callContinueCheckin = dojo.hitch(this, "_continueCheckin", fUnid, dUnid);
		if(typeof bMassageData != "undefined"){
			var div_richtext = dojo.byId("HaikuEditorRead");
			if(!div_richtext){
				//Blogs don't have this div, instead they use this
				div_richtext = dojo.query("div.BlogEntryContents")[0];
			}
			if(div_richtext){
				var richTextBody = div_richtext.innerHTML;
				var replaceValue = "/"+dUnid+"/$FILE/quickrimage_";
				var needsClean = richTextBody.match(/\/[A-Z0-9]*\/\$FILE\/quickrimage_/g);
				if(needsClean != null && dUnid.length != 0){
					
					var newRichTextBody = richTextBody.replace(/\/[A-Z0-9]*\/\$FILE\/quickrimage_/g, replaceValue);		 
					var sLibrary = "_P" + haikuName + "_R" + haiku.mailDb;
					var sFolder = "_P" + haikuName + "_R" + haiku.mailDb + "_D" + h_PageUnid;
					var action	= "/dm/atom/userlibrary/" + sLibrary + "/page/" + sFolder + "/entry?draft=true&replace=true&retContentType=text/xml&nonce=" +getCookie("NonceToken");
					
					dojo.query("#MassageImageReferences").forEach(dojo.destroy);
						
					var frmJit = DM.read._createNamedElement("form", "MassageImageReferences");	
					frmJit.setAttribute("id", "MassageImageReferences");
					frmJit.setAttribute("name", "MassageImageReferences");
					frmJit.setAttribute("action", action);
					frmJit.setAttribute("method", "POST");
					frmJit.setAttribute("enctype", "multipart/form-data");
														
					var inputXMethodOverridge = DM.read._createNamedElement("input", "X-Method-Override");
					inputXMethodOverridge.setAttribute("type", "hidden");
					inputXMethodOverridge.setAttribute("value", "PUT");
					frmJit.appendChild(inputXMethodOverridge);
					
					var inputTitle = DM.read._createNamedElement("input", "title");
					inputTitle.setAttribute("type", "hidden");
					inputTitle.setAttribute("value", h_Name);
					frmJit.appendChild(inputTitle);
					
					var inputUnid = DM.read._createNamedElement("input", "unid");
					inputUnid.setAttribute("type", "hidden");
					inputUnid.setAttribute("value", dUnid);
					frmJit.appendChild(inputUnid);
					
					var inputLabel = DM.read._createNamedElement("input", "label");
					inputLabel.setAttribute("type", "hidden");
					inputLabel.setAttribute("value", "");
					frmJit.appendChild(inputLabel);
					
					var inputDescription = DM.read._createNamedElement("input", "description");
					inputDescription.setAttribute("id", "description");
					inputDescription.setAttribute("type", "hidden");
					inputDescription.setAttribute("value", newRichTextBody);
					frmJit.appendChild(inputDescription);
					
					//dojo.create("input", { type: "hidden", name: "X-Method-Override", value: "PUT"}, frmJit);										
					//dojo.create("input", { type: "hidden", name: "title", value: h_Name}, frmJit);
					//dojo.create("input", { type: "hidden", name: "unid", value: dUnid}, frmJit);
					//dojo.create("input", { type: "hidden", name: "label", value: ""}, frmJit);
					//dojo.create("input", { type: "hidden", name: "description", id: "description", value: newRichTextBody}, frmJit);
							
					dojo.body().appendChild(frmJit);
					try {						
						dojo.require("dojo.io.iframe");					
						dojo.io.iframe.send({
							form: frmJit,
							handleAs: "xml",
							method: "POST", 
							load: function(response, ioArgs) {
								dojo.query("#MassageImageReferences").forEach(dojo.destroy);
								callContinueCheckin();
							},
							error: function(error){
								alert("error sending form");
							}
						});
					}
					catch(e) {
						this.Error(e);
					}	
					dojo.query("#MassageImageReferences").forEach(dojo.destroy);
				}
				else{
					DM.read._continueCheckin(fUnid,dUnid);
				}
			}
			else{
				DM.read._continueCheckin(fUnid,dUnid);
			}
		}
		else{
			DM.read._continueCheckin(fUnid,dUnid);
		}
	},
	_continueCheckin: function(fUnid,dUnid){
		var headerXml = '<libraryId>[@P' + haikuName + '/@R' + DM.roomNsf() + ']</libraryId>';
		DM.service.submitWithHeaderXml(fUnid,dUnid,"",DM.service.xml.checkin(fUnid,dUnid,""),headerXml,DM.read.loadIt,DM.read.error);
	},
	_createNamedElement: function(sTag, sName) {
		//taken from _base.js in the 8.5 theme
		var ret = null;
		try {
			ret = document.createElement("<" + sTag + " name=\"" + sName + "\">");
		} catch (ee) {}
		
		if (ret == null) {
			ret = dojo.doc.createElement(sTag);
			ret.name = sName;
		}		
		return ret;
	},
	
	revert: function(fUnid,dUnid) {
		DM.service.submit(fUnid,dUnid,"cancelDocument",null,DM.read.loadIt,DM.read.error);
	},

	loadDraft: function(fUnid,dUnid) {
		// we need to get just-created draft's UNID
		var ajax = new QPAjax();
		ajax.RequestXML((location.href + "&Form=h_DocXml&nowebcaching"), DM.read.loadDraftFromXml);
	},

	loadDraftFromXml: function(data) {
		// get draft UNID from xml
		var fUnid = getTagValue(data, "qp_doc", "h_FolderUNID");
		var dUnid = getTagValue(data, "qp_doc", "h_DraftVersionUNID");
		if (fUnid != "" && dUnid != "") {
			// load draft
			DM.read.loadIt(fUnid,dUnid,data);
		}
		else {
			// reload published doc with link to draft
			location.reload();
		}
	},

	loadIt: function(fUnid,dUnid,data) {
		try {
			var envelope = data.lastChild;
			var body = envelope.lastChild;
			var response1 = body.lastChild;
			var return1 = response1.lastChild;
			var error = return1.lastChild;
			if(error.localName == "error") {
				var errorType = error.getAttribute("type");
				var errorMessage = error.getAttribute("message");
				if(errorType == "GeneralInformation" && errorMessage != "" && errorMessage != null) {
					alert(errorMessage);
					return;
				}
			}
		}
		catch(e) {
		}
		var folder=((typeof(fUnid)=="undefined" || fUnid=="") ? currentFolderStorage : fUnid);
		location.href=getAbsoluteServerRootURL(self)+"/"+getHaikuSubDir(self)+"/"+haikuName+"/"+DM.roomNsf()+"/"+folder+"/"+dUnid+"/?OpenDocument";

	},

	error: function(fUnid,dUnid) {
		 alert(QuickrLocaleUtil.getStringResource("DOC.ERROR").replace("{0}",dUnid));
	}

} // DM.read



DM.folder = {
	// operations on a doc while in a folder view:
	
	publishto:function(editable,formUnid,fUnid,dUnid,szName,szAttachmentNames){
		popPublishWizard(editable,formUnid,fUnid,dUnid,szName,szAttachmentNames);
	},
	
	checkout: function(fUnid,dUnid) {
		DM.service.submit(fUnid,dUnid,"lockDocument");
	},

	checkin: function(fUnid,dUnid) {
		var headerXml = '<libraryId>[@P' + haikuName + '/@R' + DM.roomNsf() + ']</libraryId>';
		DM.service.submitWithHeaderXml(fUnid,dUnid,"",DM.service.xml.checkin(fUnid,dUnid,""), headerXml);
	},

	revert: function(fUnid,dUnid) {
		DM.service.submit(fUnid,dUnid,"cancelDocument");
	},

	remove: function(fUnid,dUnid,bInToc,pubUnid,draftUnid,nChildren) { 
		var url="";
		if (nChildren != 0) {
			// can't delete doc with children
			alert(QuickrLocaleUtil.getStringResource("DOC.CANT"));
		}
        //SPR:#RTIN7S9J6B
		else if (draftUnid=="")
		{
		   // simple case: no draft
		   if (confirm(QuickrLocaleUtil.getStringResource("DOC.DELETETHIS")))
		      DM.service.submit(fUnid,dUnid,"deleteDocument");
		}
		else if (confirm(QuickrLocaleUtil.getStringResource("DOC.DELETEBOTH"))) {
			// draft exists: this will remove both
			DM.service.submit(fUnid,dUnid,"deleteDocument",null,DM.read.loadIt,DM.read.error);
		}
	}
}

DM.folder.list = {

	reload: function() {
		// Ajax reload
	}
}


DM.folder.details = {

	reload: function() {
		// Ajax reload
	}
}
/* ***************************************************************** */
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2009, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/* ***************************************************************** */


function convertDateString(dateString){
		if(dateString==""){return dateString;}
		if(!(isHijri||isHebrew)) return dateString;
	var ret = "";
	var day;
	var month;
	var year;

	date = dateString.toString();
	var sDate = dateString.split(/\D/);
	if(haiku.h_Intl_DateFormat == haiku.kszDMY) {

		day = Number(sDate[0]);
		month = Number(sDate[1]);
		year = Number(sDate[2]);

	}else if(haiku.h_Intl_DateFormat == haiku.kszYMD){
		day = Number(sDate[2]);
		month = Number(sDate[1]);
		year = Number(sDate[0]);
	}else{
		day = Number(sDate[1]);
		month = Number(sDate[0]);
		year = Number(sDate[2]);
	}
	var date = new Date(year,month-1,day);
	if(isHijri){
	
		date = new dateHijri().gregorianToHijri(date);
	}
	if(isHebrew){
		date = new dateHebrew().gregorianToHebrew(date);
	
	}

	var sep = haiku.h_Intl_DateString;
	var year = date.getFullYear();
	var month =(((date.getMonth()+1) < 10) ? "0" : "") + (date.getMonth()+1);
	var day =((date.getDate() < 10) ? "0" : "") + date.getDate();
	if(haiku.h_Intl_DateFormat == haiku.kszDMY) {
		ret = day + sep + month + sep + year;
	}else if(haiku.h_Intl_DateFormat == haiku.kszYMD){
		ret = year + sep + month + sep + day;
	}else{
		ret = month + sep + day + sep + year;
	}
	return ret;
}


function returnToGregorian(dateString){
	if(dateString==""){return dateString;}
	if(!(isHijri||isHebrew)) return dateString;
	var ret = "";
	var day;
	var month;
	var year;

	date = dateString.toString();
	var sDate = dateString.split(/\D/);
	if(haiku.h_Intl_DateFormat == haiku.kszDMY) {

		day = Number(sDate[0]);
		month = Number(sDate[1]);
		year = Number(sDate[2]);

	}else if(haiku.h_Intl_DateFormat == haiku.kszYMD){
		day = Number(sDate[2]);
		month = Number(sDate[1]);
		year = Number(sDate[0]);
	}else{
		day = Number(sDate[1]);
		month = Number(sDate[0]);
		year = Number(sDate[2]);
	}
	var date;
	if(isHijri){
	
		date = new dateHijri(year,month-1,day).toGregorian();
	}
	if(isHebrew){
		date = new dateHebrew(year,month-1,day).toGregorian();
	
	}

	var sep = haiku.h_Intl_DateString;
	var year = date.getFullYear();
	var month =(((date.getMonth()+1) < 10) ? "0" : "") + (date.getMonth()+1);
	var day =((date.getDate() < 10) ? "0" : "") + date.getDate();
	if(haiku.h_Intl_DateFormat == haiku.kszDMY) {
		ret = day + sep + month + sep + year;
	}else if(haiku.h_Intl_DateFormat == haiku.kszYMD){
		ret = year + sep + month + sep + day;
	}else{
		ret = month + sep + day + sep + year;
	}
	return ret;
}



function dateParse(dataString) { 

	var re;
	
	if(haiku.h_Intl_DateFormat == haiku.kszYMD)
		re= /\d{4}\W\d{1,2}\W\d{1,2}/g;
	else 
		re= /\d{1,2}\W\d{1,2}\W\d{4}/g;
	reTime = /\d{1,2}(:\d{1,2}){1,2}\W\b(pm|PM|am|AM)\b/g;
			
	if(haiku.hasRegionalCookie == false)
		return (dataString.replace(re,function($0,$1,$2){return(convertDateString($0));}));
	else
	{
		var tmp = dataString.replace(re,function($0,$1,$2){var dateString = convertDateString($0); var dateElement = new Array( 0, 0, 0); FV.date.parseDateString(dateString, dateElement); return(FV.date.getDisplayDate(dateElement[0], dateElement[1], dateElement[2]));});
		return (tmp.replace(reTime, function($0,$1,$2){return(FV.date.getDisplayTime($0));}));
	}
}

function dateParseToGregorian(dataString) { 

	var re;
	
	if(haiku.h_Intl_DateFormat == haiku.kszYMD)
		re= /\d{4}\W\d{1,2}\W\d{1,2}/g;
	else 
		re= /\d{1,2}\W\d{1,2}\W\d{4}/g;
			
		return (dataString.replace(re,function($0,$1,$2){return(returnToGregorian($0));}));
 
}

function toLocaleCalendar(date){

	if(isHijri){
	
		date = new dateHijri().gregorianToHijri(date);
	}
	if(isHebrew){
		date = new dateHebrew().gregorianToHebrew(date);
	
	}
	
	return date;
}

function getDatePattern()
{

var pattern;

	if(haiku.h_Intl_DateFormat == haiku.kszDMY) {
		pattern = "dd/MM/yyyy";

	}else if(haiku.h_Intl_DateFormat == haiku.kszYMD){
		pattern = "yyyy/MM/dd";
	}else{
		pattern =	"MM/dd/yyyy"
	}
	
	return pattern;
}
/* ***************************************************************** */
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2010                                          */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/* ***************************************************************** */

if (false/*G_ECMIntegEnabled*/) {
    dojo.registerModulePath("quickr", "/qphtml/ecmintg/javascript/quickr");
    dojo.require("quickr.picker.util.PickerUtil");
    dojo.require("dojo.i18n");
    dojo.mixin(quickr.picker.util.PickerUtil, {
        popupDocumentPickerForCKE: function(local, quickrPopupPickerCallback) {
            dojo.requireLocalization('dijit', 'common', null, "");
            dojo.requireLocalization('dijit', 'loading', null, "");
            dojo.requireLocalization("quickr.picker", "picker", null, "ar,ca,cs,da,de,el,en,es,fi,fr,he,hr,hu,it,iw,ja,ko,nl,no,pl,pt,pt-br,ro,ru,sk,sl,sv,th,tr,uk,zh,zh-tw");
            var bundle = dojo.i18n.getLocalization("quickr.picker", "picker");

            var args = {};
            args.isMovable = true;
            args.title = bundle.popupPageTitle;
            args.browseLocale = !!local;
            args.proxyUrl = ECMIntegUtil.getProxyUrl();
            args.useInternalProxy = false;
            args.CLOSE_IMAGE = '/qphtml/ecmintg/css/images/iconClosePopUp.gif';

            var currentItem = null;

            var insertLinkCallback = function(linkType, pickerDialog) {
                if (linkType == 'summary') {
                    var url = currentItem.view;
                }
                else {
                    var url = currentItem.download;
                }

                quickrPopupPickerCallback(currentItem.title, url);
                pickerDialog.hide();
                pickerDialog.destroy();
            };

            var itemSelectedCallback = function(button, dialog, picker) {
                var item = picker.getCurrentItem();
                var label = picker.store.getLabel(item);
                var path = picker.store.getPath(item);
                var downUrl = picker.store.getValue(item, "downloadurl");
                var viewUrl = picker.store.getValue(item, "viewurl");

                var category = picker.store.getValue(item, "category");

                currentItem = {
                    title: label,
                    download: downUrl,
                    view: viewUrl
                };
            };

            var summaryAction = {
                displayText: bundle.useSummary,
                onClick: dojo.hitch(dojo.global, insertLinkCallback, 'summary'),
                onItemSelected: itemSelectedCallback
            };

            var downloadAction = {
                displayText: bundle.useMedia,
                onClick: dojo.hitch(dojo.global, insertLinkCallback, 'download'),
                onItemSelected: itemSelectedCallback
            };

            var menuAction = {
                displayText: bundle.popupPageTitle,
                displayType: 'menubutton',
                menuItems: [summaryAction, downloadAction]
            };

            var cancelAction = quickr.picker.widgets.PickerDialog.getCancelAction();

            args.actions = [menuAction, cancelAction];

            var picker = new quickr.picker.widgets.PickerDialog(args);
			var backCancelDpforCKE = {                                    //fix SPR #KZHG7XXALL
			cancel: function(){
	            if(picker.id){
				try {
				dijit.byId(picker.id).hide();
				}
				catch(e){}
				}
	         } 
			 };
		    dojo.subscribe("backCancelDpPw",backCancelDpforCKE,"cancel");
            picker.show();
        },

        popupDocumentPickerForDL: function(local, quickrPopupPickerCallback) {
            dojo.requireLocalization('dijit', 'common', null, "");
            dojo.requireLocalization('dijit', 'loading', null, "");
            dojo.requireLocalization("quickr.picker", "picker", null, "ar,ca,cs,da,de,el,en,es,fi,fr,he,hr,hu,it,iw,ja,ko,nl,no,pl,pt,pt-br,ro,ru,sk,sl,sv,th,tr,uk,zh,zh-tw");
            var bundle = dojo.i18n.getLocalization("quickr.picker", "picker");

            var args = {};
            args.isMovable = true;
            args.title = bundle.popupPageTitle;
            args.browseLocale = !!local;
            args.proxyUrl = ECMIntegUtil.getProxyUrl();
            args.useInternalProxy = false;
            args.CLOSE_IMAGE = '/qphtml/ecmintg/css/images/iconClosePopUp.gif';

            var currentItem = null;

            var insertLinkCallback = function(linkType, pickerDialog) {
                if (linkType == 'summary') {
                    var url = currentItem.view;
                }
                else {
                    var url = currentItem.download;
                }
                var store = currentItem.picker.store;
                var parent = store.fetchItemByIdentity({ identity: currentItem.remotedocId });
                var remotelibId = null;

                try {
                    while (parent != null) {
                        remotelibId = store.getIdentity(parent);
                        parent = store.getValue(parent, store.PARENT);
                    }
                }
                catch (e) {
                    remotelibId = null;
                }

                quickrPopupPickerCallback(currentItem.title, url, currentItem.qkrHost, decodeURIComponent(remotelibId), decodeURIComponent(currentItem.remotedocId));
                currentItem.picker = undefined;
                pickerDialog.hide();
                pickerDialog.destroy();
            };

            var itemSelectedCallback = function(button, dialog, picker) {
                var item = picker.getCurrentItem();
                var label = picker.store.getLabel(item);
                var path = picker.store.getPath(item);
                var downUrl = picker.store.getValue(item, "downloadurl");
                var viewUrl = picker.store.getValue(item, "viewurl");
                var category = picker.store.getValue(item, "category");

                var id = picker.store.getIdentity(item);

                currentItem = {
                    title: label,
                    download: downUrl,
                    view: viewUrl,
                    remotedocId: id,
                    qkrHost: picker.getUrl(),
                    picker: picker
                };
            };

            var summaryAction = {
                displayText: bundle.useSummary,
                onClick: dojo.hitch(dojo.global, insertLinkCallback, 'summary'),
                onItemSelected: itemSelectedCallback
            };

            var downloadAction = {
                displayText: bundle.useMedia,
                onClick: dojo.hitch(dojo.global, insertLinkCallback, 'download'),
                onItemSelected: itemSelectedCallback
            };

            var menuAction = {
                displayText: bundle.popupPageTitle,
                displayType: 'menubutton',
                menuItems: [summaryAction, downloadAction]
            };

            var cancelAction = quickr.picker.widgets.PickerDialog.getCancelAction();

            args.actions = [menuAction, cancelAction];

            var picker = new quickr.picker.widgets.PickerDialog(args);
			
			var backCancelDpforDL = {                                    //fix SPR #KZHG7XXALL
			cancel: function(){
	            if(picker.id){
				try {
				dijit.byId(picker.id).hide();
				}
				catch(e){}
				}
	         } 
			 };
		    dojo.subscribe("backCancelDpPw",backCancelDpforDL,"cancel");
			
			picker.show();
        }
    });

    var ECMIntegUtil = {
        getProxyUrl: function() {
            return "/xsp/proxy/BasicProxy";
        },

        generateId: function() {
            return "QDNext_" + Math.random() * 100000;
        }
    }
}

	


/* Copyright IBM Corp. 2008, 2010  All Rights Reserved.              */

var LRO = '\u202D';
var RLO = '\u202E';
var PDF = '\u202C';
var LRE = '\u202A';
var RLE = '\u202B';
var LRM =  '\u200E';//
           // 'I';//
var RLM = '\u200F';

var ce_segmentsPointers = new Array();
    
var cePATH = "ceFILE_PATH";    
var ceEMAIL = "ceEMAIL";    
var ceURL = "ceURL";

var ce_type // = EMAIL; //
            cePATH; //determines type of complex expression
var ceInsertAlways = false;


function isBidiChar(c){    
    if(c >= '\u0030' && c <= '\u0039')
        return true;
    return (c > '\u00ff')? true : false;
}

function isLatinChar(c){
    if(c >= '\u0041' && c <= '\u005A')
        return true;    
    if(c >= '\u0061' && c <= '\u007A')
        return true;    
    return false;    
}

    /**
     * Determines which strong characters precedes a character in a given position 
     * into the given characters buffer, with taking into consideration a position of previous 
     * left-to-right marker which is strong left-to-right character itself. 
     * According to the algorithm, if a strong character before
     * a token is left-to-right, no left-to-right marker is needed in the point.   
     *  
     */
function isCharBeforeBiDiChar(buffer, i, previous) {
    if(ceInsertAlways)
        return true;
    while (i > 0){    
        if(i == previous)
            return false;
        i--;                        
        if(isBidiChar(buffer.charAt(i)))
            return true; 
        if(isLatinChar(buffer.charAt(i)))
            return false;             
       }
   return false;       
}    

    /**
     * Removes all meta-data markers from a string 
     */
function ceStripSpecialCharacters(str) {       
    if((str == null) || (str.length == 0)) 
        return str;                  
    var buf = "";
    var character;
    var i;
    for(i = 0; i < str.length; i++){
        character = str.charAt(i);
        if((character != LRE) && (character != RLE) 
            && (character != LRM) && (character != RLM)
            && (character != LRO) && (character != RLO) &&
               (character != PDF)) {
            buf+=character;
        }
    }
            
    return buf;       
}
   
function ceParse(str){    
    var i,i1;
    var delimiters;
    var previous = -1;    
    //erase ce_segmentsPointers
    //ce_segmentsPointers = new Array();
    if(ce_segmentsPointers != null){
        for(i=0; i<ce_segmentsPointers.length; i++)
            ce_segmentsPointers[i] = null;
    }
    var sp_len = 0;    

    if(ce_type == cePATH){
        delimiters = "/\\:.";         
        for (i = 0; i < str.length; i++)
            if ((delimiters.indexOf(str.charAt(i)) >= 0) &&
                    isCharBeforeBiDiChar(str,i,previous)){
                previous = i;    
                ce_segmentsPointers[sp_len] = i;
                sp_len++;
            }        
    
    } else if(ce_type == ceURL){

           var buffer_length = str.length;
           var path_end = str.indexOf('?');
            if (path_end < 0)
                path_end = buffer_length;

            i = str.indexOf('#');
            if (i < 0)
                i = buffer_length;
            
            path_end = Math.min(path_end, i);
                        
            // parse protocol, host, path
            delimiters = "/:.";
            for (i = 0; i < path_end; i++)
                if ((delimiters.indexOf(str.charAt(i))  >= 0)  &&
                        isCharBeforeBiDiChar(str,i,previous)){
                previous = i;    
                ce_segmentsPointers[sp_len] = i;
                sp_len++;
            }                    

            // parse filename, args, reference
            delimiters = "?=&#";
            for (i = path_end; i < buffer_length; i++)
                if ((delimiters.indexOf(str.charAt(i))  >= 0)  &&
                        isCharBeforeBiDiChar(str,i,previous)){
                previous = i;    
                ce_segmentsPointers[sp_len] = i;
                sp_len++;
            }               
    } else if(ce_type == ceEMAIL){
        
        delimiters = "<>@.,;";         
        var inQuotes = false;    
        
        for(i = 0; i < str.length; i++){            
            if (str.charAt(i) == '\"') {
                if (isCharBeforeBiDiChar(str,i,previous)){
                    previous = i;    
                    ce_segmentsPointers[sp_len] = i;
                    sp_len++;
                }                    
                i++;
                i1 = str.indexOf('\"', i);
                if(i1 >= i)
                    i = i1;
                if (isCharBeforeBiDiChar(str,i,previous)){
                    previous = i;    
                    ce_segmentsPointers[sp_len] = i;
                    sp_len++;
                }                                   
            }
            
            if ((delimiters.indexOf(str.charAt(i)) >= 0) &&
                    isCharBeforeBiDiChar(str,i,previous)){
                        previous = i;    
                        ce_segmentsPointers[sp_len] = i;
                        sp_len++;
            }                                            
        }                    
    }
    
    return ce_segmentsPointers;
}   
   
   
   
    /**
     * Inserts left-to-right markers in beginning of a parsed string, if necessary 
     */
   
function ceInsertMarkers(str) {
    str = ceStripSpecialCharacters(str);
    
    ce_segmentsPointers = ceParse(str);
    
    var buf = str;
    shift = 0;                                                
    var n;
    for (i = 0; i< ce_segmentsPointers.length; i++) {
        n = ce_segmentsPointers[i];
        if(n != null){
            preStr = buf.substring(0, n + shift);
            postStr = buf.substring(n + shift, buf.length);
            //buf.insert(n + shift, LRM);
            buf = preStr + LRM + postStr;
            shift++;
        }                                  
    }
    return buf;        
}

function ceRemoveMarkers(str){
    ceInsertAlways= true;
    ce_segmentsPointers = ceParse(str);
    ceInsertAlways = false;
    
    buf = str;            
    var n;
    var shift = 0;
    for(i = 0; i < str.length; i++) {                   
        n = ce_segmentsPointers[i];
        if(n!=null)
            if(n>=0 && n<buffer.length)
                if(buf.charAt[n] == LRM){                
                    preStr = buf.substring(0, n + shift);
                    postStr = buf.substring(n + shift +1, buf.length);
                    buf = preStr + postStr;
                    shift--;
                }                            
        }                
        return buf;            
}    
   

var VK_LEFT  = 0x25;
var VK_RIGHT = 0x27;
var VK_HOME  = 0x24;
var VK_END   = 0x23;
var VK_SHIFT = 0x10;
var VK_BACK = 0x8;
var VK_DELETE = 0x2e;

var isIE;
var ce_str0;

var fOnCut = new Function("ceCutText(this);");
var fOnCopy = new Function("ceCopyText(this);");

function ceInsertMarkersforStaticString(str, ce_type1){
    ce_type = ce_type1;
    return LRE + ceInsertMarkers(str) + PDF;     
}

function ceAttach(ce_field, ce_type1){
    if (ce_field) {
    	ce_field.alt = ce_type1;
    	ceSetHandlers(ce_field);
    }
}

function ceSetHandlers(ce_field){
    ce_type = ce_field.alt;
    ce_field.dir = "ltr";
  
    if(document.body.dir == "rtl")  
        ce_field.style.textAlign =  "right";
        
    isIE =(navigator.appName == 'Microsoft Internet Explorer');

    if(isIE){
        ce_field.onkeydown = new Function("ceKeyDown(event);");
        ce_field.onkeyup = new Function("ceKeyUp(event);");
    } else {
        ce_field.onkeyup = ceKeyUp;
        ce_field.onkeydown = ceKeyDown;        
    }

    ce_field.oncut=fOnCut;
    ce_field.oncopy=fOnCopy;
    
    ce_field.value = ceInsertMarkers(ce_field.value);    
}

function ceInitFields(){
    var elements = document.getElementsByTagName("input");    
    for(var i=0; i < elements.length; i++)
        if(elements[i].alt == cePATH || elements[i].alt == ceEMAIL || elements[i].alt == ceURL)
            ceSetHandlers(elements[i]);
    
}

function ceKeyDown(event){
    isIE =(navigator.appName == 'Microsoft Internet Explorer');
    obj = (isIE) ? event.srcElement : event.target;        
    ce_type = obj.alt;
    ce_str0 = obj.value;
}

function ceKeyUp(event){

    isIE =(navigator.appName == 'Microsoft Internet Explorer');

    obj = (isIE) ? event.srcElement : event.target;
        
    str1 = obj.value;

    if(obj.alt != "")
        ce_type = obj.alt;

    ieKey = event.keyCode;

    if ((ieKey == VK_HOME)
        || (ieKey == VK_END)
        || (ieKey == VK_SHIFT))
    return;

    var cursorStart, cursorEnd;


    var selection = ceGetCaretPos(event,obj);
    if (selection) {
        cursorStart = selection[0];
        cursorEnd = selection[1];
    }


    //Jump over a cursor processing
    if(isIE) {

        var cursorStart1, cursorEnd1;
        cursorStart1 = cursorStart;
        cursorEnd1 = cursorEnd;
        
        if(ieKey == VK_LEFT){
             if ((str1.charAt(cursorEnd-1) == LRM)
               && (cursorStart == cursorEnd)
               )
                 ceSetSelectedRange(obj,cursorStart - 1,cursorEnd - 1);
             return;
        }        

        if(ieKey == VK_RIGHT){             
             if (str1.charAt(cursorEnd-1) == LRM){
                 cursorEnd1 = cursorEnd + 1;
                 if (cursorStart == cursorEnd)
                     cursorStart1 = cursorStart + 1;
             }

             ceSetSelectedRange(obj,cursorStart1,cursorEnd1);                        
             return;
        }                   
    } else { //Firefox
        if(ieKey == VK_LEFT) {
            if (str1.charAt(cursorEnd-1) == LRM)
                ceSetSelectedRange(obj,cursorStart - 1,cursorEnd - 1);
            return;
        }
        if(ieKey == VK_RIGHT) {
            if (str1.charAt(cursorEnd-1) == LRM)
                ceSetSelectedRange(obj,cursorStart + 1,cursorEnd + 1);
            return;
        }
    }
   
    str2 = ceInsertMarkers(str1);


    if(str1 != str2)
    {
        obj.value = str2;
        
        if((ieKey == VK_DELETE) && (str2.charAt(cursorEnd)==LRM))
            obj.value = str2.substring(0,cursorEnd) + str2.substring(cursorEnd+2,str2.length);             

        if(ieKey == VK_DELETE) 
            ceSetSelectedRange(obj,cursorStart,cursorEnd);
        else if(ieKey == VK_BACK){ 
                if(ce_str0.charAt(cursorEnd-1)==LRM)
                    ceSetSelectedRange(obj,cursorStart - 1,cursorEnd - 1);
                    else
                    ceSetSelectedRange(obj,cursorStart,cursorEnd);
            }
        else
        if (obj.value.charAt(cursorEnd) != LRM)
            ceSetSelectedRange(obj,cursorStart + 1,cursorEnd + 1);
    }

}

function ceProcessCopy(obj,text,isReverse){
    if(text == null) {
        if(isIE) {
            range = document.selection.createRange();
            text = range.text;
        } else
            text = obj.value.substring(obj.selectionStart,obj.selectionEnd);
    }

    textToClipboard = ceStripSpecialCharacters(text);

    if(isIE) {
        window.clipboardData.setData("Text", textToClipboard);
        return true;
    }
    else try {
        return ((window.SignedJs.ceProcessCopy(textToClipboard)) ? true : false);
    }
    catch(e){ return false;   }
}
 
function ceCopyText(obj){
    if(isIE)
        event.returnValue = false;

    return ceProcessCopy(obj,null,false);
}

function ceCutText(obj){
    var ret = ceProcessCopy(obj,null,false);
    if(!ret) 
        return false;

    if(isIE) {
        curPos = obj.selectionStart; 
        range = document.selection.clear();
    } else {
        curPos = obj.selectionStart;
        obj.value = obj.value.substring(0,curPos) + obj.value.substring(obj.selectionEnd);
        obj.setSelectionRange(curPos,curPos);
    }

    return true;

}

function ceGetCaretPos(event,obj){
    if(!isIE) 
        return new Array(event.target.selectionStart, event.target.selectionEnd);    
    else {
        var position = 0;
        var range = document.selection.createRange().duplicate();
        var range2 = range.duplicate();
        var rangeLength = range.text.length;
        
        if (obj.type == "textarea")
            range2.moveToElementText(obj);
        else
            range2.expand('textedit');

        while (range.compareEndPoints('StartToStart', range2) > 0) {
            range.moveStart('character', -1);
            ++position;
        }
        
        return new Array(position, position + rangeLength);
    }
}

function ceSetSelectedRange(obj,selectionStart,selectionEnd){
    if(isIE) {
        var range = obj.createTextRange();
        if (range) {
            if (obj.type == "textarea")
                range.moveToElementText(obj);
            else
                range.expand('textedit');

            range.collapse();            
            range.moveEnd('character', selectionEnd);
            range.moveStart('character', selectionStart);
            range.select();
        }
    } else {        
        obj.selectionStart=selectionStart;
        obj.selectionEnd=selectionEnd;
    }
}
/* Copyright IBM Corp. 2005, 2010  All Rights Reserved.              */

//-------------------------------------------------------------
// Quickr Versions library
//-------------------------------------------------------------


// true if versioning should be used.
// 8.2: h_VersionType loaded from doc, not Notes.ini
function _qp_useDocVersioning() {
	if(typeof(h_VersionType) == "undefined") {
		return false;
	}
	h_VersionType = h_VersionType.toLowerCase();
	return (h_VersionType == "explicit" || h_VersionType == "implicit");
}


dojo.require("dojo.date.locale");

var UNID_VERSION             = 0;
var VERSION_UNID             = 1;
var VERSION_FROM_DOC_UNID    = 2;
var VERSION_NUMBER           = 3;
var CREATED                  = 4;
var MODIFIED	             = 5;
var LAST_EDITOR              = 6;
var LAST_EDITOR_DISPLAY_NAME = 7;
var COMMENT                  = 8;
var UNID                     = 9;

function _qp_getVersionColumnValue(node) {
	try {
		return node.childNodes[1].childNodes[0].nodeValue;
	} catch (e) {
		return node.text;
	}
}



Date.prototype.parseDominoDateTime = function (dominoDateString) {

	var comps = dominoDateString.split('T');
	var xDate = comps[0];
	var sYear = xDate.substring(0,4);
	var sMonth = xDate.substring(4,6);
	var sDay = xDate.substring(6,8);
	var sDate = sMonth + '/' + sDay + '/' + sYear;
	var sTime = '';
	var sTimezone = '';
	if(comps.length == 2){
		var compsTime = comps[1].split(',');
		var xTime = compsTime[0];
		var sHour = xTime.substring(0,2);
		var sMinute = xTime.substring(2,4);
		var sSecond = xTime.substring(4,6);
		sTime = ' ' + sHour + ':' + sMinute + ':' + sSecond;
		var xTimeZone = compsTime[1];
		var utcHours = xTimeZone.substring(2,5);
		var utcMinutes = '00';
		if(xTimeZone.length > 5){
			utcMinutes = xTimeZone.substring(5,7);
		}
		sTimezone = ' UTC' + utcHours + utcMinutes;
	}
	return new Date(sDate + sTime + sTimezone);
	
}




function _qp_openVersionList(sId, targetDivId) {

	//if it is disabled, don't show it.
	if (_qp_useDocVersioning() == false) {
		return "";
	}
	
	
	if (typeof(targetDivId) == "undefined") {
		targetDivId = "VersionList";
	}
	
	dojo.require("dojo.date.locale");
	dojo.requireLocalization("dojo.cldr", "gregorian");
	dojo.date.locale.addCustomFormats("dojo.cldr","gregorian");


	var now = new Date();

	dojo.xhrGet({
		url: getAbsoluteRoomURL(self) + '/h_Versions/' + sId + '/?ReadViewEntries&Count=100000&StartKey=' + sId + '&timestamp=' + now.getTime(),
		handleAs:"xml",
		sync: true,
		load: function(data) {
			

			var versionListHTML = '';
			
			var relevantEntries = 0;
			

			var root = data.getElementsByTagName('viewentries')[0];
			
			var entries = root.getElementsByTagName("viewentry");

			var lastMainUNID;
			
			for (var i=0; i<entries.length; i++) {
				var entrydata = entries[i].getElementsByTagName("entrydata");

				var unid = entries[i].getAttribute('unid');

				if(entrydata.length == 1) {
					//This is a replication conflict - ignore
					continue;
				}

				var unidVersion = _qp_getVersionColumnValue(entrydata[UNID_VERSION]);

				if(unidVersion.indexOf("G") == -1) {
					lastMainUNID = _qp_getVersionColumnValue(entrydata[VERSION_UNID]);
				}


				if (unidVersion.indexOf("G") > -1 && unid != h_PageUnid && h_PageUnid == _qp_getVersionColumnValue(entrydata[VERSION_FROM_DOC_UNID])) {

					var versionNumber = parseFloat(_qp_getVersionColumnValue(entrydata[VERSION_NUMBER]));
					
					relevantEntries++;

					var comm = _qp_getVersionColumnValue(entrydata[COMMENT]);
					if(typeof(comm) == 'undefined') {
						comm = '';
					}
					comm = comm.replace(/Restored from Version/, QuickrLocaleUtil.getStringResource("VERSION.S_VersionRestoredFrom"));
					var dispname = _qp_getVersionColumnValue(entrydata[LAST_EDITOR_DISPLAY_NAME]);	
					
					var sDateTime = _qp_getVersionColumnValue(entrydata[MODIFIED]);
					
					var dModified = QuickrDateUtil.convertStringToDate(sDateTime);
					var szDateTime = QuickrDateUtil.getDateTimeString(dModified, "dateTime", "short", "");
					var szDisplayDateTime = getDisplayableDateTime( dateParse(szDateTime), " ");
					var szDisplayDate = szDisplayDateTime.substring(0, szDisplayDateTime.indexOf(" "));
					var szDisplayTime = szDateTime.substring(szDateTime.indexOf(" ")+1);
					var xdate = new Date().parseDominoDateTime(sDateTime);
					
					var sDate = dojo.date.locale.format(xdate, {formatLength:"short"});
					
					var sTime = sDate.substring(sDate.indexOf(" ") + 1);
					var sDate = sDate.substring(0, sDate.indexOf(" "));
					


					var newloc = window.location.href;
					newloc = newloc.replace(h_PageUnid, unid);



					versionListHTML += "<div class=\"VersionListEntry\">";
					
					var temp = QuickrLocaleUtil.getStringResource("VERSION.S_VersionListRevertAction");
					var tempCurrent = QuickrLocaleUtil.getStringResource("VERSION.S_VersionListCurrent");

					if(lastMainUNID == unid) {
						versionListHTML += "<a class=\"VersionListEntryRevertLink\" href=\"javascript:void();\">";
						versionListHTML += "<img src=\"/qphtml/skins/quickr8/doc_current.gif\" border=\"0\" alt=\"" + tempCurrent + "\" title=\"" + tempCurrent + "\">";
						versionListHTML += "</a>";
					}
					else {
						versionListHTML += "<a class=\"VersionListEntryRevertLink\" href=\"javascript:void _qp_revertVersion('" + unid + "');\">"
						versionListHTML += "<img src=\"/qphtml/skins/quickr8/doc_revert.gif\" border=\"0\" alt=\"" + temp + "\" title=\"" + temp + "\">";
						versionListHTML += "</a>";
					}

					
					temp = QuickrLocaleUtil.getStringResource("VERSION.S_VersionListViewAction");
					versionListHTML += "<a title=\"" + temp + "\" class=\"VersionListEntryDocLink\" href=\"" + newloc + "\">";


					versionListHTML += QuickrLocaleUtil.getStringResource("VERSION.S_VersionListEntryVersion").replace("{0}", versionNumber);
					
					versionListHTML += "</a>";
					
					
					
					temp = QuickrLocaleUtil.getStringResource("VERSION.S_VersionListEntryName");
					temp = temp.replace("{0}", dispname);
					
					//TODO - I18N these date and time formats.
					temp = temp.replace("{1}", szDisplayDate);
					temp = temp.replace("{2}", szDisplayTime);
					
					versionListHTML += "<span class=\"VersionListEntryName\">" + temp + "</span>";
					versionListHTML += "<span class=\"VersionListEntryComment\">" + comm + "</span>";

					
					
					versionListHTML += "</div>";					
					
					
				}				
				
				
			}			
			
			
			var versionList = document.getElementById(targetDivId);
			if(versionList && relevantEntries > 0) {
				versionList.innerHTML = versionListHTML;
				
				var versionListContainer = document.getElementById("VersionListContainer");
				if (versionListContainer) {
					versionListContainer.style.display="block";
				}
				
			}


		},
		mimetype: 'text/xml'
	});







}





function _qp_createVersion(sId) {

	if(sId == "activeversion") {
		alert(QuickrLocaleUtil.getStringResource("VERSION.ACTIVEVERSION"));
		return;
	}

	var frm = document.getElementById("CreateVersionForm");
	if (!frm) {

		frm = document.createElement("form");
		frm.id = "CreateVersionForm";
		frm.method = "POST";
		frm.name="h_CreateVersionForm";

		var html = "";
		html += '<input type="hidden" name="h_EditAction" value="h_Ajax">';
		html += '<input type="hidden" name="h_AllDocs" value="">';
		html += '<input type="hidden" name="h_SetCommand" value="h_CreateVersion">';
		html += '<input type="hidden" name="h_NoSceneTrail" value="1">';
		html += '<input type="hidden" name="h_PublishedUNID" value="1">';
		html += '<input type="hidden" name="h_Comment" value="">';
		html += '<input type="hidden" name="h_Nonce" value="' + getCookie("NonceToken") + '">';

		frm.innerHTML = html;
		document.body.appendChild(frm);
	}
	
	if (frm) {
		comment = prompt(QuickrLocaleUtil.getStringResource("VERSION.S_VersionNewComment"), "");
		if (comment && comment.length > 0) {
			frm.action = getAbsoluteRoomURL(self) + '/h_Toc/' + sId + '/?EditDocument';

			frm.h_PublishedUNID.value = sId;
			frm.h_Comment.value = comment;

			QPAjax_SubmitForm(	"CreateVersionForm", 
						function(data) {
							var bOK = true;
							try {
								if (data.indexOf("var h_ErrorCode = ") > -1) {
									var errCode = data.split("var h_ErrorCode = ")[1];
									errCode = errCode.substring(0,errCode.indexOf(";"));
									if (parseFloat(errCode) > 0) {
										var errMsg = data.split("var h_ErrorProblem = '")[1];
										errMsg = errMsg.substring(0,errMsg.indexOf("'"));
										bOK = false;
										alert(QuickrLocaleUtil.getStringResource("VERSION.S_VersionCreateError") + "\n\n" + errCode + ": " + errMsg);
									}
								}
							} catch (e){}

							if (bOK) {
								alert(QuickrLocaleUtil.getStringResource("VERSION.S_VersionCreateSuccess"));
								window.location.href = window.location.href;;
							}
						}, 
						function() {
							alert(QuickrLocaleUtil.getStringResource("VERSION.S_VersionCreateError"));
						}
					);	
		}
		
	}

}


function _qp_revertVersion(sId) {


	var frm = document.getElementById("RevertVersionForm");
	if (!frm) {

		frm = document.createElement("form");
		frm.id = "RevertVersionForm";
		frm.method = "POST";
		frm.name="h_RevertVersionForm";

		var html = "";
		html += '<input type="hidden" name="h_EditAction" value="h_Ajax">';
		html += '<input type="hidden" name="h_AllDocs" value="">';
		html += '<input type="hidden" name="h_SetCommand" value="h_RevertVersion">';
		html += '<input type="hidden" name="h_NoSceneTrail" value="1">';
		html += '<input type="hidden" name="h_DraftUNID" value="1">';
		html += '<input type="hidden" name="h_Nonce" value="' + getCookie("NonceToken") + '">';


		frm.innerHTML = html;
		document.body.appendChild(frm);
	}

	if (frm && confirm(QuickrLocaleUtil.getStringResource("VERSION.S_VersionRevertAreYouSure"))) {

		frm.action = getAbsoluteRoomURL(self) + '/h_Toc/' + sId + '/?OpenDocument';

		frm.h_DraftUNID.value = sId;

		QPAjax_SubmitForm (	"RevertVersionForm",	
					function(data) {
						var bOK = true;
						try {
							if (data.indexOf("var h_ErrorCode = ") > -1) {
								var errCode = data.split("var h_ErrorCode = ")[1];
								errCode = errCode.substring(0,errCode.indexOf(";"));
								if (parseFloat(errCode) > 0) {
									var errMsg = data.split("var h_ErrorProblem = '")[1];
									errMsg = errMsg.substring(0,errMsg.indexOf("'"));
									bOK = false;
									alert(QuickrLocaleUtil.getStringResource("VERSION.S_VersionRevertError") + "\n\n" + errCode + ": " + errMsg);
								}
							}
						} catch (e){}
						
						if (bOK) {
							alert(QuickrLocaleUtil.getStringResource("VERSION.S_VersionRevertSuccess"));
							window.location.href = window.location.href;;
						}
					},
					function() {
						alert(QuickrLocaleUtil.getStringResource("VERSION.S_VersionRevertError"));
					}
				);	
	}

}

function _qp_writeVersionActions() {
	if ((currentUserAccess > 2) && _qp_useDocVersioning()) {
		var isDraft = (h_IsPublished == "1" ? false : true);
		if (!isDraft && typeof h_DraftVersionUNID != "undefined" && h_DraftVersionUNID != "") {
			isDraft = true;
		}
		if ((typeof(_qp_createVersion) != "undefined") && (!isDraft) && (typeof(h_ReadOnly) != "undefined") && (h_ReadOnly == "") && (h_VersionType == "explicit")) {
			if(typeof( h_VersionUNID ) == "undefined" || h_VersionUNID.indexOf("_") != -1) {
				szLink = "javascript:_qp_createVersion('" + h_PageUnid + "');";
			}
			else {
				szLink = "javascript:_qp_createVersion('activeversion');";
			}
			AddSceneAction(QuickrLocaleUtil.getStringResource("VERSION.S_VersionCreate"), szLink);
		}
		if (typeof(_qp_revertVersion) != "undefined" && typeof(h_ReadOnly) != "undefined" && h_ReadOnly != "") {
			var szLink = "javascript:_qp_revertVersion('" + h_PageUnid + "');";
			AddSceneAction(QuickrLocaleUtil.getStringResource("VERSION.S_VersionRevert"), szLink);
		}
	}
}
/*********************************************************************/
/*                                                                   */
/* IBM Confidential                                                  */
/*                                                                   */
/* OCO Source Materials                                              */
/*                                                                   */
/* Copyright IBM Corp. 2005, 2010                                    */
/*                                                                   */
/* The source code for this program is not published or otherwise    */
/* divested of its trade secrets, irrespective of what has been      */
/* deposited with the U.S. Copyright Office.                         */
/*                                                                   */
/*********************************************************************/

//-------------------------------------------------------------
// global vars used to control dynamic toc behaviour

// Class names indicate whether ajax request is necessary
var TWISTY_CLASS			= "h-img-twisty"
var TWISTY_CLASS_AJAX	= "h-img-ajaxTwisty"
						 
// twist and folder states
var COLLAPSED 				=  0;
var EXPANDED  				=  1;
var NONE      				=  2;
var LOADING      			=  3;
var SELECTED      		=  4;
var RESTRICTED      		=  5;

// standard width of the icons
var ICON_WIDTH 				= 14;


//TODO - START - probably need a mechanism to translate these strings???
var twistImgAlt = new Array();
twistImgAlt[COLLAPSED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.EXPAND");
twistImgAlt[EXPANDED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.COLLAPSE");
twistImgAlt[NONE] 			= "";

var folderImgAlt = new Array();
folderImgAlt[COLLAPSED] 	= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER");
folderImgAlt[EXPANDED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER");
folderImgAlt[NONE] 			= "";
folderImgAlt[SELECTED] 		= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER_SELECTED");
folderImgAlt[RESTRICTED] 	= QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER_RESTRICTED");
//TODO - END


//images to be used for the expand/collapse twisties in the TOC
var twistImg = new Array();
twistImg[COLLAPSED]  		= "/qphtml/html/common/folder_twist_open.gif";
twistImg[EXPANDED] 			= "/qphtml/html/common/folder_twist_close.gif";
twistImg[NONE] 				= "/qphtml/html/common/transparent.gif";
twistImg[LOADING] 			= "/qphtml/html/common/ajax_loader.gif";
								  
var twistImgTag = new Array();
twistImgTag[COLLAPSED] 		= "<img style='padding-left:%PLpx;' class='" + TWISTY_CLASS_AJAX + "' src='" + twistImg[COLLAPSED] + "' width='" + ICON_WIDTH + "' border='0' align='middle' title='" + twistImgAlt[COLLAPSED] + "' alt='" + twistImgAlt[COLLAPSED] + "' onclick='javascript:twist(this,%d);'/>";
twistImgTag[EXPANDED] 		= "<img style='padding-left:%PLpx;' class='" + TWISTY_CLASS + "' src='" + twistImg[EXPANDED] + "' width='" + ICON_WIDTH + "' border='0' align='middle' title='" + twistImgAlt[EXPANDED] + "' alt='" + twistImgAlt[EXPANDED] + "' onclick='javascript:twist(this,%d);'/>";
twistImgTag[NONE] 			= "<img style='padding-left:%PLpx;' src='" + twistImg[NONE] + "' width='" + ICON_WIDTH + "' border='0' height='1' align='middle' title='" + twistImgAlt[NONE] + "' alt='" + twistImgAlt[NONE] + "' />";



//images to be used for the open/close Folders in the TOC
var folderImg = new Array();
folderImg[COLLAPSED] 	= "/qphtml/html/common/folder_close.gif";
folderImg[EXPANDED] 		= "/qphtml/html/common/folder_open.gif";
folderImg[NONE] 			= "/qphtml/html/common/transparent.gif";
folderImg[SELECTED] 		= "/qphtml/html/common/folder_selected.gif";
folderImg[RESTRICTED] 	= "/qphtml/html/common/folder_closed_grayed.gif";
		
var folderImgTag = new Array();
folderImgTag[COLLAPSED] 	= "<img src='" + folderImg[COLLAPSED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[COLLAPSED] + "' alt='" + folderImgAlt[COLLAPSED] + "' />";
folderImgTag[EXPANDED] 		= "<img src='" + folderImg[EXPANDED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[EXPANDED] + "' alt='" + folderImgAlt[EXPANDED] + "' />";
folderImgTag[NONE] 			= "<img src='" + folderImg[NONE] + "' border='0' align='middle' width='" + ICON_WIDTH + "' height='1' title='" + folderImgAlt[NONE] + "' alt='" + folderImgAlt[NONE] + "' />";
folderImgTag[SELECTED] 	= "<img src='" + folderImg[SELECTED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[SELECTED] + "' alt='" + folderImgAlt[SELECTED] + "' />";
folderImgTag[RESTRICTED] 	= "<img src='" + folderImg[RESTRICTED] + "' border='0' align='middle' valign='middle' title='" + folderImgAlt[RESTRICTED] + "' alt='" + folderImgAlt[RESTRICTED] + "' />";

var goUpIconTag = '<img src="/qphtml/html/common/goup.gif" align="absbottom" width=12 height=16 alt="" border="0" />';

// Image for (sub)folder
var imgFolder = "";
dojo.addOnLoad(function(){
	window.imgFolder = encodeURIComponent(GetDocTypeIconImgTag(D_QPTypeFolder));
});

var g_parentUnid=null;
var g_parentTwisty=null;
var g_parentDiv=null;
var g_parentLevel=0;

// Twisty folder expansion functions
var twistExpFunc = new Array();
twistExpFunc[0] = addFoldersToToc;
twistExpFunc[1] = addFoldersToSelector;

//-------------------------------------------------------------------
// addTocItemObj( ):
//    called from the toc component, this is the main entry point to
//    the dynamic table of contents infrastructure.
//    Appends a TOC node to the TOC div in the DOM.
//
// Arguments:
//		name   : the plain text name of the toc item
//		url    : the url the pointed to by the toc item
//		icon   : the reprensenting icon img tag of the toc item
//    level  : the hierarchy level of the toc item
//    state  : the current twist (collapsed/expanded) state of the toc item
//		type   : the type of toc item, as follows:
//						D_QPTypePage					"0"
//						D_QPTypeFolder					"1"
//						D_QPTypeRoomSettings				"2"
//						D_QPTypeRoom					"3"
//						D_QPTypeError					"4"
//						D_QPTypeAreaType				"5"
//		selected: true|false whether the toc item is selected or not.
//
function addTocItemObj(name, unid, url, icon, level, state, type, selected, sysName, bCanPublish, bNewWindow)
{
	var toc=document.getElementById("toc");
	var item=getTocItemNode(name, unid, url, icon, level, state, type, selected, sysName, bCanPublish, bNewWindow);
	if (toc && item)
	{
		toc.appendChild(item);
	}
}

// Generates DOM element for a TOC item
function getTocItemNode(name, unid, url, icon, level, state, type, selected, sysName, bCanPublish, bNewWindow)
{
	var iEF = 0;
	var bIsSelected = selected || false;
	var bCanDragTo = (typeof bCanPublish == 'undefined' ? false : bCanPublish);
	icon = decodeURIComponent(icon);
	try {
		name = decodeURIComponent(name);
	} catch (e) {}
	if (name == QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.GO_UP")) {
		icon = goUpIconTag;
	}

	// default twisty and icon images
	var twisty = twistImgTag[NONE];

	// set twisty anchor and image to  + or - for toc items with state of collapse or expand
	if ( state == EXPANDED || state == COLLAPSED )
	{
		twisty = twistImgTag[state].replace(/%d/g, iEF.toString());
		icon = folderImgTag[state];
	}

	// Determine whether this TOC item represents a folder
	var bIsFolder = (type == "1" && icon.indexOf("folder_") > -1);

	// Get appropriate icon if folder
	if (bIsFolder) {
		if (!bCanDragTo && currentUserAccess > 2) {
			// User access above Reader, but can't drag to THIS folder
			icon = folderImgTag[RESTRICTED];
		}
		else if (bIsSelected) {
			// Show folder "open"
			icon = folderImgTag[EXPANDED];
		}
	}

	// indentation for expandable items
	var indentPx = level * 10;
	twisty = twisty.replace(/%PL/, indentPx);

	// link elements for anchor
	var itemHref  = ' href="' + url + '" ' 
	var itemClass = bIsSelected ? '" class="tocSelected-text" ' : '';

	// Create anchor for TOC item
	var anchor = '<a' + itemHref + itemClass + (bNewWindow ? ' TARGET="_blank" ' : '')+ '>' + icon + QuickrGeneralUtil.encodeEntities(name)	+ '</a>'; // BBXSS Change
	
	var tocClass = (bIsSelected ? 'tocSelected-bg' : 'toc-bg') + (bIsFolder ? ' dropTarget' : '');
	var tocTitle = (bIsFolder ? QuickrLocaleUtil.getStringResource("DYNAMIC_TOC.FOLDER") : '');

	// Now create the DOM element itself:
	var tocItem = document.createElement("div");
	tocItem.id = (bIsFolder ? sysName : '');
 	tocItem.className = tocClass;
 	tocItem.style.display = "block";
	tocItem.title = tocTitle;
	tocItem.setAttribute("unid", unid);
	tocItem.setAttribute("level", level);
	tocItem.innerHTML = twisty + anchor;

	if (bIsFolder && bCanDragTo && currentUserAccess > 2) {
		// Make this folder a drop target
		QP_DragAndDrop_initDropTarget(tocItem);
	}

	return tocItem;
}


//-------------------------------------------------------------------
//
var G_greenFolder = null;

function addFolderSelectorObj(name, sysName, unid, url, level, state, bCanPublish)
{
	var toc=document.getElementById("folderSelector");
	var item=getFolderSelectorNode(name, sysName, unid, url, level, state, bCanPublish);
	if (toc && item)
	{
		toc.appendChild(item);
	}
}

// Generates DOM element for a Folder selector
function getFolderSelectorNode(name, sysName, unid, url, level, state, bCanPublish)
{
	// default twisty and icon images
	var twisty = twistImgTag[NONE];
	var icon = decodeURIComponent(imgFolder);

	// set twisty anchor and image to  + or - for toc items with state of collapse or expand
	if ( state == EXPANDED || state == COLLAPSED )
	{
		twisty = twistImgTag[state].replace(/%d/g, "1");
		icon = folderImgTag[state];
	}

	// indentation for expandable items
	var indentPx = level * 10;
	twisty = twisty.replace(/%PL/, indentPx);
	

	
	// Create anchor for folder selector
	if (bCanPublish) {
		var anchor = '<a onclick="' + url + 'makeMeGreen(this);" href="javascript:void(0)">' + icon + name + '</a>';
	}
	else {
		// Publishing not allowed: change icon & disable click action
		icon = folderImgTag[RESTRICTED];
		anchor = '<a onclick="' + G_FolderSectionAction_CantPublish + '" href="javascript:void(0)">' + icon + name + '</a>';
	}
	
	// Now create the DOM element itself:
	var tocItem = document.createElement("div");
	tocItem.id = sysName;
 	tocItem.className = "toc-bg";
 	tocItem.style.display = "block";
	tocItem.title = name;
	tocItem.setAttribute("unid", unid);
	tocItem.setAttribute("level", level);
	tocItem.innerHTML = twisty + anchor;

	return tocItem;
}

// NOTE: This function must exist in order for the default folder to be highlighted!
function hiliteFolderSelectorByUnid(unid)
{
	var fsel=document.getElementById("folderSelector");
	if (fsel) {
		var divs=fsel.getElementsByTagName("div");
		for (var i=0; i<divs.length; i++) {
			if (divs[i].getAttribute("unid") == unid) {
				var a = divs[i].getElementsByTagName("a");
				if (a[0]) {
					makeMeGreen(a[0]);
				}
			}
		}
	}
}

function makeMeGreen(me)
{
	var imgs = me.getElementsByTagName("img");
	if (imgs[0]) {
		if (G_greenFolder != null)
			G_greenFolder.src = folderImg[COLLAPSED];
		imgs[0].src = folderImg[SELECTED];
		G_greenFolder = imgs[0];
	}
}

// Called when a folder twisty is clicked
function twist(obj, i)
{
	if (obj.alt==twistImgAlt[EXPANDED])
		showHideAllSubF(obj, false);
	else
		expSubF(obj, i);
}

// Expand subfolder(s), requesting data from server if necessary
function expSubF(twisty, iExpFunc)
{
	if (twisty.className == TWISTY_CLASS_AJAX) {
		// Need to request subfolder data from server: get parent UNID
		var unid=twisty.parentNode.getAttribute("unid");
		if (unid) {
			// Set parent folder data for use by callback function
			g_parentTwisty=twisty;
			g_parentDiv=twisty.parentNode;
			g_parentLevel=parseInt(g_parentDiv.getAttribute("level"));
			g_parentUnid=g_parentDiv.getAttribute("unid");
			  
			// Request next-level subfolder data asynchronously
			ajax = new QPAjax();
			
			// Fix the problem JROE8889NW and KSAA7WTDFX
			var tmpURL = location.href.replace("?EditDocument&", "../../cf07bfcad7af887a0525670800167221/ce6a3d6b1f546c9405256708001671ff/?OpenDocument&");
			// SPR#JROE8889NW: backed out "fix" for KSAA7WTDFX below because this generated a malformed URL - 8/12/10 Bill R
			ajax.RequestJS((tmpURL + "&Form=h_FolderJSON&charset=utf-8&nowebcaching&PreSetFields=h_ParentUnid;"+unid),
			// SPR#KSAA7WTDFX
			//ajax.RequestJS((location.hostname + location.pathname + "?OpenDocument" + "&Form=h_FolderJSON&charset=utf-8&nowebcaching&PreSetFields=h_ParentUnid;"+unid),
								twistExpFunc[iExpFunc],
								"get",
								expSubFError);
			  
			// Change twisty icon to show data is loading
			twisty.src=twistImg[LOADING];
		}
	}
	else {
		// Subfolders already there - simply show
		showHideAllSubF(twisty, true);
	}
}

// Handle no data returned from server
function expSubFError(error)
{
	setTwistyObj(g_parentTwisty, COLLAPSED);
}

function sortbyitemstitle(x, y)
{
  	if(x.item.title > y.item.title)   return   -1;  
  	else   if(x.item.title < y.item.title)   return   1;  
  	else   return   0;   
}

// Callback: Create TOC item for each JSON data element in the response
function addFoldersToToc(data)
{
	g_parentTwisty.className = TWISTY_CLASS;	// so won't request data next time

	var items = data.items;
	items.sort(sortbyitemstitle);
	for (var i=0; i < items.length; i++) 
	{
		var item=items[i].item;
		
		if (typeof (item.unid) == "undefined" && typeof (item.ancestry) != "undefined") {
			var tmp = item.ancestry.split("~");
			item.unid = tmp[tmp.length-1];
		}		

		var tocItem=getTocItemNode(
			 item.title,
			 item.unid,
			 "../../h_Toc/" + item.unid + "/?OpenDocument",
			 imgFolder,
			 g_parentLevel+1,
			 (item.hasSubfolder=="1" ? COLLAPSED : NONE),
			 item.type,
			 false,
			 item.SystemName,
			 (item.canAddDocs=="1" || currentUserAccess >= 6));

		var tocDiv=document.getElementById("toc");

		if (tocItem && tocDiv && g_parentDiv) {
			if (div=getNextSiblingByTag(g_parentDiv, "div")) {
				// Insert item before next item
				tocDiv.insertBefore(tocItem, div);
			}
			else {
				// ...or at end, if there is no next item
				tocDiv.appendChild(tocItem);
			}

			// Change parent's twisty
			setTwistyObj(g_parentTwisty, EXPANDED);
		}
	}
}

// Callback: Create folder selector for each JSON data element in the response
function addFoldersToSelector(data)
{
	g_parentTwisty.className = TWISTY_CLASS;	// so won't request data next time

	var numAdded = 0;

	var items = data.items;
	for (var i=0; i < items.length; i++) 
	{
		var item=items[i].item;

		if (item.subStyle == "h_List" || item.subStyle == "h_ForumBoard") {
			// Don't show lists or fourms
			continue;
		}

		var proxyUnid = ((h_PublishedVersionUNID == "") ? h_PageUnid : h_PublishedVersionUNID);
		
		//SPR:#JSHN7QETQE 
		var tmpTitle = item.title;
		tmpTitle = replaceStr(tmpTitle, "&#39;", "&#92;&#39;"); //&#92;&#39; are escape characters of \'
		tmpTitle = replaceStr(tmpTitle, '&quot;', '&#92;&#34;'); //&#92;&#34; are escape characters of \"
		// ADD hierarchy of this parent folder
		var url = "javascript:setFolderName(" + "'" + item.SystemName + "'," +
			 "'" + item.unid			+ "'," +
			 "'" + tmpTitle			+ "'," +
			 "'" + item.style			+ "'," +
			 "'" + item.sortOrder	+ "'," +
			 "'" + item.sortColumn	+ "'," +
			 "'" + item.ancestry + "~" + proxyUnid + "'," +
			 "'" + g_parentUnid  + "'," +
			 true + "," +
			 false +
			 ");";

		var tocItem=getFolderSelectorNode(
			 item.title,
			 item.SystemName,
			 item.unid,
			 url,
			 g_parentLevel+1,
			 (item.hasSubfolder=="1" ? COLLAPSED : NONE),
			 (item.canAddDocs=="1" || currentUserAccess >= 6));

		var tocDiv=document.getElementById("folderSelector");

		if (tocItem && tocDiv && g_parentDiv) {
			if (div=getNextSiblingByTag(g_parentDiv, "div")) {
				// Insert item before next item
				tocDiv.insertBefore(tocItem, div);
			}
			else {
				// ...or at end, if there is no next item
				tocDiv.appendChild(tocItem);
			}
			numAdded++;
		}
	}

	// Change parent's twisty
	setTwistyObj(g_parentTwisty, (numAdded > 0 ? EXPANDED : NONE));
}

// Show or hide all subfolders under parent folder
function showHideAllSubF(twisty, bShow)
{
	g_parentDiv=twisty.parentNode;
	g_parentLevel=parseInt(g_parentDiv.getAttribute("level"));

	// TOC item to start at
	var div=getNextSiblingByTag(twisty.parentNode, "div");
	 
	while (div != null
			 && (lev=div.getAttribute("level")) != null
			 && parseInt(lev) > g_parentLevel)
	{
		if (bShow) {
			if ((ch0=div.childNodes[0]) && ch0.tagName=="IMG" && ch0.className==TWISTY_CLASS)
 				setTwistyObj(ch0,EXPANDED);
			div.style.display="block";
		}
		else {
			div.style.display="none";
		}
		div=getNextSiblingByTag(div, "div");
	}

	setTwistyObj(twisty,(bShow ? EXPANDED : COLLAPSED));
}

// Set twisty element to reflect state
function setTwistyObj(obj, state)
{
	obj.src = twistImg[state];
	obj.alt = twistImgAlt[state];
	obj.title = obj.alt;
}

// Get next sibling with specified tag.
function getNextSiblingByTag(obj, tag)
{
	var szTag=tag.toUpperCase();
	for (sib=obj.nextSibling; sib != null; sib=sib.nextSibling) {
		if (sib.nodeName.toUpperCase()==szTag)
			return sib;
	}
	return null;
}
/* Copyright IBM Corp. 2005, 2010  All Rights Reserved.              */

// SPR #TEDS6N6RZY: load controls from external script file, to avoid need for user activation (MS workaround for KB912945).
// See http://msdn.microsoft.com/library/default.asp?url=/workshop/author/dhtml/overview/activating_activex.asp
// 04/04/06 Bill Rodrick

function _qp_WriteHtml(theHTML)
{
	document.write(theHTML);
	return true;
}


var qp_ImageProcessText = "";

/****************************************
* Used by the Dojo controls to write
* the new image controls in the popup
* form.
****************************************/
function qp_writeDojoNewImageControls(sProgText) {

	this.qp_ImageProcessText = sProgText;
	
	var uri = dojo.uri.dojoUri("../dojowidgets/widget/templates/newimagecontrols.html");
	qp_writeDojoExternalHtml(uri);
}
function qp_writeDojoExternalHtml(sFile) {

	if (typeof(dojo) != "undefined") {
		dojo.require("dojo.widget.ContentPane");
		document.write("<div dojoType=\"ContentPane\" href=\"" + sFile + "\" executeScripts=\"true\"></div>");
	}
}

function getFiles(){
	var sFiles = '';
	if (h_ClientBrowser.hasActiveX ()) {
		sFiles = theForm.UploadControl.Attachment_Names.toLowerCase();
	}else{
		var oSelect = document.getElementById('SelID');
		var aOption = oSelect.getElementsByTagName("option");
		for (i = 0; i < aOption.length; i++){
			sValue = aOption[i].value.toLowerCase();
			iLS = sValue.lastIndexOf('\\') + 1;
			if(i != 0){
				sFiles += ',';
			}
			sFiles += sValue.substring(iLS,sValue.length);
		}
	}
	return sFiles;
}

function getWidgetId(){
	var sLocation = location.href;
	iWL = sLocation.lastIndexOf('=') + 1;
	return sLocation.substring(iWL,sLocation.length);
}

function checkFields(theForm){
	var isOk = true;
	var alertText = '';
	
	if(theForm.h_Name.value == ''){
		isOk = false;
		alertText += top.MSG_TITLE + '\n';
	}
	
	var sFiles = getFiles();
	if(sFiles.indexOf(',') > -1){
		alertText += top.MSG_ATTACH_ONE_IMAGE_FILE;
		isOk = false;
	}else if(sFiles == '' || (sFiles.indexOf('.gif') == -1 && sFiles.indexOf('.png') == -1 && sFiles.indexOf('.jpg') == -1 && sFiles.indexOf('.jpeg') == -1)){
		alertText += top.MSG_ATTACH_ONE_IMAGE_FILE;
		isOk = false;
	}
		
	if(!isOk){
		alert(top.MSG_COMPLETE_FIELDS + '\n\n' + alertText);
	}else{
		
	}
	return isOk;
}

function QDK_HTMLImageForm_OnSubmitHandlerCallback(theForm){
	return checkFields(theForm);
}

function QDK_HTMLImageForm_OnLoadHandlerCallback(theForm){
	document.getElementById('titleHL').style.display = 'block';
	document.getElementById('attachmentRead').style.display = 'none';
	document.getElementById('attachmentEdit').style.display = 'block';
	document.getElementById('attachmentControlTR').style.display = 'block';
}

function submitImageForm(){
	if(checkFields(theForm)){
		//Set global widget name
		parent.g_CurrentWidget = getWidgetId();
		
		abPreSubmitCalled = true;
		theForm.h_SetEditNextScene.value="";
		var publishOption = new Array ("","","","","");
		var bNeedsPublishLocation = false;
		var bIsNewDoc = (h_IsNewDoc == "1");
		var folderName = theForm.h_CurrentFolderName.value;
		
		var s = 'h_Jump';

		for (var i=0;i<formObj.fieldDef.length;i++) {
			s = formObj.fieldDef[i].submitLogic(self, s, i, publishOption);
			if (s == false) {
				return;
			}
		}
		
		for (var i=0; i<publishOption.length; i++) {
			if (publishOption[i] != ""){
				theForm.h_PublishOptions.value = (theForm.h_PublishOptions.value == "") ? publishOption[i] : theForm.h_PublishOptions.value + ", " + publishOption[i];
			}
		}
		
		theForm.h_NoSceneTrail.value = "0";
			
		setAnimation("h_StdPageAnimation");
		if (putAway.publishFolderName == "" && (h_Form!="0AD3FAE32A9296D10525670800167241" && h_Form!="BD931F9B1EE77301852567D6006AF8B4")) {
			publishToCurrentFolder();
		}
		
		putAway.publishAction = "h_Publish";
		s = "h_Next";
		
		theForm.h_EditAction.value = s;
		CommonFormPreSubmit( theForm);
		
		
		//hide the main frame
		var divMain = parent.dojo.byId("qp_newimage_mainpage");
		divMain.style.visibility = "hidden";
		
		//show the progress bar
		var divProg = parent.dojo.byId("qp_newimage_progress");
		divProg.innerHTML = this.qp_ImageProcessText;
		divProg.style.display = "block";
		
		
		setTimeout("theForm.submit();",200);
		

	
		return;
	}
}

function cancelImageForm(){
	abPreSubmitCalled = true;
	theForm.h_SetEditNextScene.value="";
	var publishOption = new Array ("","","","","");
	var bNeedsPublishLocation = false;
	var folderName = theForm.h_CurrentFolderName.value;
	
	theForm.h_SetPublishAction.value = "h_Discard";
	s = "h_Next";
	theForm.h_SetReturnURL.value = '<script type="text/javascript">location.href="' + "../../"+(h_Context_InFolder==1 && h_Context_InFolderProxyDocUnid==h_ReturnToPage?'h_Toc':(h_Context_InFolder==1?h_Context_InFolderName:'h_Toc'))+"/"+h_ReturnToPage+"/?OpenDocument&Form=h_PrintUI" + "" + '";<\/script>';
	
	theForm.h_EditAction.value = s;
	CommonFormPreSubmit( theForm);
	theForm.submit();
	parent.dojo.widget.byId('NewImage').hide();
	
	return;
}

function qp_adjustRTEText(sText) {
	/* Code automatically adds the default font face so that it shows properly in the font name
	* selection list */
	//spr#JSHN7QFU9T
  	if(dojo.isIE){
			dojo.getComputedStyle=function(node,_1cf,_1d0){
			    	node=dojo.byId(node);
						if(!node||!node.style ){
							return _1d0;
						}
						if(!node.currentStyle)
							return  "";
						else
							return node.currentStyle[_1cf];
			};
	}
	
	if (sText == "") {
		var sFace = "";
		var sSize = "";
		
		if (G_RTE_DefaultFontFace != "") {
			sFace = " face=\"" + G_RTE_DefaultFontFace + "\" ";
		}
		
		if (G_RTE_DefaultFontSize != "") {

			var aSize = ["xx-small","x-small","small","medium","large","x-large","xx-large"];
			for (var i = 0; i < aSize.length; i++) {
				if (G_RTE_DefaultFontSize.toLowerCase() == aSize[i]) {
					sSize = "  size=\"" + (i+1) + "\" ";
					break;
				}
			}
		}
		
		if (sSize.length > 0 || sFace.length > 0) {
			sText = "<font " + sFace + sSize + " >&nbsp;</font>";
		}
	}	

	return sText;
}

function adjustToggleHtmlEditing(rte){
	rte.toggleHtmlEditing =	function() {
		// summary: toggle between WYSIWYG mode and HTML source mode
		if(this===dojo.widget.Editor2Manager.getCurrentInstance()){
			if(!this._inSourceMode){
				var html = this.getEditorContent();
				this._inSourceMode = true;

				if(!this._htmlEditNode){
					this._htmlEditNode = dojo.doc().createElement("textarea");
					dojo.html.insertAfter(this._htmlEditNode, this.editorObject);
				}

				this._htmlEditNode.style.display = "";

				if ( dojo.render.html.ie70 || dojo.render.html.ie60 ) {
					this._htmlEditNode.style.width = "100%";
				}else{
					this._htmlEditNode.style.width = "100% ! important";
				}

				this._htmlEditNode.style.height = "300px";
				this._htmlEditNode.value = html;

				//activeX object (IE) doesn't like to be hidden, so move it outside of screen instead
				with(this.editorObject.style){
					position = "absolute";
					left = "-2000px";
					top = "-2000px";
				}
			}else{
				this._inSourceMode = false;

				//In IE activeX mode, if _htmlEditNode is focused,
				//when toggling, an error would occur, so unfocus it
				this._htmlEditNode.blur();

				with(this.editorObject.style){
					position = "";
					left = "";
					top = "";
				}
				var html = this._htmlEditNode.value;

				dojo.lang.setTimeout(this, "replaceEditorContent", 1, html);
				this._htmlEditNode.style.display = "none";
				this.focus();
			}
			this.onDisplayChanged(null, true);
		}
	};
}

function qp_adjustRTESelection(rte) {

	if ( typeof(rte) != "undefined" ) {
	
		if ( dojo.render.html.ie60 || dojo.render.html.ie70 ) {
			/* Manually check if the height is less than minHeight in ie since it does't truely support minheight
			* Also another fix for IE so you click to focus the rte anywhere in the editor (not just the first line of content
			* From here: http://dojotoolkit.org/pipermail/dojo-contributors/2007-February/006367.html
			*/
			var getLengthInPixels = function(element, value) {
				if (/px$/.test(value)) return parseInt(value);
				var sLeft = element.style.left;
				var rsLeft = element.runtimeStyle.left;
				element.runtimeStyle.left = element.currentStyle.left;
				element.style.left = value || 0;
				value = element.style.pixelLeft;
				element.style.left = sLeft;
				element.runtimeStyle.left = rsLeft;
				return value;
			};

			var minHeightInPx = getLengthInPixels( rte.domNode , rte.minHeight );

			var newHeight = (rte._lastHeight > minHeightInPx)?rte._lastHeight+"px":rte.minHeight;
			rte.editorObject.style.height = newHeight;
			var divWrapper = rte.document.body.getElementsByTagName('div')[0]; //dojo only puts the div rte content wrapper in IE
			divWrapper.style.height = newHeight;

			//fix for PMR 76105,999,760
			//override the onFocus to format this the way we want...
			rte.onFocus_orig = rte.onFocus;
			rte.onFocus = function(e) {
				//call the original dojo focus code...
				rte.onFocus_orig(e);
				if (this._initialFocus) {
					this._initialFocus = false;
					
					// here add the paragraph style
					var elmSty = this.document.createElement("STYLE");
					elmSty.setAttribute("type", "text/css");
					elmSty.styleSheet.cssText = "p{margin:0em 0px}";
					this.document.getElementsByTagName("head")[0].appendChild(elmSty);
				}
			}
			
			//fix for SPR #CRAY7QW3B4
			//override the replaceeditor content for IE.  Not working correctly...
			rte.replaceEditorContent_orig = rte.replaceEditorContent;
			rte.replaceEditorContent = function(/*String*/html){
				this.editNode.innerHTML = this._preFilterContent(html);
			}
			
			//fix for PMR 44663,487,000
			//override the onKeyDown to handle special keys...
			rte.onKeyDown_orig = rte.onKeyDown;
			rte.onKeyDown = function(e) {
				//call the original dojo onKeyDown code...
				rte.onKeyDown_orig(e);
			
				//we have to handle special keys, such as arrows, Home, End, PgUp, PgDn,
				//so as to update the status of style drop down explicitly in IE
				if ((33 <= e.keyCode) && (e.keyCode <= 40)) {
					rte.onKeyPress(e);
				}
			}
			
			//fix for PMR 44663,487,000
			//override the queryCommandValue to handle formatblock command...
			rte.queryCommandValue_orig = rte.queryCommandValue;
			rte.queryCommandValue = function(command) {
				if(command.toLowerCase() == "formatblock") {
					// in IE, we have to return tag name instead of style name(e.g. Normal),
					// otherwise the style drop down will be blank.
					var found = false;
					var formats = ['p', 'div', 'pre', 'address', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'];
					var parentElement = this.document.selection.createRange().parentElement();
					var parentTag = parentElement.tagName.toLowerCase();

					// keep trying to find expected tag untill meet body tag
					// may be low efficency?
					while (parentTag!="body") {
						for (var i = 0; i < formats.length; i++) {
							if ( parentTag == formats[i] ) {
								found = true;
								break;
							}
						}

						if (found) break;

						parentElement = parentElement.parentElement;
						parentTag = parentElement.tagName.toLowerCase();
					}

					return parentTag;
				}
				else {
					//call the original dojo queryCommandValue code...
					return rte.queryCommandValue_orig(command);
				}
			}
			
			//spr#YXIO7N5B5T
      
			if(dojo.render.html.ie70)
			{
				adjustToggleHtmlEditing(rte);
			}
			
			//SPR:#CLOH7LY64F

			rte.execCommand_orig = rte.execCommand;
			rte.execCommand = function(command,argument) {
				if(command.toUpperCase() == "INSERTHTML") {
					if(rte.object)
					{
						return rte.execCommand_orig(command,argument);
					}
					else
					{
						rte.focus();
						if(dojo.render.html.ie){
							var insertRange = this.document.selection.createRange();
							if(this.document.selection.type.toUpperCase() == "CONTROL"){
								//if selection is controlrange, no pasteHTML is available,
								//we replace the outerHTML directly
								for(var i=0;i<insertRange.length;i++){
									insertRange.item(i).outerHTML = argument;
								}
							}
							else
							{
								insertRange.pasteHTML(argument);
								insertRange.select();
							}
							return true;
						}else{
							return this.document.execCommand(command, false, argument);
						}
					}

				}
				else {
					return rte.execCommand_orig(command,argument);
				}
			}


			//SPR:#MPUL7EUC7E
			rte.focus_orig = rte.focus;
			rte.focus = function() {
				if(this.iframe && !dojo.render.html.ie) 
				{
					rte.focus_orig();
				}
				else if(this.object)
				{ 
					rte.focus_orig();
				}
				else if(this.editNode && this.editNode.focus)
				{ 
					//this.editNode.focus(); -> causes IE to scroll always (strict and quirks mode) to the top the Iframe 
					// if we fire the event manually and let the browser handle the focusing, the latest  
					// cursor position is focused like in FF                         
					this.iframe.fireEvent('onfocus', document.createEventObject()); // createEventObject only in IE 				
				}
				else
				{
					rte.focus_orig();
				}
			}


		} else {
		
			//let's change the toggleHtmlEditing function.  It's having some trouble with height.. --> SPR #JHHO79PDTW
			adjustToggleHtmlEditing(rte);
			if (dojo.render.html.moz) {
				//override the queryCommandValue to handle formatblock command...
				rte.queryCommandValue_orig = rte.queryCommandValue;
				rte.queryCommandValue = function(command) {
					//call the original dojo queryCommandValue code...
					var returnVal = rte.queryCommandValue_orig(command);

					// In firefox, queryCommandValue will return empty string if the parent element is div
					// So we have to return div explicitly
					if(command.toLowerCase() == "formatblock" && returnVal=="") {
						return "div";
					}
					else {
						return returnVal;
					}
				}
			}
		}
				
		//SPR # SHYN7LHU6D - sets the default font/face if specified in the qpconfig.
		dojo.addOnLoad(function(){setTimeout("qp_adjustRTEIfBlank();",10);});

	}
	
		
	//hide the spellcheck icon if we're offline --> SPR #DDZG777AS8
	if (drF_isOffline()) {
		dojo.addOnLoad(function(){
			var interval;
			if (dojo.render.html.ie60 || dojo.render.html.ie70) {
				interval = 1;
			} else {
				interval = 500;
			}

			setTimeout("qp_hideSpellCheckIcon()", interval);	

		});
	}


}

function qp_adjustRTEIfBlank() {
	if (typeof oRText != "undefined" && oRText.getEditorContent().length == 0 && window.PageBody.length == 0) {
		if (G_RTE_DefaultFontFace.length > 0 || G_RTE_DefaultFontSize.length > 0) {
			oRText.replaceEditorContent(qp_adjustRTEText(""));
		}
	}
}

function qp_hideSpellCheckIcon() {
	//loop through the images and hide the spellcheck icons if we're offline --> SPR #DDZG777AS8
	for (var i = document.images.length - 1; i >= 0; i--) {
		var img = document.images[i];

		if (img.src.indexOf("spellcheck.gif") > -1) {

			//hide the containing table
			var pnode = img;
			while (pnode && pnode.tagName.toLowerCase() != "table") {
				pnode = pnode.parentNode;
			}

			if (pnode.tagName.toLowerCase() == "table") {
				pnode.style.display = "none";
			}

		}
	}
}



function qp_useDojoEditor() {
	/* Used for the Wikis and Blogs to flag whether to use a textarea or the dojo rt editor */	
	return (!usesAccessibleTheme_ClientBrowserObject() && (h_ClientBrowser.isIE() || h_ClientBrowser.isGecko()));
	
}




/*************************************************
* Code to correct the actions menu for the wikis
*************************************************/

dojo.addOnLoad(function(){
	try{
		if (typeof(h_FavoredForm) != "undefined" && h_FavoredForm != null && h_FavoredForm == G_FormIDs.WikiFormUNID) {
		//it's a wiki page, need to massage the actions
		
			var sHREF = "";
			var oParent;
			var aElements = document.getElementsByTagName("a");
			for (var i=0; i < aElements.length; i++){
				sHREF = aElements[i].getAttribute("href");

				if (sHREF != null) {
					// Remove Delete item from menu
					if(sHREF.indexOf(":abPreSubmit('h_Discard')") > -1 ||
						sHREF.indexOf("FM.view.removeChecked") > -1) {
						aElements[i].parentNode.removeChild(aElements[i]);
					}
				}
			}
				
	
		}
	}catch(e){}
	
});


//if the xss is enabled, then there will be an extra \ in front of quotes due to quirk on backend.  Correct it here...
dojo.addOnLoad(function(){
	if (typeof G_XSSProtectionEnabled != "undefined" && G_XSSProtectionEnabled == true) {
		var aReplace = ["newsbody","h_taskContent","h-taskListContent","dragDiv","dragTable"];

		for (var ii = 0; ii < aReplace.length; ii++) {
			var elBody = document.getElementById(aReplace[ii]);
			if (elBody) QuickrGeneralUtil.massageSecurityDomNode(elBody);
		}
	}
	
});


/***********************************
* Code to put in a scroller for the 
* ToC if it is too long
***********************************/
function qp_getElementsByClassName(className, tag, elm){
	var testClass = new RegExp("(^|\\s)" + className + "(\\s|$)");
	var tag = tag || "*";
	var elm = elm || document;
	var elements = (tag == "*" && elm.all)? elm.all : elm.getElementsByTagName(tag);
	var returnElements = [];
	var current;
	var length = elements.length;
	for(var i=0; i<length; i++){
		current = elements[i];
		if(testClass.test(current.className)){
			returnElements.push(current);
		}
	}
	return returnElements;
}

function qp_adjustTocWidth() {

	var alltags = qp_getElementsByClassName("qpg_tocBackground");
	
	for (var i = 0; i < alltags.length; i++) {
		var node = alltags[i];
		
		var nodewidth = 0;
		var windowwidth = document.body.clientWidth;
		
		windowwidth = windowwidth *.90;
		
		if (h_ClientBrowser && h_ClientBrowser.isIE()) {
			nodewidth = node.offsetWidth;
		}

		if (nodewidth == 0) {
			nodewidth = 800;
		}
	
	
		var isNewTag = false;

		var divtag = node.parentNode;
		if (divtag.nodeName.toLowerCase() != "div") {
			divtag = document.createElement("div");
			divtag.id = "qp_TocSlider";
			isNewTag = true;
		}

		if (nodewidth > windowwidth) {

			divtag.style.overflowX = "scroll";
			divtag.style.overflowY = "auto";
			divtag.style.width = windowwidth + "px";
			
			if (isNewTag) {
				var subtag = node.cloneNode(true);
				divtag.appendChild(subtag);		
				node.parentNode.insertBefore(divtag, node);
				node.parentNode.removeChild(node);
			}
			
		} else if (!isNewTag) {
			divtag.style.overflowX = "auto";
			divtag.style.overflowY = "auto";
			divtag.style.width = "100%";
		
		}
	}	
}


function qp_setOnResize() {

	var qp_prev_resize = window.onresize;
	if (typeof(qp_prev_resize) == "function") {
		window.onresize = function() {
			qp_prev_resize();
			qp_adjustTocWidth();
		}
	} else {
		window.onresize = qp_adjustTocWidth;
	}

}


//qp_setOnResize();
//setTimeout("qp_adjustTocWidth();", 2000);





/****************************************
* This is used to tell Quickr to always 
* use the legacy rich text editor.
* 
* When set to false (default): The Dojo
* editor will show for IE and Firefox
*
* When set to true: The legacy 
* proprietary editors will show.
*
* NOTE - For IE7, setting this to true
* will result in a simple textarea since 
* IE7 no longer supports the DHTML 
* controls.
****************************************/
var QPUseLegacyRichTextEditor = false;


dojo.addOnLoad(function(){
	if (h_CurrentSkinName == 'h_R8GenevaSkin' && h_CurrentSkinType == 'h_Edit') {
		var el = document.getElementById("workspace");
		if (el) el.style.width = "900px";
	}
});



// ***********
//
// MAP OBJECT
//
// ***********

function KeyValue( key, value ) {
	this.key = key;
	this.value = value;
}
function Map() {
	this.array = new Array();
}
Map.prototype.put = function( key, value ) {
	if( ( typeof key != "undefined" ) && ( typeof value != "undefined" ) ) {
		var found = false;
		for( var k = 0 ; k < this.array.length ; k++ ) {
		    if( this.array[k].key == key ) {
			this.array[k].value = value;
			found = true;
			break;
		    }
		}
		if (!found) {
			this.array[this.array.length] = new KeyValue( key, value );
		}
	}
}
Map.prototype.get = function( key ) {
	for( var k = 0 ; k < this.array.length ; k++ ) {
		if( this.array[k].key == key ) {
			return this.array[k].value;
		}
	}
	return null;
}
Map.prototype.length = function() {
	return this.array.length;
}


// ***************************
//
// PROFILES SERVER INTEGRATION
//
// ***************************

// Person menu function to override default one
function QP_PersonMenu_PSI(szDN, szCN)
{ 
	var fixedName = QP_ContextMenu_fixName(szDN);
	// Inherit from QP_ContextMenu
	this.base = QP_ContextMenu;
	this.base(fixedName);
}


var ProfilesIntegration =
{
	//cache to store already downloaded names
	nameMap: new Map(),
	
	defSvcLoc: "/profiles/portalJS/portalBizCard.js",
	//SPR:#KCLU7XUU34
	serviceURL: (G_ProfileServer=="" ? "" : (G_ServerIsHttps ? "https://" : "http://") + G_ProfileServer)
					+ (G_SemanticTagServiceLoc=="" ? this.defSvcLoc : G_SemanticTagServiceLoc),
	loop: 0,

	init: function() {
		if (G_ProfileServer != "") {
			QP_PersonMenu.prototype = new QP_ContextMenu;
			QP_PersonMenu = QP_PersonMenu_PSI;
			dojo.addOnLoad(function(){
				if (typeof(Quickr81SupportUtil)=="undefined") {
					// Run in separate thread,
					// but don't do if 8.1 theme because Ajax-ified page content
					// has not necessarily loaded at this point.
					// 8.1 theme code takes care of this.
					setTimeout("ProfilesIntegration.enablePage();",500);
				}
			});
		}
	},
	
	
	enablePage: function() {
		// Enable on entire page
		this.addPCardTags();
		this.loadSemTagSvc();
	},

	enableElement: function(id) {
		// Enable inside containing element
		this.addPCardTags(dojo.byId(id));
		this.activatePCardTags(id);
	},

	activatePCardTags: function(id) {
		if (typeof SemTagSvc != "undefined" && SemTagSvc) {
			SemTagSvc.parseDom(null,id);
		}
	},

	makeNameForPCard: function(cn,dn,url,mail,bMenu) {

		var html="";
		if (cn != "Anonymous" && cn != "") {
			bCM = (typeof(bMenu)=="undefined" ? true : bMenu);
			var html='<span class="vcard" title="'+dn+'">';
			html += (url ? '<a class="fn" href="'+url+'">'+cn+'</a>' : cn);
			if (bCM) {
				html += '<img alt="" class="h-contextMenu-icon" width="16" height="16" src="/qphtml/html/common/clear_pixel.gif"/>';
			}
			html += '<span class="email" style="display: none;">'+mail+'</span></span>';
		}
		return html;
	},
	
	// Add Javlin tags to member names to enable person cards
	addPCardTags: function(elm) {
		
		var elm = elm || document;
		
		//we need to get all of the person tags	
		var alltags = qp_getElementsByClassName("h-user-anchor", "*", elm);
		
		for (var i = alltags.length - 1; i >= 0; i--) {
			var node = alltags[i];
			
			var atag = node.getElementsByTagName("A")[0];
			if (atag != null)
			{
				atag.className += " fn";
			
				var span = document.createElement("span");
				span.className = "email";
				span.style.display = "none";
			
				var key = atag.href;
				if (key.indexOf("&") > -1) {
					key = key.substring(key.indexOf("&"));		
				}
			
				if (key.indexOf(";") > -1) {
					key = key.substring(key.lastIndexOf(";")+1);		
				}
				key = unescape(key);
			
				var result = this.nameMap.get(key);
				
				if (result == null) {
					// Request data to get email address
					try {
						dojo.xhrGet ({
							url:		atag.href + "&Form=h_MemberXml&nowebcaching",
							handleAs: "xml",
							load: function (data) {
											ProfilesIntegration.processMemberData(data, span, key, node, true);},
							sync: true
						});
					}
					catch(e) {
					}
				}
				else {
					// name already in Map
					this.processMemberData(result, span, key, node, false)
				}
			}
		}
	},
	
	processMemberData: function(data, span, key, node, forceStore) {
		// got member data - store email addr and modify member HTML on page
		if (forceStore) {
			this.nameMap.put(key, data);
		}
		
		var email = getTagValue(data, "qp_member", "email");
		
		//only update the link if we found an email address
		if (email != "") {
			span.innerHTML = email;
			node.className = "vcard";
			node.appendChild(span);
		}
	},
	
	
	loadSemTagSvc: function() {
	
		var head = document.getElementsByTagName("HEAD")[0];
		var tag;
		
		if (typeof(SemTagSvc) == "undefined") {
			if (this.loop == 0) {
				tag = document.createElement("script");
				tag.setAttribute("type", "text/javascript");
				tag.setAttribute("src", this.serviceURL);
				head.appendChild(tag);
			}
			
			//too many loops, it isn't loaded in 5 seconds.  just abort it.
			if (this.loop <= 25) setTimeout("ProfilesIntegration.loadSemTagSvc()",200);
		}
		// SPR #BOAI825KV3 - no longer needed for Connections Server 2.5
		//	else {
		//		SemTagSvc.init();
		//	}
		this.loop++;
	}

};

// Initialize it
ProfilesIntegration.init();




//done to deal with cached strings from previous releases
function qp_MakeDojoStringsCacheCompliant() {
	if (typeof dojo == "undefined") {
		setTimeout("qp_MakeDojoStringsCacheCompliant();", 1000);
	} else {
	
		if (typeof dojo.hostenv != "undefined") {
			dojo.hostenv.loadPath_orig = dojo.hostenv.loadPath;
			dojo.hostenv.loadPath = function() {
				if (arguments.length == 0) arguments.length = 1;
				var relpath = arguments[0];

				//new code to make sure the string js files are cache compliant
				if ( relpath.indexOf("Strings.js") > -1 && typeof G_CacheCompliantUrlTemplate != "undefined" && typeof QuickrGeneralUtil != "undefined" ) {
					relpath = QuickrGeneralUtil.decodeEntities(G_CacheCompliantUrlTemplate).replace("{0}", relpath);
				}

				//in case the number of arguments from the orig function ever changes, just pass 10 in...
				arguments.length = 10;
				return dojo.hostenv.loadPath_orig(relpath, arguments[1], arguments[2], arguments[3], arguments[4], arguments[5], arguments[6], arguments[7], arguments[8], arguments[9]);

			}
		}
	}
}
qp_MakeDojoStringsCacheCompliant();



//this will hide any activex objects, which do not respect the zindex.
if (dojo.isIE) {
	dojo.require_internalFromQpWrite = dojo.require;
	dojo.require = function() {
		dojo.require_internalFromQpWrite.apply(this, arguments);
		
		if (arguments[0] == "dijit.Dialog") {
			//go ahead and override the show and hide for the dialog
			
			if (dijit.Dialog && typeof dijit.Dialog.prototype.show_internalFromQpWrite == "undefined") {
				dijit.Dialog.prototype.show_internalFromQpWrite = dijit.Dialog.prototype.show;
				dijit.Dialog.prototype.show = function() {
					var obj = dojo.query("object", dojo.body());
					if (dojo.isArray(obj)) {
						for (var ii = 0; ii < obj.length; ii++) {
							obj[ii].style.visibility = "hidden";
						}
					}
					this.show_internalFromQpWrite.apply(this, arguments);					
					if(h_ClientBrowser.isIE6()) {
						var viewport = dijit.getViewport();
						var mb = dojo.marginBox(this.domNode);
						var left=Math.floor((viewport.l + (viewport.w - mb.w)/2)) + "px";
						this.domNode.style.left = left;
					}
				}
				
				dijit.Dialog.prototype.hide_internalFromQpWrite = dijit.Dialog.prototype.hide;
				dijit.Dialog.prototype.hide = function() {
					this.hide_internalFromQpWrite.apply(this, arguments);
					
					var obj = dojo.query("object", dojo.body());
					if (dojo.isArray(obj)) {
						for (var ii = 0; ii < obj.length; ii++) {
							obj[ii].style.visibility = "visible";
						}
					}
					
				}
			}
		}
	
	}
}




//hides everything but the page content when loaded inside an iframe...
function q_HandleLegacyUINewTheme() {

	var bReact = false;
	if (typeof QuickrCookieUtil != "undefined") {
		var sCook = QuickrCookieUtil.getCookie("q_dlgopen");
		bReact = (sCook && sCook.length > 0);
	}
	
	if (bReact) {
		var hideTheme = false;
		var loadFrameToMain = false;

		try {
			if (window.location.href != window.parent.location.href) {
				if (window.location.href.toLowerCase().indexOf("/lotusquickr/main.nsf") > -1) {
					loadFrameToMain = true;
				} else {
					if (window.parent.location.href.indexOf(".nsf") > -1) {
						hideTheme = true;
					}

					
				}
			}
			
		} catch (e) {}
		
		dojo.addOnLoad( 
			function() {
				//hide the "Done" button when in a lightbox
				var hideBack = (
					(typeof h_SystemName != "undefined" && h_SystemName == "h_Security") ||
					(typeof h_SetEditNextScene != "undefined" && h_SetEditNextScene == "h_SecurityRemove")
				);

				if (true == hideBack) {
					var aLinks = document.links;
					for (var ii = document.links.length - 1; ii >= 0; ii--) {
						if (document.links[ii].href && document.links[ii].href.indexOf("h_Back") > -1) {
							var pNode = document.links[ii].parentNode;
							pNode.removeChild(document.links[ii]);
							while (pNode && pNode.innerHTML == "") {
								var ppNode = pNode.parentNode;
								ppNode.removeChild(pNode);
								pNode = ppNode;
							}
						}
					}
				}

				//which scenes do we need to redirect to close the dialog
				var aScenes = ["h_SecurityAdd","h_SecurityRemove","h_StdConfirmRoomDeleteAnimation","h_StdConfirmRoomMove"];
				var handleRoomUI = (dojo.indexOf(aScenes, h_SetEditNextScene) > -1);

				if (true == handleRoomUI) {
					if (typeof window.CommonFormPreSubmit == "function") {
						window.CommonFormPreSubmit_qrd = window.CommonFormPreSubmit;
						window.CommonFormPreSubmit = function(theForm) {
						
							if (typeof theForm.h_SetEditNextScene =="undefined" || theForm.h_SetEditNextScene.value.length == 0) {

								//if it's not there, go ahead and create it.
								if (typeof theForm.h_SetReturnURL == "undefined") {
									var ret = null;
									try {
										ret = document.createElement("<input name=\"h_SetReturnURL\" type=\"hidden\">");
									} catch (ee) {}
									
									if (ret == null) {
										ret = dojo.doc.createElement("input");
										ret.name = "h_SetReturnURL";
										ret.type = "hidden";
									}
									
									theForm.appendChild(ret);
								}
								
								var sAction = "closedialog";
								if ("h_StdConfirmRoomDeleteAnimation" == h_SetEditNextScene) {
									sAction = "gotoparent";
								} else 
								if ("h_StdConfirmRoomMove" == h_SetEditNextScene) {
									sAction = "closedialogandreload";
								}
																
								if (theForm.h_SetReturnURL) {
									var loc = (window.parent.location.href + "#").split("#")[0];
									loc = loc.substring(loc.indexOf("//") + 2);
									if (typeof serverClusterPrefix != "undefined" && serverClusterPrefix.length > 0) {
										loc = loc.substring(loc.indexOf("/") + 1);
									}
									loc = loc.substring(loc.indexOf("/"));
									theForm.h_SetReturnURL.value = loc + "&Form=q_LoginReturn&nowebcaching&specialEvent=" + sAction;
								}
							}


							window.CommonFormPreSubmit_qrd(theForm);
						}
					}
				}
			}
	
		);
		
		
		
		if (true == loadFrameToMain) {
			document.write(	"<div style=\"" +
								"position: absolute;" +
								"top: 0px;" +
								"left: 0px;" +
								"overflow: hidden;" +
								"z-index: 200;" +
								"background-color: #FFFFFF;" +
								"width: 100%;" +
								"height: 2000px;" +
							"\"></div>" );
			
			dojo.addOnLoad(
				function() {
					window.parent.location.href = window.location.href;
				}
			);
		}
	
	
	
	
		if (true == hideTheme) {
			
			var sWrite = ".lotusBanner {display:none!important}\n";
			sWrite += "#lotusFrame {min-width:0px!important}\n";
			
			var aHide = ["lotusFooter","lotusTitleBar","lotusColLeft","lotusPlaceBar"];
			for (var ii = 0; ii < aHide.length; ii++) {
				
				sWrite += "#" + aHide[ii] + " {display:none!important}\n";
			}

			document.write("<style>" + sWrite + "</style>");
			
			dojo.addOnLoad( 
				function() {
						try {
							var oHeadLoc = document.getElementsByTagName("head");
							if (oHeadLoc.length > 0) {
								oHeadLoc = oHeadLoc[0];
								
								var aLinks = window.parent.document.getElementsByTagName("link");
								for (var ii = 0; ii < aLinks.length; ii++) {
									if (typeof aLinks[ii].rel != "undefined" && aLinks[ii].rel == "stylesheet") {
										var styleNode = document.createElement("link");
										styleNode.setAttribute("href",aLinks[ii].href);
										styleNode.setAttribute("type","text/css");
										styleNode.setAttribute("rel","stylesheet");
										oHeadLoc.appendChild(styleNode);
									}
									
								}
							}
							
						} catch (ee) {
							//console.log(ee);
						}
				}
			);
		
		}
	}
}

q_HandleLegacyUINewTheme();
